/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.xtext.widget.property;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.utils.DirectEditorsUtil;
import org.eclipse.papyrus.infra.properties.ui.modelelement.DataSource;
import org.eclipse.papyrus.infra.properties.ui.modelelement.DataSourceChangedEvent;
import org.eclipse.papyrus.infra.properties.ui.modelelement.EMFModelElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.IDataSourceListener;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ModelElement;
import org.eclipse.papyrus.infra.properties.ui.widgets.AbstractPropertyEditor;
import org.eclipse.papyrus.uml.properties.xtext.XtextLanguageEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractXtextPropertyEditor
extends AbstractPropertyEditor
implements IDataSourceListener {
    protected EObject elementToEdit = null;
    protected String language;
    protected XtextLanguageEditor xtextEditor = new XtextLanguageEditor();

    public AbstractXtextPropertyEditor(String language, Composite parent, int style) {
        this.xtextEditor.createWidget(parent, style);
        this.language = language;
    }

    protected void doBinding() {
        super.doBinding();
        ModelElement element = this.input.getModelElement(this.propertyPath);
        this.xtextEditor.setContext(element);
        if (element instanceof EMFModelElement) {
            EMFModelElement emfElement = (EMFModelElement)element;
            this.elementToEdit = emfElement.getSource();
            this.registerChangeListeners(element);
            this.display();
        }
    }

    protected abstract void registerChangeListeners(ModelElement var1);

    protected void registerObservable(ModelElement element, String observableName) {
        IObservable observable = element.getObservable(observableName);
        if (observable != null) {
            observable.addChangeListener((IChangeListener)this);
        }
    }

    public void handleChange(ChangeEvent event) {
        this.display();
        super.handleChange(event);
    }

    public void display() {
        IDirectEditorConfiguration configuration = DirectEditorsUtil.findEditorConfiguration((String)this.language, (Object)this.elementToEdit, null);
        String initialText = configuration.getTextToEdit((Object)this.elementToEdit);
        this.xtextEditor.setInput(initialText);
    }

    protected void applyReadOnly(boolean readOnly) {
        this.xtextEditor.setReadOnly(readOnly);
    }

    protected void unhookDataSourceListener(DataSource oldInput) {
        super.unhookDataSourceListener(oldInput);
        oldInput.removeDataSourceListener((IDataSourceListener)this);
    }

    protected void hookDataSourceListener(DataSource newInput) {
        super.hookDataSourceListener(newInput);
        newInput.addDataSourceListener((IDataSourceListener)this);
    }

    public void dataSourceChanged(DataSourceChangedEvent event) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                AbstractXtextPropertyEditor.this.doBinding();
            }
        });
    }
}

