/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.util.xmladapters;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.CollectionWrapper;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.LinkV2;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.exceptions.JPARSException;
import org.eclipse.persistence.jpa.rs.util.CollectionProxy;
import org.eclipse.persistence.jpa.rs.util.IdHelper;
import org.eclipse.persistence.jpa.rs.util.xmladapters.ReferenceAdapterV2;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class RestCollectionAdapter<T extends PersistenceWeavedRest>
extends XmlAdapter<CollectionWrapper<T>, Collection<T>> {
    protected PersistenceContext context;

    public RestCollectionAdapter() {
    }

    public RestCollectionAdapter(PersistenceContext context) {
        this.context = context;
    }

    public Collection<T> unmarshal(CollectionWrapper<T> v) throws Exception {
        if (v == null) {
            return null;
        }
        ArrayList<PersistenceWeavedRest> result = new ArrayList<PersistenceWeavedRest>();
        if (v.getLinks() != null && !v.getLinks().isEmpty()) {
            for (LinkV2 link : v.getLinks()) {
                if (!link.getRel().equals("self") || link.getHref() == null) continue;
                return this.loadItems(link.getHref());
            }
        }
        if (v.getItems() != null) {
            ReferenceAdapterV2<PersistenceWeavedRest> referenceAdapter = new ReferenceAdapterV2<PersistenceWeavedRest>(this.context);
            for (PersistenceWeavedRest item : v.getItems()) {
                if (this.context != null) {
                    result.add(referenceAdapter.unmarshal(item));
                    continue;
                }
                result.add(item);
            }
        }
        return result;
    }

    public CollectionWrapper<T> marshal(Collection<T> v) throws Exception {
        if (v == null || v.isEmpty()) {
            return null;
        }
        CollectionWrapper result = new CollectionWrapper();
        if (v instanceof CollectionProxy) {
            CollectionProxy restCollection = (CollectionProxy)((Object)v);
            result.setLinks(restCollection.getLinks());
        }
        return result;
    }

    private Collection loadItems(String href) throws Exception {
        String uri = href.replace("\\/", "/");
        uri = uri.substring(uri.indexOf("entity/"));
        uri = uri.substring(uri.indexOf("/") + 1);
        String[] uriItems = uri.split("/");
        String entityType = uriItems[0];
        String entityId = uriItems[1];
        String attributeName = uriItems[2];
        ClassDescriptor descriptor = this.context.getDescriptor(entityType);
        Object id = IdHelper.buildId(this.context, descriptor.getAlias(), entityId);
        T entity = this.getObjectById(entityType, id);
        DatabaseMapping attributeMapping = descriptor.getMappingForAttributeName(attributeName);
        if (attributeMapping == null || entity == null) {
            throw JPARSException.databaseMappingCouldNotBeFoundForEntityAttribute(attributeName, entityType, entityId, null);
        }
        return (Collection)attributeMapping.getRealAttributeValueFromAttribute(attributeMapping.getAttributeValueFromObject(entity), entity, (AbstractSession)this.context.getServerSession());
    }

    private T getObjectById(String entityType, Object id) throws Exception {
        Object entity = this.context.find(null, entityType, id, null);
        if (entity != null) {
            return (T)((PersistenceWeavedRest)entity);
        }
        throw JPARSException.objectReferredByLinkDoesNotExist(entityType, id);
    }
}

