/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.core.data;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.php.profile.core.PHPProfileCoreMessages;

public class ProfilerGlobalData {
    public static final String URL_NOT_AVAILABLE_MSG = PHPProfileCoreMessages.ProfilerGlobalData_0;
    private String fURI = "";
    private String fQuery = "";
    private String fOptions = "";
    private String fPath = "";
    private int fTimeSeconds = 0;
    private int fTimeMicroSeconds = 0;
    private int fDataSize = 0;
    private int fFileCount = 0;
    private ArrayList<String> fFileNames;
    private String fOriginalURL;
    private static final int CONVERTION = 1000000;

    public ProfilerGlobalData() {
        this.fFileNames = new ArrayList();
    }

    public ProfilerGlobalData(String uri, String originalURL, String query, String options, String path, int timeSeconds, int timeMicroSeconds, int dataSize, int fileCount, ArrayList<String> fileNames) {
        this.fURI = uri;
        this.fOriginalURL = originalURL;
        this.fQuery = query;
        this.fOptions = options;
        this.fPath = path;
        this.fTimeSeconds = timeSeconds;
        this.fTimeMicroSeconds = timeMicroSeconds;
        this.fDataSize = dataSize;
        this.fFileCount = fileCount;
        this.fFileNames = fileNames;
    }

    public String getURI() {
        return this.fURI;
    }

    public String getOriginalURL() {
        if (this.fOriginalURL == null) {
            return this.getURIFromQuery();
        }
        return this.fOriginalURL;
    }

    public void setOriginalURL(String originalURL) {
        this.fOriginalURL = originalURL;
    }

    public String getOptions() {
        return this.fOptions;
    }

    public void setOptions(String options) {
        this.fOptions = options;
    }

    public void setURI(String uri) {
        this.fURI = uri;
    }

    public String getQuery() {
        return this.fQuery;
    }

    public void setQuery(String query) {
        this.fQuery = query;
    }

    public String getPath() {
        return this.fPath;
    }

    public void setPath(String path) {
        this.fPath = path;
    }

    public int getTimeSeconds() {
        return this.fTimeSeconds;
    }

    public void setTimeSeconds(int timeSeconds) {
        this.fTimeSeconds = timeSeconds;
    }

    public void setTimeMicroSeconds(int timeMicroSeconds) {
        this.fTimeMicroSeconds = timeMicroSeconds;
    }

    public int getTimeMicroSeconds() {
        return this.fTimeMicroSeconds;
    }

    public int getFileCount() {
        return this.fFileCount;
    }

    public void setFileCount(int fileCount) {
        this.fFileCount = fileCount;
    }

    public void addFileName(String fileName) {
        this.fFileNames.add(fileName);
    }

    public void setFileNames(String[] names) {
        this.fFileNames = new ArrayList<String>(Arrays.asList(names));
    }

    public int getDataSize() {
        return this.fDataSize;
    }

    public void setDataSize(int dataSize) {
        this.fDataSize = dataSize;
    }

    public double getGlobalTime() {
        double time = ((double)this.fTimeSeconds * 1000000.0 + (double)this.fTimeMicroSeconds) / 1000000.0;
        return time;
    }

    public double getGlobalTimeInMilli() {
        return this.getGlobalTime() * 1000.0;
    }

    public String[] getFileNames() {
        String[] names = new String[this.fFileNames.size()];
        this.fFileNames.toArray(names);
        return names;
    }

    public void removeFileName(String fileName) {
        int i = 0;
        while (i < this.fFileNames.size()) {
            String file = this.fFileNames.get(i);
            if (file.endsWith(fileName)) {
                this.fFileNames.remove(i);
                --this.fFileCount;
                break;
            }
            ++i;
        }
    }

    protected String getURIFromQuery() {
        String code = "original_url=";
        String uri = "";
        if (this.fQuery.indexOf(code) != -1) {
            uri = this.fQuery.substring(this.fQuery.indexOf(code) + code.length());
        } else if (this.fOptions.indexOf(code) != -1) {
            uri = this.fOptions.substring(this.fOptions.indexOf(code) + code.length());
        }
        if (uri.equals("")) {
            uri = URL_NOT_AVAILABLE_MSG;
        }
        return uri;
    }
}

