/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.codegen.qvti.analyzer;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.cgmodel.CGModelFactory;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariableExp;
import org.eclipse.ocl.examples.codegen.generator.CodeGenerator;
import org.eclipse.qvtd.codegen.qvti.java.QVTiCodeGenerator;
import org.eclipse.qvtd.codegen.qvticgmodel.CGFunction;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMapping;
import org.eclipse.qvtd.codegen.qvticgmodel.CGTypedModel;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTypedModel;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;

public class QVTiAnalyzer
extends CodeGenAnalyzer {
    private final @NonNull Map<@NonNull Function, @NonNull CGFunction> cgFunctions = new HashMap<Function, CGFunction>();
    private final @NonNull Map<@NonNull Mapping, @NonNull CGMapping> cgMappings = new HashMap<Mapping, CGMapping>();
    private final @NonNull Map<@NonNull ImperativeTypedModel, @NonNull CGTypedModel> cgTypedModels = new HashMap<ImperativeTypedModel, CGTypedModel>();

    public QVTiAnalyzer(@NonNull QVTiCodeGenerator codeGenerator) {
        super((CodeGenerator)codeGenerator);
    }

    public void addFunction(@NonNull Function pFunction, @NonNull CGFunction cgFunction) {
        this.cgFunctions.put(pFunction, cgFunction);
    }

    public void addMapping(@NonNull Mapping pMapping, @NonNull CGMapping cgMapping) {
        this.cgMappings.put(pMapping, cgMapping);
    }

    public void addTypedModel(@NonNull ImperativeTypedModel pTypedModel, @NonNull CGTypedModel cgTypedModel) {
        this.cgTypedModels.put(pTypedModel, cgTypedModel);
    }

    public @NonNull CGVariableExp createCGVariableExp(@NonNull CGVariable cgVariable) {
        CGVariableExp cgVariableExp = CGModelFactory.eINSTANCE.createCGVariableExp();
        cgVariableExp.setTypeId(cgVariable.getTypeId());
        cgVariableExp.setAst(cgVariable.getAst());
        cgVariableExp.setReferredVariable(cgVariable);
        cgVariableExp.setRequired(cgVariable.isRequired());
        return cgVariableExp;
    }

    public @NonNull QVTiCodeGenerator getCodeGenerator() {
        return (QVTiCodeGenerator)super.getCodeGenerator();
    }

    public @Nullable CGFunction getFunction(@NonNull Function pFunction) {
        return this.cgFunctions.get(pFunction);
    }

    public @Nullable CGMapping getMapping(@NonNull Mapping pMapping) {
        return this.cgMappings.get(pMapping);
    }

    public @Nullable CGTypedModel getTypedModel(@NonNull ImperativeTypedModel pTypedModel) {
        return this.cgTypedModels.get(pTypedModel);
    }
}

