/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtm2qvts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.qvtd.compiler.CompilerProblem;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionProblem;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.ClassDatumAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcore.NavigationAssignment;
import org.eclipse.qvtd.pivot.qvtcore.QVTcorePackage;
import org.eclipse.qvtd.pivot.qvtcore.VariableAssignment;
import org.eclipse.qvtd.pivot.qvtcore.analysis.DomainUsage;
import org.eclipse.qvtd.pivot.qvtcore.analysis.RootDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreUtil;
import org.eclipse.qvtd.pivot.qvtschedule.CastEdge;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.ComposedNode;
import org.eclipse.qvtd.pivot.qvtschedule.DependencyNode;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.ErrorNode;
import org.eclipse.qvtd.pivot.qvtschedule.ExpressionEdge;
import org.eclipse.qvtd.pivot.qvtschedule.InputNode;
import org.eclipse.qvtd.pivot.qvtschedule.IteratedEdge;
import org.eclipse.qvtd.pivot.qvtschedule.IteratorNode;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.NullNode;
import org.eclipse.qvtd.pivot.qvtschedule.OperationNode;
import org.eclipse.qvtd.pivot.qvtschedule.PatternTypedNode;
import org.eclipse.qvtd.pivot.qvtschedule.PatternVariableNode;
import org.eclipse.qvtd.pivot.qvtschedule.PredicateEdge;
import org.eclipse.qvtd.pivot.qvtschedule.QVTscheduleFactory;
import org.eclipse.qvtd.pivot.qvtschedule.RecursionEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.TrueNode;
import org.eclipse.qvtd.pivot.qvtschedule.UnknownNode;
import org.eclipse.qvtd.pivot.qvtschedule.VariableNode;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class RegionUtil
extends QVTscheduleUtil {
    public static boolean containsNone(@NonNull Iterable<@NonNull Node> firstNodes, @NonNull Iterable<@NonNull Node> secondNodes) {
        for (Node firstNode : firstNodes) {
            for (Node secondNode : secondNodes) {
                if (firstNode != secondNode) continue;
                return false;
            }
        }
        return true;
    }

    public static @NonNull NavigableEdge createCastEdge(@NonNull Node sourceNode, @NonNull Property source2targetProperty, @NonNull Node targetNode) {
        Role phase = RegionUtil.mergeToLessKnownPhase((Role)RegionUtil.getNodeRole((Node)sourceNode), (Role)RegionUtil.getNodeRole((Node)targetNode));
        assert (phase != null);
        Role edgeRole = phase;
        CastEdge castEdge = QVTscheduleFactory.eINSTANCE.createCastEdge();
        castEdge.initialize(edgeRole, sourceNode, source2targetProperty.getName(), targetNode);
        castEdge.initializeProperty(source2targetProperty);
        return castEdge;
    }

    public static @NonNull NavigableEdge createEdge(@NonNull Role edgeRole, @NonNull Node sourceNode, @NonNull Property source2targetProperty, @NonNull Node targetNode) {
        CastEdge castEdge = QVTscheduleFactory.eINSTANCE.createCastEdge();
        castEdge.initialize(edgeRole, sourceNode, source2targetProperty.getName(), targetNode);
        castEdge.initializeProperty(source2targetProperty);
        return castEdge;
    }

    public static @NonNull Node createComposingNode(@NonNull Region region, @NonNull String name, @NonNull ClassDatumAnalysis classDatumAnalysis) {
        Role nodeRole = Role.LOADED;
        ComposedNode node = QVTscheduleFactory.eINSTANCE.createComposedNode();
        node.initialize(nodeRole, region, name, classDatumAnalysis.getClassDatum());
        return node;
    }

    public static @NonNull Node createDataTypeNode(@NonNull Node sourceNode, @NonNull Property property) {
        Role nodeRole = RegionUtil.getPatternNodeRole(sourceNode, property);
        return RegionUtil.createPatternNode(nodeRole, sourceNode, property, sourceNode.isMatched() && RegionUtil.isMatched((TypedElement)property));
    }

    public static @NonNull Node createDataTypeNode(@NonNull String name, @NonNull Node sourceNode, @NonNull NavigationCallExp navigationCallExp) {
        Property property = PivotUtil.getReferredProperty((NavigationCallExp)navigationCallExp);
        boolean isMatched = sourceNode.isMatched() && RegionUtil.isMatched((TypedElement)property);
        Role nodeRole = RegionUtil.getPatternNodeRole(sourceNode, property);
        assert (sourceNode.isClass() || property.getOpposite() != null);
        Region region = RegionUtil.getOwningRegion((Node)sourceNode);
        ScheduleManager scheduleManager = RegionUtil.getScheduleManager(region);
        PatternTypedNode node = QVTscheduleFactory.eINSTANCE.createPatternTypedNode();
        node.initialize(nodeRole, region, name, scheduleManager.getClassDatum((TypedElement)navigationCallExp));
        node.setMatched(isMatched);
        node.addTypedElement((TypedElement)navigationCallExp);
        return node;
    }

    public static @NonNull Node createDataTypeNode(@NonNull Node targetNode, @NonNull NavigationAssignment navigationAssignment) {
        Role nodeRole = RegionUtil.getNodeRole((Node)targetNode);
        Property property = QVTcoreUtil.getTargetProperty((NavigationAssignment)navigationAssignment);
        String name = property.getName();
        assert (name != null);
        Class type = (Class)property.getType();
        assert (type != null);
        TypedModel typedModel = RegionUtil.getTypedModel(RegionUtil.getClassDatumAnalysis(targetNode));
        Region region = RegionUtil.getOwningRegion((Node)targetNode);
        ScheduleManager scheduleManager = RegionUtil.getScheduleManager(region);
        ClassDatum classDatum = scheduleManager.getClassDatum(type, typedModel);
        PatternTypedNode node = QVTscheduleFactory.eINSTANCE.createPatternTypedNode();
        node.initialize(nodeRole, region, name, classDatum);
        node.setMatched(true);
        node.addTypedElement((TypedElement)property);
        return node;
    }

    public static @NonNull Node createDependencyClassNode(@NonNull Node parentNode, @NonNull NavigationAssignment navigationAssignment) {
        assert (parentNode.isClass());
        ScheduleManager scheduleManager = RegionUtil.getScheduleManager(RegionUtil.getOwningRegion((Node)parentNode));
        Property property = QVTcoreUtil.getTargetProperty((NavigationAssignment)navigationAssignment);
        assert (property != null);
        Class type = (Class)property.getType();
        assert (type != null);
        TypedModel typedModel = RegionUtil.getTypedModel(RegionUtil.getClassDatumAnalysis(parentNode));
        ClassDatum classDatum = scheduleManager.getClassDatum(type, typedModel);
        ClassDatumAnalysis classDatumAnalysis = scheduleManager.getClassDatumAnalysis(classDatum);
        String name = property.getName();
        assert (name != null);
        return RegionUtil.createDependencyNode(RegionUtil.getOwningRegion((Node)parentNode), name, classDatumAnalysis);
    }

    public static @NonNull Node createDependencyNode(@NonNull Region region, @NonNull String name, @NonNull ClassDatumAnalysis classDatumAnalysis) {
        Role nodeRole = Role.PREDICATED;
        DependencyNode node = QVTscheduleFactory.eINSTANCE.createDependencyNode();
        node.initialize(nodeRole, region, name, classDatumAnalysis.getClassDatum());
        return node;
    }

    public static @NonNull Node createErrorNode(@NonNull Region region, @NonNull String name, @NonNull ClassDatumAnalysis classDatumAnalysis) {
        Role nodeRole = Role.OTHER;
        ErrorNode node = QVTscheduleFactory.eINSTANCE.createErrorNode();
        node.initialize(nodeRole, region, name, classDatumAnalysis.getClassDatum());
        return node;
    }

    public static @NonNull Edge createEqualsEdge(@NonNull Node sourceNode, @NonNull Node targetNode) {
        System.err.println("Unexpected \u00abequals\u00bb edge from " + sourceNode + " to " + targetNode);
        return RegionUtil.createExpressionEdge(sourceNode, "\u00abequals\u00bb", targetNode);
    }

    public static @NonNull Edge createExpressionEdge(@NonNull Node sourceNode, @NonNull String name, @NonNull Node targetNode) {
        Role edgeRole = RegionUtil.getNodeRole((Node)sourceNode);
        ExpressionEdge edge = QVTscheduleFactory.eINSTANCE.createExpressionEdge();
        edge.initialize(edgeRole, sourceNode, name, targetNode);
        return edge;
    }

    public static @NonNull Node createInputNode(@NonNull Region region, @NonNull Role nodeRole, @NonNull String name, @NonNull ClassDatumAnalysis classDatumAnalysis) {
        InputNode node = QVTscheduleFactory.eINSTANCE.createInputNode();
        node.initialize(nodeRole, region, name, classDatumAnalysis.getClassDatum());
        return node;
    }

    public static @NonNull Edge createIteratedEdge(@NonNull Node sourceNode, @NonNull String name, @NonNull Node targetNode) {
        Role edgeRole = RegionUtil.getNodeRole((Node)sourceNode);
        IteratedEdge edge = QVTscheduleFactory.eINSTANCE.createIteratedEdge();
        edge.initialize(edgeRole, sourceNode, name, targetNode);
        return edge;
    }

    public static @NonNull VariableNode createIteratorNode(@NonNull Variable iterator, @NonNull Node sourceNode) {
        Region region = RegionUtil.getOwningRegion((Node)sourceNode);
        ScheduleManager scheduleManager = RegionUtil.getScheduleManager(region);
        Role nodeRole = RegionUtil.getNodeRole((Node)sourceNode);
        IteratorNode node = QVTscheduleFactory.eINSTANCE.createIteratorNode();
        node.initialize(nodeRole, region, RegionUtil.getName((Nameable)iterator), scheduleManager.getClassDatum((TypedElement)iterator));
        node.initializeVariable(region, (VariableDeclaration)iterator);
        return node;
    }

    public static @NonNull VariableNode createLetVariableNode(@NonNull Variable letVariable, @NonNull Node inNode) {
        Region region = RegionUtil.getOwningRegion((Node)inNode);
        ScheduleManager scheduleManager = RegionUtil.getScheduleManager(region);
        Role nodeRole = RegionUtil.getNodeRole((Node)inNode);
        PatternVariableNode node = QVTscheduleFactory.eINSTANCE.createPatternVariableNode();
        node.initialize(nodeRole, region, RegionUtil.getName((Nameable)letVariable), scheduleManager.getClassDatum((TypedElement)letVariable));
        node.initializeVariable(region, (VariableDeclaration)letVariable);
        node.setMatched(inNode.isMatched());
        return node;
    }

    public static @NonNull VariableNode createLoadedStepNode(@NonNull Region region, @NonNull VariableDeclaration stepVariable) {
        ScheduleManager scheduleManager = RegionUtil.getScheduleManager(region);
        Role nodeRole = Role.LOADED;
        PatternVariableNode node = QVTscheduleFactory.eINSTANCE.createPatternVariableNode();
        node.initialize(nodeRole, region, RegionUtil.getName((Nameable)stepVariable), scheduleManager.getClassDatum((TypedElement)stepVariable));
        node.initializeVariable(region, stepVariable);
        node.setMatched(true);
        return node;
    }

    public static @NonNull NavigableEdge createNavigationEdge(@NonNull Node sourceNode, @NonNull Property source2targetProperty, @NonNull Node targetNode, @Nullable Boolean isPartial) {
        Role phase = RegionUtil.mergeToLessKnownPhase((Role)RegionUtil.getNodeRole((Node)sourceNode), (Role)RegionUtil.getNodeRole((Node)targetNode));
        assert (phase != null);
        Role edgeRole = phase;
        NavigationEdge edge = QVTscheduleFactory.eINSTANCE.createNavigationEdge();
        edge.initialize(edgeRole, sourceNode, source2targetProperty.getName(), targetNode);
        edge.initializeProperty(source2targetProperty, isPartial);
        return edge;
    }

    public static @NonNull Node createNullNode(@NonNull Region region, boolean isMatched, @Nullable TypedElement typedElement) {
        ScheduleManager scheduleManager = RegionUtil.getScheduleManager(region);
        Role nodeRole = Role.CONSTANT;
        ClassDatum classDatum = typedElement != null ? scheduleManager.getClassDatum(typedElement) : scheduleManager.getOclVoidClassDatumAnalysis().getClassDatum();
        NullNode node = QVTscheduleFactory.eINSTANCE.createNullNode();
        node.initialize(nodeRole, region, "\u00abnull\u00bb", classDatum);
        node.setMatched(isMatched);
        if (typedElement != null) {
            node.addTypedElement(typedElement);
        }
        return node;
    }

    public static @NonNull VariableNode createOldNode(@NonNull Region region, @NonNull VariableDeclaration variable) {
        Role phase;
        ScheduleManager scheduleManager = RegionUtil.getScheduleManager(region);
        DomainUsage domainUsage = scheduleManager.getDomainUsage((Element)variable);
        boolean isEnforceable = domainUsage.isOutput() || domainUsage.isMiddle();
        Role nodeRole = phase = isEnforceable ? Role.PREDICATED : Role.LOADED;
        PatternVariableNode node = QVTscheduleFactory.eINSTANCE.createPatternVariableNode();
        node.initialize(nodeRole, region, RegionUtil.getName((Nameable)variable), scheduleManager.getClassDatum((TypedElement)variable));
        node.initializeVariable(region, variable);
        node.setMatched(true);
        return node;
    }

    public static @NonNull Node createOperationElementNode(@NonNull Region region, @NonNull String name, @NonNull ClassDatumAnalysis classDatumAnalysis, @NonNull Node sourceNode) {
        Role nodeRole = RegionUtil.getNodeRole((Node)sourceNode);
        PatternTypedNode node = QVTscheduleFactory.eINSTANCE.createPatternTypedNode();
        node.initialize(nodeRole, region, name, classDatumAnalysis.getClassDatum());
        node.setMatched(true);
        return node;
    }

    public static @NonNull Node createOperationNode(@NonNull Region region, boolean isMatched, @NonNull String name, @NonNull TypedElement typedElement, Node ... argNodes) {
        ScheduleManager scheduleManager = RegionUtil.getScheduleManager(region);
        Role nodeRole = RegionUtil.getOperationNodePhase(region, typedElement, argNodes);
        OperationNode node = QVTscheduleFactory.eINSTANCE.createOperationNode();
        node.initialize(nodeRole, region, name, scheduleManager.getClassDatum(typedElement));
        node.setMatched(isMatched);
        node.addTypedElement(typedElement);
        return node;
    }

    public static @NonNull Node createOperationParameterNode(@NonNull Region region, @NonNull String name, @NonNull ClassDatumAnalysis classDatumAnalysis) {
        Role nodeRole = Role.PREDICATED;
        PatternTypedNode node = QVTscheduleFactory.eINSTANCE.createPatternTypedNode();
        node.initialize(nodeRole, region, name, classDatumAnalysis.getClassDatum());
        node.setMatched(true);
        node.setHead();
        return node;
    }

    public static @NonNull Node createOperationResultNode(@NonNull Region region, @NonNull String name, @NonNull ClassDatumAnalysis classDatumAnalysis, @NonNull Node sourceNode) {
        Role nodeRole = RegionUtil.getNodeRole((Node)sourceNode);
        PatternTypedNode node = QVTscheduleFactory.eINSTANCE.createPatternTypedNode();
        node.initialize(nodeRole, region, name, classDatumAnalysis.getClassDatum());
        node.setMatched(false);
        return node;
    }

    public static @NonNull Node createPatternNode(@NonNull Role nodeRole, @NonNull Node sourceNode, @NonNull Property source2targetProperty, boolean isMatched) {
        TypedModel typedModel;
        Region region = RegionUtil.getOwningRegion((Node)sourceNode);
        assert (sourceNode.isClass());
        ScheduleManager scheduleManager = RegionUtil.getScheduleManager(region);
        Class type = (Class)source2targetProperty.getType();
        assert (type != null);
        Type elementType = PivotUtil.getElementalType((Type)type);
        TypedModel typedModel2 = typedModel = elementType instanceof DataType ? scheduleManager.getDomainAnalysis().getPrimitiveTypeModel() : sourceNode.getClassDatum().getReferredTypedModel();
        assert (typedModel != null);
        ClassDatum classDatum = scheduleManager.getClassDatum(type, typedModel);
        String name = source2targetProperty.getName();
        assert (name != null);
        PatternTypedNode node = QVTscheduleFactory.eINSTANCE.createPatternTypedNode();
        node.initialize(nodeRole, region, name, classDatum);
        node.setMatched(isMatched);
        return node;
    }

    public static @NonNull Edge createPredicateEdge(@NonNull Node sourceNode, @Nullable String name, @NonNull Node targetNode) {
        Role edgeRole = RegionUtil.getNodeRole((Node)sourceNode);
        PredicateEdge edge = QVTscheduleFactory.eINSTANCE.createPredicateEdge();
        edge.initialize(edgeRole, sourceNode, name, targetNode);
        return edge;
    }

    public static @NonNull Node createPredicatedStepNode(@NonNull Region region, @NonNull Node typedNode, boolean isMatched) {
        PatternTypedNode node = QVTscheduleFactory.eINSTANCE.createPatternTypedNode();
        node.initialize(Role.PREDICATED, region, RegionUtil.getName((Nameable)typedNode), RegionUtil.getClassDatum((Node)typedNode));
        node.setMatched(isMatched);
        return node;
    }

    public static @NonNull Node createRealizedDataTypeNode(@NonNull Node sourceNode, @NonNull Property source2targetProperty) {
        Role nodeRole = Role.REALIZED;
        return RegionUtil.createPatternNode(nodeRole, sourceNode, source2targetProperty, sourceNode.isMatched());
    }

    public static @NonNull Edge createRealizedExpressionEdge(@NonNull Node sourceNode, @Nullable String name, @NonNull Node targetNode) {
        Role edgeRole = Role.REALIZED;
        ExpressionEdge edge = QVTscheduleFactory.eINSTANCE.createExpressionEdge();
        edge.initialize(edgeRole, sourceNode, name, targetNode);
        return edge;
    }

    public static @NonNull NavigableEdge createRealizedNavigationEdge(@NonNull Node sourceNode, @NonNull Property source2targetProperty, @NonNull Node targetNode, @Nullable Boolean isPartial) {
        Role edgeRole = Role.REALIZED;
        NavigationEdge forwardEdge = QVTscheduleFactory.eINSTANCE.createNavigationEdge();
        forwardEdge.initialize(edgeRole, sourceNode, source2targetProperty.getName(), targetNode);
        forwardEdge.initializeProperty(source2targetProperty, isPartial);
        return forwardEdge;
    }

    public static @NonNull VariableNode createRealizedStepNode(@NonNull Region region, @NonNull Variable stepVariable) {
        ScheduleManager scheduleManager = RegionUtil.getScheduleManager(region);
        Role nodeRole = Role.REALIZED;
        PatternVariableNode node = QVTscheduleFactory.eINSTANCE.createPatternVariableNode();
        node.initialize(nodeRole, region, RegionUtil.getName((Nameable)stepVariable), scheduleManager.getClassDatum((TypedElement)stepVariable));
        node.initializeVariable(region, (VariableDeclaration)stepVariable);
        node.setMatched(true);
        return node;
    }

    public static @NonNull Edge createRecursionEdge(@NonNull Node sourceNode, @NonNull Node targetNode, boolean isPrimary) {
        Role edgeRole = Role.OTHER;
        RecursionEdge edge = QVTscheduleFactory.eINSTANCE.createRecursionEdge();
        edge.initialize(edgeRole, sourceNode, null, targetNode);
        edge.setPrimary(isPrimary);
        return edge;
    }

    public static @NonNull RegionProblem createRegionError(@NonNull Region region, @NonNull String messageTemplate, Object ... bindings) {
        String boundMessage = StringUtil.bind((String)messageTemplate, (Object[])bindings);
        return new RegionProblem(CompilerProblem.Severity.ERROR, region, boundMessage);
    }

    public static @NonNull RegionProblem createRegionWarning(@NonNull Region region, @NonNull String messageTemplate, Object ... bindings) {
        String boundMessage = StringUtil.bind((String)messageTemplate, (Object[])bindings);
        return new RegionProblem(CompilerProblem.Severity.WARNING, region, boundMessage);
    }

    public static @NonNull Node createStepNode(@NonNull String name, @NonNull CallExp callExp, @NonNull Node sourceNode, boolean isMatched) {
        Role phase;
        Region region = RegionUtil.getOwningRegion((Node)sourceNode);
        ScheduleManager scheduleManager = RegionUtil.getScheduleManager(region);
        DomainUsage domainUsage = scheduleManager.getDomainUsage((Element)callExp);
        boolean isMiddleOrOutput = domainUsage.isOutput() || domainUsage.isMiddle();
        boolean isDirty = false;
        if (callExp instanceof NavigationCallExp) {
            Property referredProperty = PivotUtil.getReferredProperty((NavigationCallExp)((NavigationCallExp)callExp));
            isDirty = scheduleManager.isDirty(referredProperty);
        }
        Role stepNodeRole = phase = sourceNode.isPredicated() || isMiddleOrOutput || isDirty ? Role.PREDICATED : Role.LOADED;
        PatternTypedNode node = QVTscheduleFactory.eINSTANCE.createPatternTypedNode();
        node.initialize(stepNodeRole, region, name, scheduleManager.getClassDatum((TypedElement)callExp));
        node.setMatched(isMatched);
        node.addTypedElement((TypedElement)callExp);
        return node;
    }

    public static @NonNull Node createTrueNode(@NonNull Region region) {
        ScheduleManager scheduleManager = RegionUtil.getScheduleManager(region);
        Class booleanType = scheduleManager.getStandardLibrary().getBooleanType();
        RootDomainUsageAnalysis.DomainUsageConstant primitiveUsage = scheduleManager.getDomainAnalysis().getPrimitiveUsage();
        ClassDatumAnalysis classDatumAnalysis = scheduleManager.getClassDatumAnalysis(booleanType, (TypedModel)ClassUtil.nonNullState((Object)primitiveUsage.getTypedModel(null)));
        Role nodeRole = Role.CONSTANT;
        TrueNode node = QVTscheduleFactory.eINSTANCE.createTrueNode();
        node.initialize(nodeRole, region, "\u00abtrue\u00bb", classDatumAnalysis.getClassDatum());
        node.setHead();
        return node;
    }

    public static @NonNull Node createUnknownNode(@NonNull Region region, @NonNull String name, @NonNull TypedElement typedElement) {
        ScheduleManager scheduleManager = RegionUtil.getScheduleManager(region);
        Role nodeRole = Role.OTHER;
        UnknownNode node = QVTscheduleFactory.eINSTANCE.createUnknownNode();
        node.initialize(nodeRole, region, name, scheduleManager.getClassDatum(typedElement));
        return node;
    }

    public static @NonNull ClassDatumAnalysis getClassDatumAnalysis(@NonNull Node node) {
        return ClassDatumAnalysis.get(node);
    }

    public static @NonNull CompleteClass getCompleteClass(@NonNull ClassDatumAnalysis classDatumAnalysis) {
        return (CompleteClass)ClassUtil.nonNullState((Object)classDatumAnalysis.getClassDatum().getCompleteClass());
    }

    public static @NonNull Map<@NonNull CompleteClass, @NonNull List<@NonNull Node>> getCompleteClass2Nodes(@NonNull Region region) {
        HashMap<@NonNull CompleteClass, @NonNull List<@NonNull Node>> completeClass2nodes = new HashMap<CompleteClass, List<Node>>();
        for (Node node : RegionUtil.getOwnedNodes((Region)region)) {
            CompleteClass completeClass = node.getCompleteClass();
            ArrayList<@NonNull Node> mergedNodes = (ArrayList<Node>)completeClass2nodes.get(completeClass);
            if (mergedNodes == null) {
                mergedNodes = new ArrayList<Node>();
                completeClass2nodes.put(completeClass, mergedNodes);
            }
            if (mergedNodes.contains(node)) continue;
            mergedNodes.add(node);
        }
        return completeClass2nodes;
    }

    public static @NonNull Iterable<@NonNull MappingRegion> getConsumingRegions(@NonNull ClassDatumAnalysis classDatumAnalysis) {
        return ClassUtil.nullFree(classDatumAnalysis.getConsumingRegions());
    }

    public static @NonNull ClassDatum getElementalClassDatum(@NonNull ClassDatumAnalysis classDatumAnalysis) {
        return (ClassDatum)ClassUtil.nonNullState((Object)classDatumAnalysis.getElementalClassDatum());
    }

    public static @NonNull Role getOperationNodePhase(@NonNull Region region, @NonNull TypedElement typedElement, Node ... argNodes) {
        Operation asOperation;
        boolean isLoaded = false;
        boolean isPredicated = false;
        boolean isRealized = false;
        if (argNodes != null) {
            Node[] nodeArray = argNodes;
            int n = argNodes.length;
            int n2 = 0;
            while (n2 < n) {
                Node argNode = nodeArray[n2];
                if (argNode.isRealized()) {
                    isRealized = true;
                } else if (argNode.isPredicated()) {
                    isPredicated = true;
                } else if (argNode.isLoaded()) {
                    isLoaded = true;
                }
                ++n2;
            }
        }
        if (typedElement instanceof OperationCallExp && QVTbaseUtil.isIdentification((Operation)(asOperation = ((OperationCallExp)typedElement).getReferredOperation()))) {
            isRealized = true;
        }
        if (isRealized) {
            return Role.REALIZED;
        }
        if (isPredicated) {
            return Role.PREDICATED;
        }
        if (isLoaded) {
            return Role.LOADED;
        }
        return Role.CONSTANT;
    }

    private static @NonNull Role getPatternNodeRole(@NonNull Node sourceNode, @NonNull Property property) {
        Role phase;
        switch (RegionUtil.getNodeRole((Node)sourceNode)) {
            case REALIZED: {
                phase = Role.REALIZED;
                break;
            }
            case PREDICATED: {
                phase = Role.PREDICATED;
                break;
            }
            case LOADED: {
                boolean isDirty = RegionUtil.getScheduleManager(RegionUtil.getOwningRegion((Node)sourceNode)).isDirty(property);
                phase = isDirty ? Role.PREDICATED : Role.LOADED;
                break;
            }
            case CONSTANT: {
                phase = Role.CONSTANT;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return phase;
    }

    public static @NonNull ScheduleManager getScheduleManager(@NonNull Region region) {
        return ScheduleManager.get(RegionUtil.getScheduleModel((Region)region));
    }

    public static @NonNull TypedModel getTypedModel(@NonNull ClassDatumAnalysis classDatumAnalysis) {
        return (TypedModel)ClassUtil.nonNullState((Object)classDatumAnalysis.getClassDatum().getReferredTypedModel());
    }

    public static boolean isElementallyConformantSource(@NonNull NavigableEdge thatEdge, @NonNull NavigableEdge thisEdge) {
        CompleteClass thisType;
        Node thatSource = thatEdge.getEdgeSource();
        CompleteClass thatType = (CompleteClass)ClassUtil.nonNullState((Object)RegionUtil.getClassDatumAnalysis(thatSource).getElementalClassDatum().getCompleteClass());
        if (thatType.conformsTo(thisType = (CompleteClass)ClassUtil.nonNullState((Object)RegionUtil.getClassDatumAnalysis(thisEdge.getEdgeSource()).getElementalClassDatum().getCompleteClass()))) {
            return true;
        }
        if (thatSource.isRealized()) {
            return false;
        }
        return thisType.conformsTo(thatType);
    }

    public static boolean isMatched(@NonNull TypedElement typedElement) {
        boolean isMatched = false;
        Type type = typedElement.getType();
        if (type instanceof CollectionType) {
            isMatched = true;
            assert (typedElement.isIsRequired());
        } else {
            isMatched = typedElement.isIsRequired();
        }
        if (!isMatched) {
            return false;
        }
        return RegionUtil.isUnconditional(typedElement);
    }

    public static boolean isUnconditional(@NonNull TypedElement typedElement) {
        LoopExp loopExp;
        IfExp ifExp;
        EObject eContainer = typedElement.eContainer();
        if (eContainer instanceof IfExp ? typedElement == (ifExp = (IfExp)eContainer).getOwnedThen() || typedElement == ifExp.getOwnedElse() : eContainer instanceof LoopExp && typedElement == (loopExp = (LoopExp)eContainer).getOwnedBody()) {
            return false;
        }
        if (eContainer instanceof TypedElement) {
            return RegionUtil.isUnconditional((TypedElement)eContainer);
        }
        return true;
    }

    public static boolean isUnconditional(@NonNull Edge edge) {
        for (TypedElement typedElement : edge.getEdgeSource().getTypedElements()) {
            if (RegionUtil.isUnconditional(typedElement)) continue;
            return false;
        }
        return true;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Node.Utility mergeToStrongerUtility(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Node.Utility nodeUtility1, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Node.Utility nodeUtility2) {
        if (nodeUtility1 == Node.Utility.STRONGLY_MATCHED || nodeUtility2 == Node.Utility.STRONGLY_MATCHED) {
            return Node.Utility.STRONGLY_MATCHED;
        }
        if (nodeUtility1 == Node.Utility.WEAKLY_MATCHED || nodeUtility2 == Node.Utility.WEAKLY_MATCHED) {
            return Node.Utility.WEAKLY_MATCHED;
        }
        if (nodeUtility1 == Node.Utility.CONDITIONAL || nodeUtility2 == Node.Utility.CONDITIONAL) {
            return Node.Utility.CONDITIONAL;
        }
        if (nodeUtility1 == Node.Utility.DEPENDENCY || nodeUtility2 == Node.Utility.DEPENDENCY) {
            return Node.Utility.DEPENDENCY;
        }
        return Node.Utility.DEAD;
    }

    public static @Nullable String recoverVariableName(@NonNull NamedElement namedElement) {
        OCLExpression source;
        OperationCallExp operationCallExp;
        EObject eContainer = namedElement.eContainer();
        EReference eContainmentFeature = namedElement.eContainmentFeature();
        if (eContainmentFeature == PivotPackage.Literals.VARIABLE__OWNED_INIT && eContainer instanceof Variable) {
            return ((Variable)eContainer).getName();
        }
        if (eContainmentFeature == QVTcorePackage.Literals.ASSIGNMENT__VALUE && eContainer instanceof VariableAssignment) {
            return ((VariableAssignment)eContainer).getTargetVariable().getName();
        }
        if (eContainmentFeature == PivotPackage.Literals.CALL_EXP__OWNED_SOURCE && eContainer instanceof OperationCallExp) {
            OCLExpression argument;
            OperationCallExp operationCallExp2 = (OperationCallExp)eContainer;
            if (PivotUtil.isSameOperation((OperationId)operationCallExp2.getReferredOperation().getOperationId(), (OperationId)OperationId.OCLANY_EQUALS) && (argument = PivotUtil.getOwnedArgument((OperationCallExp)operationCallExp2, (int)0)) instanceof VariableExp) {
                return PivotUtil.getReferredVariable((VariableExp)((VariableExp)argument)).getName();
            }
        } else if (eContainmentFeature == PivotPackage.Literals.OPERATION_CALL_EXP__OWNED_ARGUMENTS && eContainer instanceof OperationCallExp && PivotUtil.isSameOperation((OperationId)(operationCallExp = (OperationCallExp)eContainer).getReferredOperation().getOperationId(), (OperationId)OperationId.OCLANY_EQUALS) && (source = PivotUtil.getOwnedSource((CallExp)operationCallExp)) instanceof VariableExp) {
            return PivotUtil.getReferredVariable((VariableExp)((VariableExp)source)).getName();
        }
        return null;
    }

    public static class Internal {
        public static @NonNull List<@NonNull Node> getHeadNodesList(@NonNull Region region) {
            return ClassUtil.nullFree((List)region.getHeadNodes());
        }
    }
}

