/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtbase.utilities;

import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.PivotHelper;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.FunctionParameter;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.QVTbaseFactory;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;

public class QVTbaseHelper
extends PivotHelper {
    public QVTbaseHelper(@NonNull EnvironmentFactory environmentFactory) {
        super(environmentFactory);
    }

    public @NonNull Function createFunction(@NonNull String name, @NonNull Type returnType, boolean returnIsRequired, @Nullable List<@NonNull FunctionParameter> asParameters) {
        Function asFunction = QVTbaseFactory.eINSTANCE.createFunction();
        asFunction.setName(name);
        this.setType((TypedElement)asFunction, returnType, returnIsRequired);
        if (asParameters != null) {
            asFunction.getOwnedParameters().addAll(asParameters);
        }
        return asFunction;
    }

    public @NonNull FunctionParameter createFunctionParameter(@NonNull String name, @NonNull Class asClass, boolean isRequired) {
        FunctionParameter asParameter = QVTbaseFactory.eINSTANCE.createFunctionParameter();
        asParameter.setName(name);
        this.setType((TypedElement)asParameter, (Type)asClass, isRequired);
        return asParameter;
    }

    public @NonNull FunctionParameter createFunctionParameter(@NonNull TypedElement typedElement) {
        String name = (String)ClassUtil.nonNullState((Object)typedElement.getName());
        Type type = (Type)ClassUtil.nonNullState((Object)typedElement.getType());
        FunctionParameter asParameter = QVTbaseFactory.eINSTANCE.createFunctionParameter();
        asParameter.setName(name);
        this.setType((TypedElement)asParameter, type, typedElement.isIsRequired());
        return asParameter;
    }

    public @NonNull Predicate createPredicate(@NonNull OCLExpression asConditionExpression) {
        Predicate asPredicate = QVTbaseFactory.eINSTANCE.createPredicate();
        asPredicate.setConditionExpression(asConditionExpression);
        return asPredicate;
    }

    public @NonNull TypedModel createTypedModel(@NonNull String name, @NonNull Iterable<@NonNull Package> usedPackages) {
        TypedModel asTypedModel = QVTbaseFactory.eINSTANCE.createTypedModel();
        asTypedModel.setName(name);
        Iterables.addAll(QVTbaseUtil.Internal.getUsedPackagesList(asTypedModel), usedPackages);
        return asTypedModel;
    }
}

