/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public final class ReflectionHelper {
    private ReflectionHelper() {
    }

    public static Constructor setConstructorVisible(Class<? extends Object> classToModify, Class<?> ... parameterTypes) throws SecurityException, NoSuchMethodException {
        Constructor<? extends Object> osConstructor = classToModify.getDeclaredConstructor(parameterTypes);
        osConstructor.setAccessible(true);
        return osConstructor;
    }

    public static Field setFieldVisible(Class<? extends Object> classToModify, String fieldName) throws SecurityException, NoSuchFieldException {
        Field field;
        block3: {
            field = null;
            try {
                field = classToModify.getDeclaredField(fieldName);
                field.setAccessible(true);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (classToModify.getSuperclass() == null) break block3;
                field = ReflectionHelper.setFieldVisible(classToModify.getSuperclass(), fieldName);
            }
        }
        return field;
    }

    public static Object invokeMethod(Object object, String methodName, Class<?>[] parameterTypes, Object[] parameters) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = object.getClass().getMethod(methodName, parameterTypes);
        return method.invoke(object, parameters);
    }

    public static Option<Constructor> setConstructorVisibleWithoutException(Class<? extends Object> classToModify, Class<?> ... parameterTypes) {
        try {
            return Options.newSome((Object)ReflectionHelper.setConstructorVisible(classToModify, parameterTypes));
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return Options.newNone();
    }

    public static Option<Field> setFieldVisibleWithoutException(Class<? extends Object> classToModify, String fieldName) {
        try {
            return Options.newSome((Object)ReflectionHelper.setFieldVisible(classToModify, fieldName));
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {}
        return Options.newNone();
    }

    public static boolean invokeMethodWithoutException(Object object, String methodName, Class<?>[] parameterTypes, Object[] parameters) {
        try {
            ReflectionHelper.invokeMethod(object, methodName, parameterTypes, parameters);
            return true;
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return false;
    }

    public static Object invokeMethodWithoutExceptionWithReturn(Object object, String methodName, Class<?>[] parameterTypes, Object[] parameters) {
        try {
            return ReflectionHelper.invokeMethod(object, methodName, parameterTypes, parameters);
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return null;
    }

    public static Object invokeMethodWithoutExceptionWithReturn(Object object, Class aClass, String methodName, Class<?>[] parameterTypes, Object[] parameters, boolean setVisible) {
        try {
            return ReflectionHelper.invokeMethod(object, aClass, methodName, parameterTypes, parameters, setVisible);
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return null;
    }

    public static Option<Class> getClassForNameWithoutException(String className) {
        try {
            Class<?> foundClass = Class.forName(className);
            return Options.newSome(foundClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Options.newNone();
        }
    }

    public static Option<Object> instantiateWithoutException(String className, Class<?>[] parameterTypes, Object[] parameters) {
        Option<Constructor> osConstructor;
        Option<Class> foundClass = ReflectionHelper.getClassForNameWithoutException(className);
        if (foundClass.some() && (osConstructor = ReflectionHelper.setConstructorVisibleWithoutException((Class)foundClass.get(), parameterTypes)).some()) {
            try {
                Object object = ((Constructor)osConstructor.get()).newInstance(parameters);
                return Options.newSome(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        return Options.newNone();
    }

    public static boolean setFieldValueWithoutException(Object instanceToModify, String fieldName, int newValue) {
        Option<Field> field = ReflectionHelper.setFieldVisibleWithoutException(instanceToModify.getClass(), fieldName);
        if (field.some()) {
            try {
                ((Field)field.get()).setInt(instanceToModify, newValue);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return false;
    }

    public static boolean setFieldValueWithoutException(Object instanceToModify, String fieldName, Object newValue, Class<? extends Object> classToModify) {
        Option<Field> field = ReflectionHelper.setFieldVisibleWithoutException(classToModify, fieldName);
        if (field.some()) {
            try {
                ((Field)field.get()).set(instanceToModify, newValue);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return false;
    }

    public static boolean setFieldValueWithoutException(Object instanceToModify, String fieldName, Object newValue) {
        Option<Field> field = ReflectionHelper.setFieldVisibleWithoutException(instanceToModify.getClass(), fieldName);
        if (field.some()) {
            try {
                ((Field)field.get()).set(instanceToModify, newValue);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return false;
    }

    public static Option<Object> getFieldValueWithoutException(Object instance, String fieldName) {
        Option<Field> field = ReflectionHelper.setFieldVisibleWithoutException(instance.getClass(), fieldName);
        if (field.some()) {
            try {
                return Options.newSome((Object)((Field)field.get()).get(instance));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return Options.newNone();
    }

    public static Option<Object> getFieldValueWithoutException(Class<? extends Object> klass, String fieldName) {
        Option<Field> field = ReflectionHelper.setFieldVisibleWithoutException(klass, fieldName);
        if (field.some()) {
            try {
                return Options.newSome((Object)((Field)field.get()).get(null));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return Options.newNone();
    }

    public static Option<Object> getFieldValueWithoutException(Object instance, String fieldName, Class<? extends Object> classToModify) {
        Option<Field> field = ReflectionHelper.setFieldVisibleWithoutException(classToModify, fieldName);
        if (field.some()) {
            try {
                return Options.newSome((Object)((Field)field.get()).get(instance));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return Options.newNone();
    }

    public static boolean invokeMethodWithoutException(Object object, Class aClass, String methodName, Class<?>[] parameterTypes, Object[] parameters, boolean setVisible) {
        try {
            ReflectionHelper.invokeMethod(object, aClass, methodName, parameterTypes, parameters, setVisible);
            return true;
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return false;
    }

    public static Object invokeMethod(Object object, Class aClass, String methodName, Class<?>[] parameterTypes, Object[] parameters, boolean setVisible) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = aClass.getDeclaredMethod(methodName, parameterTypes);
        if (setVisible) {
            method.setAccessible(true);
        }
        return method.invoke(object, parameters);
    }
}

