/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.io.File;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.utils.Host;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IResultOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IRuntimeModel;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.AbstractOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.testers.TargetPropertyTester;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.CacheManager;
import org.eclipse.tcf.te.tcf.filesystem.core.model.ModelManager;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IPeerModelLookupService;

public class OpParsePath
extends AbstractOperation
implements IResultOperation<IFSTreeNode> {
    IPeerNode peer;
    String path;
    FSTreeNode result;

    public OpParsePath(IPeerNode peer, String path) {
        this.peer = peer;
        this.path = path;
    }

    public OpParsePath(String filePath) {
        int slash;
        String cache_root = CacheManager.getCacheRoot().getAbsolutePath();
        if (filePath.startsWith(cache_root) && (slash = (filePath = filePath.substring(cache_root.length() + 1)).indexOf(File.separator)) != -1) {
            String peerId = filePath.substring(0, slash);
            peerId = peerId.replace('$', ':');
            final AtomicReference peerNode = new AtomicReference();
            final String finPeerId = peerId;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    peerNode.set(((IPeerModelLookupService)org.eclipse.tcf.te.tcf.locator.model.ModelManager.getPeerModel().getService(IPeerModelLookupService.class)).lkupPeerModelById(finPeerId));
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            this.peer = (IPeerNode)peerNode.get();
            if (this.peer != null) {
                boolean hostWindows = Host.isWindowsHost();
                boolean windows = TargetPropertyTester.isWindows(this.peer);
                filePath = filePath.substring(slash + 1);
                if (hostWindows) {
                    if (windows) {
                        slash = filePath.indexOf(File.separator);
                        if (slash != -1) {
                            String disk = filePath.substring(0, slash);
                            filePath = filePath.substring(slash + 1);
                            disk = disk.replace('$', ':');
                            filePath = String.valueOf(disk) + File.separator + filePath;
                        }
                    } else {
                        filePath = "/" + filePath.replace('\\', '/');
                    }
                } else if (windows) {
                    slash = filePath.indexOf(File.separator);
                    if (slash != -1) {
                        String disk = filePath.substring(0, slash);
                        filePath = filePath.substring(slash + 1);
                        disk = disk.replace('$', ':');
                        filePath = String.valueOf(disk) + File.separator + filePath;
                    }
                    filePath = filePath.replace(File.separatorChar, '\\');
                } else {
                    filePath = "/" + filePath;
                }
                this.path = filePath;
            }
        }
    }

    @Override
    public FSTreeNode getResult() {
        return this.result;
    }

    @Override
    public IStatus doRun(IProgressMonitor monitor) {
        monitor.beginTask(this.getName(), -1);
        if (this.peer == null || this.path == null) {
            return Status.OK_STATUS;
        }
        IRuntimeModel rtm = ModelManager.getRuntimeModel(this.peer);
        if (rtm == null) {
            return null;
        }
        FSTreeNode node = (FSTreeNode)rtm.getRoot();
        return this.findPath(node, this.path, monitor);
    }

    private IStatus findPath(FSTreeNode node, String path, IProgressMonitor monitor) {
        String segment;
        IStatus status;
        if (path == null || path.length() == 0) {
            this.result = node;
            return Status.OK_STATUS;
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        path = path.replace(':', '$');
        if (node.getChildren() == null && !(status = node.operationRefresh(false).run((IProgressMonitor)new SubProgressMonitor(monitor, 0))).isOK()) {
            return status;
        }
        if (node.isFileSystem()) {
            FSTreeNode[] fSTreeNodeArray = node.getChildren();
            int n = fSTreeNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                FSTreeNode child = fSTreeNodeArray[n2];
                if (path.startsWith(child.getName().replace(':', '$'))) {
                    return this.findPath(child, path.substring(child.getName().length()), monitor);
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }
        String osPathSep = node.isWindowsNode() ? "\\" : "/";
        int delim = path.indexOf(osPathSep);
        if (delim == -1) {
            segment = path;
            path = null;
        } else {
            segment = path.substring(0, delim);
            path = path.substring(delim + 1);
        }
        node = node.findChild(segment);
        if (node == null) {
            return Status.OK_STATUS;
        }
        return this.findPath(node, path, monitor);
    }

    @Override
    public String getName() {
        return MessageFormat.format(Messages.OpParsePath_name, this.path);
    }
}

