/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.resources;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.client.UpdatedHandler;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.IUpdateMessageListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.UpdateListener;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.connection.CVSServerException;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderSandbox;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTreeBuilder;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;

public class UpdateContentCachingService
implements IUpdateMessageListener {
    private CVSRepositoryLocation repository;
    private ICVSFolder remoteRoot;
    private final CVSTag tag;
    private final int depth;
    private boolean fetchAbsentDirectories = true;
    private ArrayList removed = new ArrayList();

    public static RemoteFolder buildRemoteTree(CVSRepositoryLocation repository, ICVSFolder root, CVSTag tag, int depth, IProgressMonitor monitor) throws CVSException {
        monitor.beginTask(null, 100);
        try {
            RemoteFolder tree = UpdateContentCachingService.buildBaseTree(repository, root, tag, Policy.subMonitorFor(monitor, 50));
            UpdateContentCachingService service = new UpdateContentCachingService(repository, tree, tag, depth);
            service.setFetchAbsentDirectories(UpdateContentCachingService.getFetchAbsentDirectories(root));
            if (!service.cacheFileContents(Policy.subMonitorFor(monitor, 50))) {
                return null;
            }
            RemoteFolder remoteFolder = tree;
            return remoteFolder;
        }
        finally {
            monitor.done();
        }
    }

    private void setFetchAbsentDirectories(boolean fetchAbsentDirectories) {
        this.fetchAbsentDirectories = fetchAbsentDirectories;
    }

    private static boolean getFetchAbsentDirectories(ICVSFolder root) {
        IProject project;
        RepositoryProvider provider;
        IResource resource = root.getIResource();
        if (resource != null && (provider = RepositoryProvider.getProvider((IProject)(project = resource.getProject()), (String)CVSProviderPlugin.getTypeId())) instanceof CVSTeamProvider) {
            CVSTeamProvider cp = (CVSTeamProvider)provider;
            try {
                return cp.getFetchAbsentDirectories();
            }
            catch (CVSException e) {
                CVSProviderPlugin.log((CoreException)((Object)e));
            }
        }
        return CVSProviderPlugin.getPlugin().getFetchAbsentDirectories();
    }

    private static RemoteFolder buildBaseTree(final CVSRepositoryLocation repository, ICVSFolder root, CVSTag tag, IProgressMonitor progress) throws CVSException {
        try {
            RemoteFolderTreeBuilder builder = new RemoteFolderTreeBuilder(repository, root, tag){

                @Override
                protected RemoteFolder createRemoteFolder(ICVSFolder local, RemoteFolder parent, FolderSyncInfo folderSyncInfo) {
                    return new RemoteFolderSandbox(parent, local.getName(), repository, folderSyncInfo.getRepository(), folderSyncInfo.getTag(), folderSyncInfo.getIsStatic());
                }

                @Override
                protected RemoteFile createRemoteFile(RemoteFolder remote, byte[] syncBytes) throws CVSException {
                    return new RemoteFile(remote, syncBytes){

                        @Override
                        public boolean isModified(IProgressMonitor monitor) throws CVSException {
                            return false;
                        }

                        @Override
                        public void delete() {
                            RemoteFolderSandbox parent = (RemoteFolderSandbox)this.getParent();
                            parent.remove(this);
                        }
                    };
                }

                @Override
                protected boolean isPruneEmptyDirectories() {
                    return true;
                }
            };
            progress.beginTask(null, 100);
            IProgressMonitor subProgress = Policy.infiniteSubMonitorFor(progress, 100);
            subProgress.beginTask(null, 512);
            subProgress.subTask(NLS.bind((String)CVSMessages.RemoteFolderTreeBuilder_buildingBase, (Object[])new String[]{root.getName()}));
            RemoteFolder tree = builder.buildBaseTree(null, root, subProgress);
            if (tree == null) {
                FolderSyncInfo folderSyncInfo = root.getFolderSyncInfo();
                if (folderSyncInfo == null) {
                    return null;
                }
                RemoteFolderSandbox remoteFolderSandbox = new RemoteFolderSandbox(null, root.getName(), repository, folderSyncInfo.getRepository(), folderSyncInfo.getTag(), folderSyncInfo.getIsStatic());
                return remoteFolderSandbox;
            }
            RemoteFolder remoteFolder = tree;
            return remoteFolder;
        }
        finally {
            progress.done();
        }
    }

    public static RemoteFile buildRemoteTree(CVSRepositoryLocation repository, ICVSFile file, CVSTag tag, IProgressMonitor monitor) throws CVSException {
        monitor.beginTask(null, 100);
        try {
            RemoteFolderTreeBuilder builder = new RemoteFolderTreeBuilder(repository, file.getParent(), tag);
            RemoteFile remote = builder.buildTree(file, Policy.subMonitorFor(monitor, 10));
            if (remote == null) {
                return null;
            }
            byte[] syncBytes = remote.getSyncBytes();
            if (builder.getFileDiffs().length > 0) {
                remote.getStorage(Policy.subMonitorFor(monitor, 90));
            }
            remote.setSyncBytes(syncBytes, 1);
            RemoteFile remoteFile = remote;
            return remoteFile;
        }
        catch (TeamException e) {
            throw CVSException.wrapException((CoreException)((Object)e));
        }
        finally {
            monitor.done();
        }
    }

    public UpdateContentCachingService(CVSRepositoryLocation repository, RemoteFolder tree, CVSTag tag, int depth) {
        this.repository = repository;
        this.remoteRoot = tree;
        this.tag = tag;
        this.depth = depth;
    }

    private boolean cacheFileContents(IProgressMonitor monitor) throws CVSException {
        monitor.beginTask(null, 100);
        Policy.checkCanceled(monitor);
        Session session = new Session(this.repository, this.remoteRoot, false);
        session.open(Policy.subMonitorFor(monitor, 10), false);
        try {
            Policy.checkCanceled(monitor);
            IStatus status = new SandboxUpdate().execute(session, Command.NO_GLOBAL_OPTIONS, this.getLocalOptions(), new String[]{"."}, (ICommandOutputListener)new UpdateListener(this), Policy.subMonitorFor(monitor, 90));
            if (!status.isOK()) {
                if (status.getCode() == -10) {
                    CVSServerException e = new CVSServerException(status);
                    if (!e.isNoTagException() && e.containsErrors()) {
                        throw e;
                    }
                    return false;
                }
                if (status.getSeverity() == 4 && this.isReportableError(status)) {
                    throw new CVSException(status);
                }
            }
            for (ICVSResource resource : this.removed) {
                if (!resource.exists()) continue;
                resource.delete();
            }
        }
        finally {
            session.close();
            monitor.done();
        }
        return true;
    }

    private boolean isReportableError(IStatus status) {
        return CVSStatus.isInternalError(status) || status.getCode() == -6 || status.getCode() == -27 || status.getCode() == -28;
    }

    private Command.LocalOption[] getLocalOptions() {
        ArrayList<Command.LocalOption> options = new ArrayList<Command.LocalOption>();
        if (this.tag != null) {
            options.add(Update.makeTagOption(this.tag));
        }
        if (this.depth != 2) {
            options.add(Command.DO_NOT_RECURSE);
        }
        if (this.fetchAbsentDirectories) {
            options.add(Update.RETRIEVE_ABSENT_DIRECTORIES);
        }
        if (!options.isEmpty()) {
            return options.toArray(new Command.LocalOption[options.size()]);
        }
        return Command.NO_LOCAL_OPTIONS;
    }

    @Override
    public void directoryDoesNotExist(ICVSFolder commandRoot, String path) {
        try {
            this.removed.add(commandRoot.getChild(path));
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
        }
    }

    @Override
    public void directoryInformation(ICVSFolder commandRoot, String path, boolean newDirectory) {
    }

    @Override
    public void fileDoesNotExist(ICVSFolder parent, String filename) {
        try {
            this.removed.add(parent.getChild(filename));
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
        }
    }

    @Override
    public void fileInformation(int type, ICVSFolder parent, String filename) {
    }

    public class SandboxUpdate
    extends Update {
        @Override
        protected boolean shouldRetrieveAbsentDirectories(Session session) {
            return UpdateContentCachingService.this.fetchAbsentDirectories;
        }

        @Override
        protected IStatus commandFinished(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, ICVSResource[] resources, IProgressMonitor monitor, IStatus status) throws CVSException {
            return status;
        }

        @Override
        protected IStatus doExecute(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, String[] arguments, ICommandOutputListener listener, IProgressMonitor monitor) throws CVSException {
            session.registerResponseHandler(new SandboxUpdatedHandler(4));
            session.registerResponseHandler(new SandboxUpdatedHandler(2));
            session.registerResponseHandler(new SandboxUpdatedHandler(3));
            session.registerResponseHandler(new SandboxUpdatedHandler(1));
            return super.doExecute(session, globalOptions, localOptions, arguments, listener, monitor);
        }
    }

    public class SandboxUpdatedHandler
    extends UpdatedHandler {
        public SandboxUpdatedHandler(int type) {
            super(type);
        }

        @Override
        protected void receiveTargetFile(Session session, ICVSFile mFile, String entryLine, Date modTime, boolean binary, boolean readOnly, boolean executable, IProgressMonitor monitor) throws CVSException {
            ResourceSyncInfo info = new ResourceSyncInfo(entryLine, modTime);
            mFile.setSyncInfo(info, 1);
            session.receiveFile(mFile, binary, this.getHandlerType(), monitor);
            try {
                if (executable) {
                    mFile.setExecutable(true);
                }
            }
            catch (CVSException e) {
                CVSProviderPlugin.log((CoreException)((Object)e));
            }
        }
    }
}

