/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.SVNNotification;
import org.eclipse.team.svn.core.operation.IRevisionProvider;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class RenameResourceOperation
extends AbstractRepositoryOperation
implements IRevisionProvider {
    protected String message;
    protected String newName;
    protected IRevisionProvider.RevisionPair[] revisionPair;

    public RenameResourceOperation(IRepositoryResource resource, String newName, String message) {
        super("Operation_Rename", SVNMessages.class, new IRepositoryResource[]{resource});
        this.message = message;
        this.newName = newName;
    }

    public IRevisionProvider.RevisionPair[] getRevisions() {
        return this.revisionPair;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource resource = this.operableData()[0];
        this.revisionPair = new IRevisionProvider.RevisionPair[1];
        final IRepositoryLocation location = resource.getRepositoryLocation();
        ISVNConnector proxy = location.acquireSVNProxy();
        final String newUrl = String.valueOf(resource.getParent().getUrl()) + "/" + this.newName;
        ISVNNotificationCallback notify = new ISVNNotificationCallback(){

            public void notify(SVNNotification info) {
                String[] path = new String[]{newUrl};
                RenameResourceOperation.this.revisionPair[0] = new IRevisionProvider.RevisionPair(info.revision, path, location);
                String message = SVNMessages.format(SVNMessages.Console_CommittedRevision, new String[]{String.valueOf(info.revision)});
                RenameResourceOperation.this.writeToConsole(1, message);
            }
        };
        try {
            SVNUtility.addSVNNotifyListener(proxy, notify);
            this.writeToConsole(0, "svn move \"" + resource.getUrl() + "\" \"" + newUrl + "\" -m \"" + this.message + "\"" + ISVNConnector.Options.asCommandLine(32768L) + FileUtility.getUsernameParam(location.getUsername()) + "\n");
            proxy.moveRemote(new String[]{SVNUtility.encodeURL(resource.getUrl())}, SVNUtility.encodeURL(newUrl), this.message, 32768L, null, new SVNProgressMonitor(this, monitor, null));
        }
        finally {
            SVNUtility.removeSVNNotifyListener(proxy, notify);
            resource.getRepositoryLocation().releaseSVNProxy(proxy);
        }
    }

    protected String getShortErrorMessage(Throwable t) {
        return BaseMessages.format(super.getShortErrorMessage(t), new Object[]{this.operableData()[0].getName(), this.newName});
    }
}

