/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.wizard.checkoutas;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.verifier.AbstractVerifier;
import org.eclipse.team.svn.ui.wizard.AbstractVerifiedWizardPage;
import org.eclipse.team.svn.ui.wizard.checkoutas.ProjectLocationSelectionPage;

public class ProjectsSelectionPage
extends AbstractVerifiedWizardPage {
    protected List selectedProjects;
    protected IRepositoryResource[] projects;
    protected CheckboxTableViewer listViewer;
    protected boolean respectHierarchy;
    protected boolean checkoutAsFolders;
    protected ProjectLocationSelectionPage locationPage;
    protected Button respectHierarchyButton;
    protected Button checkoutAsFolderButton;
    protected Button checkoutAsProjectButton;

    public ProjectsSelectionPage() {
        super(ProjectsSelectionPage.class.getName(), "", SVNTeamUIPlugin.instance().getImageDescriptor("icons/wizards/newconnect.gif"));
    }

    public boolean isCheckoutAsFoldersSelected() {
        return this.checkoutAsFolders;
    }

    public List getSelectedProjects() {
        return this.selectedProjects;
    }

    public boolean isRespectHierarchy() {
        return !this.checkoutAsFolders && this.respectHierarchy;
    }

    public void postInit(ProjectLocationSelectionPage locationPage, IRepositoryResource[] projects, ITableLabelProvider labelProvider, IStructuredContentProvider contentProvider) {
        this.locationPage = locationPage;
        this.projects = projects;
        this.listViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.listViewer.setContentProvider((IContentProvider)contentProvider);
        if (projects.length > 1) {
            this.setTitle(SVNUIMessages.ProjectsSelectionPage_Title_Multi);
            this.setDescription(SVNUIMessages.ProjectsSelectionPage_Description_Multi);
        } else {
            this.setTitle(SVNUIMessages.ProjectsSelectionPage_Title_Single);
            this.setDescription(SVNUIMessages.ProjectsSelectionPage_Description_Single);
        }
        this.checkoutAsFolderButton.setText(this.projects.length > 0 ? SVNUIMessages.ProjectsSelectionPage_CheckoutAsFolder_Multi : SVNUIMessages.ProjectsSelectionPage_CheckoutAsFolder_Single);
        this.checkoutAsProjectButton.setText(this.projects.length > 0 ? SVNUIMessages.ProjectsSelectionPage_CheckoutAsProject_Multi : SVNUIMessages.ProjectsSelectionPage_CheckoutAsProject_Single);
        this.listViewer.setInput((Object)projects);
        this.listViewer.setAllChecked(true);
        this.refreshSelectedResult();
        this.validateContent();
    }

    public Composite createControlImpl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 12;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Composite coTypeComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        coTypeComposite.setLayout((Layout)layout);
        data = new GridData(768);
        coTypeComposite.setLayoutData((Object)data);
        this.checkoutAsFolderButton = new Button(coTypeComposite, 16);
        data = new GridData(768);
        this.checkoutAsFolderButton.setLayoutData((Object)data);
        this.checkoutAsFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectsSelectionPage.this.checkoutAsFolders = true;
                ProjectsSelectionPage.this.respectHierarchyButton.setEnabled(false);
                ProjectsSelectionPage.this.validateContent();
            }
        });
        this.checkoutAsFolderButton.setSelection(false);
        this.checkoutAsProjectButton = new Button(coTypeComposite, 16);
        data = new GridData(768);
        this.checkoutAsProjectButton.setLayoutData((Object)data);
        this.checkoutAsProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectsSelectionPage.this.checkoutAsFolders = false;
                ProjectsSelectionPage.this.respectHierarchyButton.setEnabled(true);
                ProjectsSelectionPage.this.validateContent();
            }
        });
        this.checkoutAsProjectButton.setSelection(true);
        this.listViewer = this.createViewer(composite);
        data = new GridData(1808);
        data.widthHint = 200;
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectsSelectionPage.this.refreshSelectedResult();
                ProjectsSelectionPage.this.validateContent();
            }
        });
        layout = null;
        this.attachTo((Control)this.listViewer.getTable(), new AbstractVerifier(){

            protected String getWarningMessage(Control input) {
                return null;
            }

            protected String getErrorMessage(Control input) {
                Object[] elements = ProjectsSelectionPage.this.listViewer.getCheckedElements();
                return elements == null || elements.length == 0 ? SVNUIMessages.ProjectsSelectionPage_CheckoutAsProject_Verifier_Error : null;
            }
        });
        Composite bottomPart = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        bottomPart.setLayout((Layout)layout);
        data = new GridData(768);
        bottomPart.setLayoutData((Object)data);
        Composite tComposite = new Composite(bottomPart, 16384);
        GridLayout gLayout = new GridLayout();
        gLayout.numColumns = 2;
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        tComposite.setLayout((Layout)gLayout);
        data = new GridData(1840);
        data.grabExcessHorizontalSpace = true;
        tComposite.setData((Object)data);
        Button selectButton = new Button(tComposite, 8);
        selectButton.setText(SVNUIMessages.Button_SelectAll);
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(selectButton);
        selectButton.setLayoutData((Object)data);
        selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectsSelectionPage.this.listViewer.setAllChecked(true);
                ProjectsSelectionPage.this.refreshSelectedResult();
                ProjectsSelectionPage.this.validateContent();
            }
        });
        Button deselectButton = new Button(tComposite, 8);
        deselectButton.setText(SVNUIMessages.Button_ClearSelection);
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(deselectButton);
        deselectButton.setLayoutData((Object)data);
        deselectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectsSelectionPage.this.listViewer.setAllChecked(false);
                ProjectsSelectionPage.this.refreshSelectedResult();
                ProjectsSelectionPage.this.validateContent();
            }
        });
        this.respectHierarchyButton = new Button(bottomPart, 32);
        this.respectHierarchyButton.setText(SVNUIMessages.ProjectsSelectionPage_RespectHierarchy);
        this.respectHierarchyButton.setLayoutData((Object)new GridData(896));
        this.respectHierarchyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectsSelectionPage.this.respectHierarchy = ((Button)e.widget).getSelection();
                if (ProjectsSelectionPage.this.locationPage != null) {
                    ProjectsSelectionPage.this.locationPage.setUseDefaultLocation(!ProjectsSelectionPage.this.respectHierarchy);
                    ProjectsSelectionPage.this.locationPage.validateContent();
                }
                ProjectsSelectionPage.this.validateContent();
            }
        });
        return composite;
    }

    protected CheckboxTableViewer createViewer(Composite parent) {
        Table table = new Table(parent, 68384);
        TableLayout layout = new TableLayout();
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        table.setLayout((Layout)layout);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        CheckboxTableViewer viewer = new CheckboxTableViewer(table);
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(false);
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(20, false));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(SVNUIMessages.ProjectsSelectionPage_RepositoryURL);
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(270, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(SVNUIMessages.ProjectsSelectionPage_ProjectName);
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(150, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(SVNUIMessages.ProjectsSelectionPage_ProjectType);
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(100, true));
        return viewer;
    }

    public void refreshSelectedResult() {
        if (this.projects != null) {
            ArrayList<IRepositoryResource> list = new ArrayList<IRepositoryResource>();
            int i = 0;
            while (i < this.projects.length) {
                if (this.listViewer.getChecked((Object)this.projects[i])) {
                    list.add(this.projects[i]);
                }
                ++i;
            }
            this.selectedProjects = list;
        }
    }
}

