/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.cpuusage;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.cpuusage.CpuUsageEntryModel;
import org.eclipse.tracecompass.analysis.os.linux.core.cpuusage.KernelCpuUsageAnalysis;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.cpuusage.Messages;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.SelectedCpuQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.AbstractTreeCommonXDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.internal.tmf.core.model.YModel;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class CpuUsageDataProvider
extends AbstractTreeCommonXDataProvider<KernelCpuUsageAnalysis, CpuUsageEntryModel> {
    public static final String TOTAL = "total:";
    public static final String ID = "org.eclipse.tracecompass.analysis.os.linux.core.cpuusage.CpuUsageDataProvider";
    public static final int TOTAL_SERIES_TID = -2;
    private final Map<String, String> fProcessNameMap = new HashMap<String, String>();
    private @Nullable ITmfStateSystem fKernelSs;

    public static @Nullable CpuUsageDataProvider create(ITmfTrace trace) {
        KernelCpuUsageAnalysis module = (KernelCpuUsageAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, KernelCpuUsageAnalysis.class, (String)"org.eclipse.tracecompass.analysis.os.linux.cpuusage");
        if (module != null) {
            module.schedule();
            return new CpuUsageDataProvider(trace, module);
        }
        return null;
    }

    private CpuUsageDataProvider(ITmfTrace trace, KernelCpuUsageAnalysis module) {
        super(trace, (TmfStateSystemAnalysisModule)module);
    }

    protected @Nullable Map<String, IYModel> getYModels(ITmfStateSystem ss, SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        Set cpus = Collections.emptySet();
        if (filter instanceof SelectedCpuQueryFilter) {
            cpus = ((SelectedCpuQueryFilter)filter).getSelectedCpus();
        }
        long[] xValues = filter.getTimesRequested();
        double[] totalValues = new double[xValues.length];
        HashMap<String, double[]> selectedThreadValues = new HashMap<String, double[]>();
        for (Integer tidInt : this.getSelectedQuarks(filter)) {
            selectedThreadValues.put(Integer.toString(tidInt), new double[xValues.length]);
        }
        long prevTime = Math.max(filter.getStart(), ss.getStartTime());
        long currentEnd = ss.getCurrentEndTime();
        int i = 1;
        while (i < xValues.length) {
            long time = xValues[i];
            if (time >= ss.getStartTime() && time <= currentEnd && prevTime < time) {
                Map cpuUsageMap = Maps.filterKeys(((KernelCpuUsageAnalysis)this.getAnalysisModule()).getCpuUsageInRange(cpus, prevTime, time), key -> key.startsWith("total"));
                long totalCpu = 0L;
                for (Map.Entry entry : cpuUsageMap.entrySet()) {
                    String threadName = CpuUsageDataProvider.extractThreadName((String)entry.getKey());
                    if (threadName == null) continue;
                    long cpuTime = (Long)entry.getValue();
                    totalCpu += cpuTime;
                    double[] values = (double[])selectedThreadValues.get(threadName);
                    if (values == null) continue;
                    values[i] = CpuUsageDataProvider.normalize(prevTime, time, cpuTime);
                }
                totalValues[i] = CpuUsageDataProvider.normalize(prevTime, time, totalCpu);
                prevTime = time;
            }
            if (monitor != null && monitor.isCanceled()) {
                return null;
            }
            ++i;
        }
        ImmutableMap.Builder ySeries = ImmutableMap.builder();
        String key2 = TOTAL + this.getTrace().getName();
        ySeries.put((Object)key2, (Object)new YModel(key2, totalValues));
        for (Map.Entry entry : selectedThreadValues.entrySet()) {
            String selectedThread = String.valueOf(this.getTrace().getName()) + ':' + (String)entry.getKey();
            ySeries.put((Object)selectedThread, (Object)new YModel(selectedThread, (double[])entry.getValue()));
        }
        return ySeries.build();
    }

    private static double normalize(long prevTime, long time, long value) {
        return (double)value / (double)(time - prevTime) * 100.0;
    }

    private static @Nullable String extractThreadName(String key) {
        String[] strings = key.split("/", 2);
        if (strings.length > 1 && !strings[1].equals("0")) {
            return strings[1];
        }
        return null;
    }

    protected List<CpuUsageEntryModel> getTree(ITmfStateSystem ss, TimeQueryFilter filter, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        if (!(filter instanceof SelectedCpuQueryFilter)) {
            return Collections.emptyList();
        }
        SelectedCpuQueryFilter cpuQueryFilter = (SelectedCpuQueryFilter)filter;
        long end = filter.getEnd();
        ITmfStateSystem kernelSs = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)this.getTrace(), (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        if (kernelSs == null) {
            throw new StateSystemDisposedException();
        }
        ArrayList<CpuUsageEntryModel> entryList = new ArrayList<CpuUsageEntryModel>();
        Map<String, Long> cpuUsageMap = ((KernelCpuUsageAnalysis)this.getAnalysisModule()).getCpuUsageInRange(cpuQueryFilter.getSelectedCpus(), filter.getStart(), end);
        long totalTime = cpuUsageMap.getOrDefault("total", 0L);
        long totalId = this.getId(-1);
        entryList.add(new CpuUsageEntryModel(totalId, -1L, this.getTrace().getName(), -2, totalTime));
        for (Map.Entry<String, Long> entry : cpuUsageMap.entrySet()) {
            int tid;
            String[] strings;
            String key = entry.getKey();
            if (entry.getValue() == 0L || !key.startsWith("total") || (strings = key.split("/", 2)).length <= 1 || (tid = Integer.parseInt(strings[1])) == 0) continue;
            entryList.add(new CpuUsageEntryModel(this.getId(tid), totalId, this.getProcessName(strings[1], filter.getStart()), tid, entry.getValue()));
        }
        return entryList;
    }

    private String getProcessName(String tid, long start) {
        String execName = this.fProcessNameMap.get(tid);
        if (execName != null) {
            return execName;
        }
        ITmfStateSystem kernelSs = this.fKernelSs;
        if (kernelSs == null) {
            kernelSs = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)this.getTrace(), (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        }
        if (kernelSs == null) {
            return tid;
        }
        this.fKernelSs = kernelSs;
        int execNameQuark = kernelSs.optQuarkAbsolute(new String[]{"Threads", tid, "Exec_name"});
        if (execNameQuark == -2) {
            return tid;
        }
        StateSystemUtils.QuarkIterator iterator = new StateSystemUtils.QuarkIterator(kernelSs, execNameQuark, start);
        UnmodifiableIterator names = Iterators.filter((Iterator)Iterators.transform((Iterator)iterator, ITmfStateInterval::getValue), String.class);
        if (names.hasNext()) {
            execName = (String)names.next();
            this.fProcessNameMap.put(tid, execName);
            return execName;
        }
        return tid;
    }

    public String getId() {
        return ID;
    }

    protected boolean isCacheable() {
        return false;
    }

    protected String getTitle() {
        return Objects.requireNonNull(Messages.CpuUsageDataProvider_title);
    }
}

