/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.handlers;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.tracecompass.tmf.ui.project.wizards.RenameTraceDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.handlers.HandlerUtil;

public class RenameTraceHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object element;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        TmfTraceElement selectedTrace = null;
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof TmfTraceElement) {
            selectedTrace = (TmfTraceElement)element;
        }
        if (selectedTrace == null) {
            return null;
        }
        final TmfTraceElement oldTrace = selectedTrace.getElementUnderTraceFolder();
        RenameTraceDialog dialog = new RenameTraceDialog(window.getShell(), oldTrace);
        if (dialog.open() != 0) {
            return null;
        }
        final TmfTraceFolder traceFolder = (TmfTraceFolder)oldTrace.getParent();
        final String newName = (String)dialog.getFirstResult();
        IFolder parentFolder = (IFolder)oldTrace.getParent().getResource();
        final TmfTraceFolder tracesFolder = oldTrace.getProject().getTracesFolder();
        final TmfExperimentFolder experimentFolder = oldTrace.getProject().getExperimentsFolder();
        if (tracesFolder == null || experimentFolder == null) {
            return null;
        }
        final IPath newPath = parentFolder.getFullPath().append(newName);
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    monitor.beginTask("", 1000);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            oldTrace.closeEditors();
                        }
                    });
                    if (oldTrace.getResource() instanceof IFolder) {
                        IFile newBookmarksFile;
                        IFolder folder = (IFolder)oldTrace.getResource();
                        IFile bookmarksFile = oldTrace.getBookmarksFile();
                        if (bookmarksFile.exists() && !(newBookmarksFile = folder.getFile(bookmarksFile.getName().replace(oldTrace.getName(), newName))).exists()) {
                            IPath newBookmarksPath = newBookmarksFile.getFullPath();
                            bookmarksFile.move(newBookmarksPath, 33, monitor);
                        }
                    }
                    String newElementPath = newPath.makeRelativeTo(tracesFolder.getPath()).toString();
                    oldTrace.renameSupplementaryFolder(newElementPath);
                    oldTrace.getResource().move(newPath, 33, monitor);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)operation);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            TraceUtils.displayErrorMsg(e.toString(), e.getTargetException().toString());
            return null;
        }
        operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                TmfTraceElement newTrace = null;
                String newElementPath = oldTrace.getParent().getPath().append(newName).makeRelativeTo(tracesFolder.getPath()).toString();
                for (TmfTraceElement element : traceFolder.getTraces()) {
                    if (!element.getElementPath().equals(newElementPath)) continue;
                    newTrace = element;
                    break;
                }
                if (newTrace == null) {
                    return;
                }
                for (TmfExperimentElement experiment : experimentFolder.getExperiments()) {
                    for (TmfTraceElement expTrace : experiment.getTraces()) {
                        if (!expTrace.getElementPath().equals(oldTrace.getElementPath())) continue;
                        experiment.removeTrace(expTrace);
                        experiment.addTrace(newTrace);
                    }
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)operation);
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException e) {
            TraceUtils.displayErrorMsg(e.toString(), e.getTargetException().toString());
        }
        return null;
    }
}

