/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.aggregators;

import com.google.common.collect.SortedMultiset;
import com.google.common.collect.TreeMultiset;
import org.eclipse.viatra.query.runtime.matchers.psystem.aggregations.AbstractMultisetAggregationOperator;

public class ExtremumOperator<T extends Comparable<T>>
extends AbstractMultisetAggregationOperator<T, SortedMultiset<T>, T> {
    private static final ExtremumOperator MIN_OP = new ExtremumOperator(Extreme.MIN);
    private static final ExtremumOperator MAX_OP = new ExtremumOperator(Extreme.MAX);
    Extreme extreme;

    public static <T extends Comparable<T>> ExtremumOperator<T> getMin() {
        return MIN_OP;
    }

    public static <T extends Comparable<T>> ExtremumOperator<T> getMax() {
        return MAX_OP;
    }

    private ExtremumOperator(Extreme extreme) {
        this.extreme = extreme;
    }

    @Override
    public String getShortDescription() {
        String opName = this.getName();
        return String.format("%s incrementally computes the %simum of java.lang.Comparable values, using the default comparison", opName, opName);
    }

    @Override
    public String getName() {
        return this.extreme.name().toLowerCase();
    }

    @Override
    public SortedMultiset<T> createNeutral() {
        return TreeMultiset.create();
    }

    @Override
    public boolean isNeutral(SortedMultiset<T> result) {
        return result.isEmpty();
    }

    @Override
    public SortedMultiset<T> update(SortedMultiset<T> oldResult, T updateValue, boolean isInsertion) {
        if (isInsertion) {
            oldResult.add(updateValue);
        } else {
            oldResult.remove(updateValue);
        }
        return oldResult;
    }

    @Override
    public T getAggregate(SortedMultiset<T> result) {
        return (T)(result.isEmpty() ? null : (Comparable)this.extreme.pickFrom(result));
    }

    public static enum Extreme {
        MIN,
        MAX;


        public <T> T pickFrom(SortedMultiset<T> nonEmptyMultiSet) {
            switch (this) {
                case MIN: {
                    return (T)nonEmptyMultiSet.firstEntry().getElement();
                }
                case MAX: {
                    return (T)nonEmptyMultiSet.lastEntry().getElement();
                }
            }
            return null;
        }
    }
}

