/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.layout.absolute;

import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.util.ObjectInfoAction;
import org.eclipse.wb.internal.core.utils.state.GlobalState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OrderingSupport {
    private final List<? extends IAbstractComponentInfo> m_components;
    private final IAbstractComponentInfo m_component;

    public OrderingSupport(List<? extends IAbstractComponentInfo> components, IAbstractComponentInfo component) {
        this.m_components = components;
        this.m_component = component;
    }

    public void contributeActions(IMenuManager manager) {
        MenuManager orderMenuManager = new MenuManager(ModelMessages.OrderingSupport_orderManager);
        manager.appendToGroup("org.eclipse.wb.popup.group.constraints", (IContributionItem)orderMenuManager);
        boolean isFirst = this.m_components.indexOf(this.m_component) == 0;
        boolean isLast = this.m_components.indexOf(this.m_component) == this.m_components.size() - 1;
        orderMenuManager.add((IAction)new OrderAction(this, ModelMessages.OrderingSupport_bringToFront, "bring_to_front.png", !isFirst){

            protected void runEx() throws Exception {
                GlobalState.getOrderProcessor().move(m_component, this.getFirstSibling());
            }
        });
        orderMenuManager.add((IAction)new OrderAction(this, ModelMessages.OrderingSupport_sendToBack, "send_to_back.png", !isLast){

            protected void runEx() throws Exception {
                GlobalState.getOrderProcessor().move(m_component, null);
            }
        });
        orderMenuManager.add((IAction)new OrderAction(this, ModelMessages.OrderingSupport_bringForward, "bring_forward.png", !isFirst){

            protected void runEx() throws Exception {
                GlobalState.getOrderProcessor().move(m_component, this.getPreviousSibling());
            }
        });
        orderMenuManager.add((IAction)new OrderAction(this, ModelMessages.OrderingSupport_sendBackward, "send_backward.png", !isLast){

            protected void runEx() throws Exception {
                GlobalState.getOrderProcessor().move(m_component, this.getNextSibling());
            }
        });
    }

    private IAbstractComponentInfo getFirstSibling() {
        return this.m_components.get(0);
    }

    private IAbstractComponentInfo getPreviousSibling() {
        int index = this.m_components.indexOf(this.m_component);
        return index != 0 ? this.m_components.get(index - 1) : null;
    }

    private IAbstractComponentInfo getNextSibling() {
        int index = this.m_components.indexOf(this.m_component);
        return index + 2 < this.m_components.size() ? this.m_components.get(index + 2) : null;
    }

    private abstract class OrderAction
    extends ObjectInfoAction {
        public OrderAction(String text, String imageName, boolean enabled) {
            super(OrderingSupport.this.m_component.getUnderlyingModel());
            this.setText(text);
            this.setImageDescriptor(DesignerPlugin.getImageDescriptor("info/layout/absolute/" + imageName));
            this.setEnabled(enabled);
        }
    }
}

