/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.reflect;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntrospectionHelper {
    private final Class<?> m_clazz;
    private List<BeanInfo> m_beanInfos;
    private BeanDescriptor m_beanDescriptor;

    public IntrospectionHelper(Class<?> clazz) {
        this.m_clazz = clazz;
    }

    public BeanDescriptor getBeanDescriptor() throws IntrospectionException {
        if (this.m_beanDescriptor == null) {
            class BeanDescData {
                String name;
                String displayName;
                String shortDescription;
                Class<?> customizerClass;
                Map<String, Object> values = Maps.newTreeMap();

                BeanDescData() {
                }
            }
            BeanDescData beanDescData = new BeanDescData();
            for (BeanInfo beanInfo : this.getBeanInfos()) {
                BeanDescriptor desc = beanInfo.getBeanDescriptor();
                if (desc == null) continue;
                if (beanDescData.name == null) {
                    beanDescData.name = desc.getName();
                }
                if (beanDescData.displayName == null) {
                    beanDescData.displayName = desc.getDisplayName();
                }
                if (beanDescData.shortDescription == null) {
                    beanDescData.shortDescription = desc.getShortDescription();
                }
                if (beanDescData.customizerClass == null) {
                    beanDescData.customizerClass = desc.getCustomizerClass();
                }
                Enumeration<String> attrNames = desc.attributeNames();
                while (attrNames.hasMoreElements()) {
                    String name = attrNames.nextElement();
                    Object value = desc.getValue(name);
                    if (beanDescData.values.containsKey(name)) continue;
                    beanDescData.values.put(name, value);
                }
            }
            this.m_beanDescriptor = new BeanDescriptor(this.m_clazz, beanDescData.customizerClass);
            this.m_beanDescriptor.setName(beanDescData.name);
            this.m_beanDescriptor.setDisplayName(beanDescData.displayName);
            this.m_beanDescriptor.setShortDescription(beanDescData.shortDescription);
            for (Map.Entry entry : beanDescData.values.entrySet()) {
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                this.m_beanDescriptor.setValue(name, value);
            }
        }
        return this.m_beanDescriptor;
    }

    private List<BeanInfo> getBeanInfos() throws IntrospectionException {
        if (this.m_beanInfos == null) {
            this.m_beanInfos = Lists.newArrayList();
            Class<?> cls = this.m_clazz;
            while (cls != null) {
                BeanInfo info = Introspector.getBeanInfo(cls);
                this.m_beanInfos.add(info);
                cls = cls.getSuperclass();
            }
        }
        return this.m_beanInfos;
    }
}

