/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.zookeeper.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.ServiceInfo;
import org.eclipse.ecf.discovery.ServiceProperties;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.discovery.identity.ServiceIDFactory;
import org.eclipse.ecf.provider.zookeeper.core.ZooDiscoveryContainer;
import org.eclipse.ecf.provider.zookeeper.core.ZooDiscoveryNamespace;
import org.eclipse.ecf.provider.zookeeper.core.ZooDiscoveryServiceID;
import org.eclipse.ecf.provider.zookeeper.core.ZooDiscoveryServiceTypeID;
import org.eclipse.ecf.provider.zookeeper.core.internal.Configurator;
import org.eclipse.ecf.provider.zookeeper.core.internal.IService;
import org.eclipse.ecf.provider.zookeeper.node.internal.INode;
import org.eclipse.ecf.provider.zookeeper.util.Geo;
import org.eclipse.ecf.provider.zookeeper.util.Logger;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvertisedService
extends ServiceInfo
implements INode,
IService {
    private static final long serialVersionUID = 1001026250299416572L;
    private String uuid;
    private Map<String, Object> nodeProperties = new HashMap<String, Object>();
    private static Map<String, IServiceInfo> publishedServices = new HashMap<String, IServiceInfo>();
    private ServiceReference serviceReference;

    public AdvertisedService(ServiceReference ref) {
        Assert.isNotNull((Object)ref);
        this.serviceReference = ref;
        this.uuid = UUID.randomUUID().toString();
        this.properties = new ServiceProperties();
        String[] services = (String[])this.serviceReference.getProperty("objectClass");
        String[] stringArray = this.serviceReference.getPropertyKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyKey = stringArray[n2];
            this.properties.setProperty(propertyKey, this.serviceReference.getProperty(propertyKey));
            ++n2;
        }
        Object serviceTypeID = ServiceIDFactory.getDefault().createServiceTypeID(ZooDiscoveryContainer.getSingleton().getConnectNamespace(), services, IServiceTypeID.DEFAULT_PROTO);
        serviceTypeID = new ZooDiscoveryServiceTypeID((ZooDiscoveryNamespace)ZooDiscoveryContainer.getSingleton().getConnectNamespace(), (IServiceTypeID)serviceTypeID, this.serviceReference.getProperty("service.id").toString());
        this.serviceID = new ZooDiscoveryServiceID(ZooDiscoveryContainer.getSingleton().getConnectNamespace(), (IServiceTypeID)serviceTypeID, Geo.getLocation());
        this.setNodeProperties();
    }

    public AdvertisedService(IServiceInfo serviceInfo) {
        super(serviceInfo.getLocation(), serviceInfo.getServiceName(), serviceInfo.getServiceID().getServiceTypeID(), serviceInfo.getPriority(), serviceInfo.getWeight(), serviceInfo.getServiceProperties());
        this.uuid = UUID.randomUUID().toString();
        this.setNodeProperties();
    }

    private void setNodeProperties() {
        this.nodeProperties.put("node.property.service.name", this.getServiceName());
        this.nodeProperties.put("node.property.service.properties", this.properties);
        this.nodeProperties.put("node.property.name.protocols", this.getServiceID().getServiceTypeID().getProtocols());
        this.nodeProperties.put("node.property.name.scope", this.getServiceID().getServiceTypeID().getScopes());
        this.nodeProperties.put("node.property.name.services", this.getServiceID().getServiceTypeID().getServices());
        this.nodeProperties.put("node.property.name.na", this.getServiceID().getServiceTypeID().getNamingAuthority());
        this.nodeProperties.put("discovery.service.location", this.getLocation());
        this.nodeProperties.put("discovery.service.weight", this.getWeight());
        this.nodeProperties.put("discovery.service.priority", this.getPriority());
        publishedServices.put(this.getServiceID().getName(), this);
    }

    public static Map<String, IServiceInfo> getPublishedServices() {
        return Collections.unmodifiableMap(publishedServices);
    }

    public static synchronized IServiceInfo removePublished(String id) {
        return publishedServices.remove(id);
    }

    public String getNodeId() {
        return this.uuid;
    }

    @Override
    public void regenerateNodeId() {
        this.uuid = UUID.randomUUID().toString();
    }

    public URI getLocation() {
        return this.serviceID.getLocation();
    }

    public IServiceID getServiceID() {
        return this.serviceID;
    }

    public int compareTo(Object o) {
        Assert.isTrue((o != null && o instanceof IServiceInfo ? 1 : 0) != 0, (String)"incompatible types for compare");
        return this.getServiceID().getName().compareTo(((IServiceInfo)o).getServiceID().getName());
    }

    public ServiceReference getServiceReference() {
        return this.serviceReference;
    }

    @Override
    public byte[] getPropertiesAsBytes() {
        byte[] bytes;
        block20: {
            ByteArrayOutputStream baout = new ByteArrayOutputStream();
            ObjectOutputStream oout = null;
            bytes = null;
            try {
                try {
                    oout = new ObjectOutputStream(baout);
                    oout.writeObject(this.nodeProperties);
                    oout.flush();
                    bytes = baout.toByteArray();
                }
                catch (IOException e) {
                    Logger.log(1, "Error while serializing node data ", e);
                    if (oout != null) {
                        try {
                            oout.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (baout == null) break block20;
                    try {
                        baout.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (oout != null) {
                    try {
                        oout.close();
                    }
                    catch (IOException iOException) {}
                }
                if (baout != null) {
                    try {
                        baout.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return bytes;
    }

    @Override
    public String getPath() {
        return String.valueOf(this.getNodeId()) + "_uri_" + Geo.getHost() + "_zdid_" + Configurator.INSTANCE.getID().getName();
    }

    @Override
    public String getAbsolutePath() {
        return "/zoodiscovery_root/" + this.getPath();
    }

    @Override
    public boolean isLocalNode() {
        return Geo.isLocal(this.getAbsolutePath());
    }

    @Override
    public IService getWrappedService() {
        return this;
    }
}

