/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.generic;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.ecf.internal.provider.ProviderPlugin;
import org.eclipse.ecf.provider.comm.IConnectRequestHandler;
import org.eclipse.ecf.provider.comm.tcp.Client;
import org.eclipse.ecf.provider.comm.tcp.ConnectRequestMessage;
import org.eclipse.ecf.provider.comm.tcp.ConnectResultMessage;
import org.eclipse.ecf.provider.comm.tcp.ISocketAcceptHandler;
import org.eclipse.ecf.provider.generic.SOContainer;

public class SOContainerGroup
implements ISocketAcceptHandler {
    public static final String INVALID_CONNECT = "Invalid connect request.";
    String name;
    protected Map map;

    public SOContainerGroup(String name) {
        this.name = name;
        this.map = Collections.synchronizedMap(new TreeMap());
    }

    public String add(String key, SOContainer aSpace) {
        if (key == null || aSpace == null) {
            return null;
        }
        this.map.put(key, aSpace);
        return key;
    }

    public SOContainer get(String key) {
        if (key == null) {
            return null;
        }
        return (SOContainer)((Object)this.map.get(key));
    }

    public SOContainer remove(String key) {
        if (key == null) {
            return null;
        }
        return (SOContainer)((Object)this.map.remove(key));
    }

    public boolean contains(String key) {
        if (key == null) {
            return false;
        }
        return this.map.containsKey(key);
    }

    public String getName() {
        return this.name;
    }

    public Iterator elements() {
        return this.map.values().iterator();
    }

    protected ObjectOutputStream createObjectOutputStream(Socket aSocket) throws IOException {
        return new ObjectOutputStream(aSocket.getOutputStream());
    }

    protected ObjectInputStream createObjectInputStream(Socket aSocket) throws IOException {
        return ProviderPlugin.getDefault().createObjectInputStream(aSocket.getInputStream());
    }

    protected ConnectRequestMessage readConnectRequestMessage(ObjectInputStream ins) throws IOException, ClassNotFoundException {
        ConnectRequestMessage req = (ConnectRequestMessage)ins.readObject();
        if (req == null) {
            throw new InvalidObjectException("Invalid connect request. Connect request message cannot be null");
        }
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAccept(Socket aSocket) throws Exception {
        Object outputStreamLock;
        aSocket.setTcpNoDelay(true);
        ObjectOutputStream oStream = this.createObjectOutputStream(aSocket);
        oStream.flush();
        ObjectInputStream iStream = this.createObjectInputStream(aSocket);
        ConnectRequestMessage req = this.readConnectRequestMessage(iStream);
        URI uri = req.getTarget();
        if (uri == null) {
            throw new InvalidObjectException("Invalid connect request. URI connect target cannot be null");
        }
        String path = uri.getPath();
        if (path == null) {
            throw new InvalidObjectException("Invalid connect request. Path cannot be null");
        }
        SOContainer srs = this.get(path);
        if (srs == null) {
            throw new InvalidObjectException("Container not found for path=" + path);
        }
        Client newClient = new Client(aSocket, iStream, oStream, srs.getMessageReceiver());
        Object object = outputStreamLock = newClient.getOutputStreamLock();
        synchronized (object) {
            Serializable resp = ((IConnectRequestHandler)((Object)srs)).handleConnectRequest(aSocket, path, req.getData(), newClient);
            oStream.writeObject(new ConnectResultMessage(resp));
            oStream.flush();
        }
    }
}

