/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.ServiceURL;
import ch.ethz.iks.slp.impl.ReplyMessage;
import ch.ethz.iks.slp.impl.SLPCore;
import ch.ethz.iks.slp.impl.ServiceRequest;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class ServiceReply
extends ReplyMessage {
    List urlList;

    ServiceReply(ServiceRequest req, List urls) {
        this.funcID = (byte)2;
        this.xid = req.xid;
        this.locale = req.locale;
        this.address = req.address;
        this.port = req.port;
        this.errorCode = 0;
        this.urlList = urls;
    }

    ServiceReply(DataInputStream input) throws ServiceLocationException, IOException {
        this.errorCode = input.readShort();
        int entryCount = input.readShort();
        this.urlList = new ArrayList();
        int i = 0;
        while (i < entryCount) {
            this.urlList.add(ServiceURL.fromBytes(input));
            ++i;
        }
        if (SLPCore.CONFIG.getSecurityEnabled() && !this.verify()) {
            throw new ServiceLocationException(7, this.toString());
        }
    }

    protected void writeTo(DataOutputStream out) throws IOException {
        out.writeShort(this.errorCode);
        out.writeShort(this.urlList.size());
        int i = 0;
        while (i < this.urlList.size()) {
            ((ServiceURL)this.urlList.get(i)).writeTo(out);
            ++i;
        }
    }

    protected int getSize() {
        int len = this.getHeaderSize() + 2 + 2;
        int i = 0;
        while (i < this.urlList.size()) {
            len += ((ServiceURL)this.urlList.get(i)).getLength();
            ++i;
        }
        return len;
    }

    List getResult() {
        return this.urlList;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        buffer.append(", errorCode " + this.errorCode);
        buffer.append(", URLCount " + this.urlList.size());
        buffer.append(", URLs " + this.urlList);
        return buffer.toString();
    }

    void sign(String spiStr) throws ServiceLocationException {
        List spiList = ServiceReply.stringToList(spiStr, ",");
        for (ServiceURL url : this.urlList) {
            url.sign(spiList);
        }
    }

    boolean verify() throws ServiceLocationException {
        for (ServiceURL url : this.urlList) {
            if (url.verify()) continue;
            return false;
        }
        return true;
    }
}

