/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.example.collab.ui;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.user.IUser;
import org.eclipse.ecf.example.collab.share.EclipseCollabSharedObject;
import org.eclipse.ecf.example.collab.share.io.FileSenderUI;
import org.eclipse.ecf.internal.example.collab.ClientPlugin;
import org.eclipse.ecf.internal.example.collab.Messages;
import org.eclipse.ecf.internal.example.collab.ui.ChatLine;
import org.eclipse.ecf.internal.example.collab.ui.LineChatView;
import org.eclipse.ecf.internal.example.collab.ui.TeamChat;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class LineChatClientView
implements FileSenderUI {
    public static final String DEFAULT_UNIX_BROWSER = "mozilla";
    public static final String ENTER_STRING = "ARRIVED";
    public static final String[] EXECPROGARGTYPES;
    public static final String EXECPROGCLASSNAME;
    public static final String LEFT_STRING = "LEFT";
    public static final String MESSAGECLASSNAME;
    public static final String REMOTEFILEPATH;
    public static final String[] SHOWURLARGTYPES;
    public static final String SHOWURLCLASSNAME;
    private boolean showTimestamp = ClientPlugin.getDefault().getPreferenceStore().getBoolean("displayTimeStamp");
    private final SimpleDateFormat df = new SimpleDateFormat("MM/dd hh:mm a");
    String downloaddir;
    EclipseCollabSharedObject lch;
    Hashtable myNames = new Hashtable();
    String name;
    private final TeamChat teamChat;
    IUser userdata;
    LineChatView view;
    private final List users;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    static {
        String[] stringArray = new String[5];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.core.identity.ID");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        stringArray[1] = "[Ljava.lang.String;";
        stringArray[2] = "[Ljava.lang.String;";
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[3] = clazz2.getName();
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[4] = clazz3.getName();
        EXECPROGARGTYPES = stringArray;
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("org.eclipse.ecf.example.collab.share.url.StartProgramSharedObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        EXECPROGCLASSNAME = clazz4.getName();
        Class<?> clazz5 = class$3;
        if (clazz5 == null) {
            try {
                clazz5 = class$3 = Class.forName("org.eclipse.ecf.example.collab.share.HelloMessageSharedObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MESSAGECLASSNAME = clazz5.getName();
        REMOTEFILEPATH = null;
        String[] stringArray2 = new String[2];
        Class<?> clazz6 = class$0;
        if (clazz6 == null) {
            try {
                clazz6 = class$0 = Class.forName("org.eclipse.ecf.core.identity.ID");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray2[0] = clazz6.getName();
        stringArray2[1] = "java.lang.String";
        SHOWURLARGTYPES = stringArray2;
        Class<?> clazz7 = class$4;
        if (clazz7 == null) {
            try {
                clazz7 = class$4 = Class.forName("org.eclipse.ecf.example.collab.share.url.ShowURLSharedObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SHOWURLCLASSNAME = clazz7.getName();
    }

    public LineChatClientView(EclipseCollabSharedObject lch, LineChatView view, String name, String initText, String downloaddir) {
        this.lch = lch;
        this.view = view;
        this.name = name;
        this.teamChat = new TeamChat(this, (Composite)view.tabFolder, 0, initText);
        this.userdata = lch.getUser();
        this.downloaddir = downloaddir;
        this.users = new ArrayList();
        this.teamChat.getTableViewer().setInput((Object)this.users);
        if (this.userdata != null) {
            this.addUser(this.userdata);
        }
        ClientPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("displayTimeStamp")) {
                    LineChatClientView.this.showTimestamp = (Boolean)event.getNewValue();
                }
            }
        });
        JFaceResources.getColorRegistry().put("org.eclipse.ecf.example.collab.TOOLTIP_HEAD_BG_COLOR", new RGB(255, 255, 255));
        JFaceResources.getFontRegistry().put("org.eclipse.ecf.example.collab.TOOLTIP_HEAD_FONT", JFaceResources.getFontRegistry().getBold(JFaceResources.getDefaultFont().getFontData()[0].getName()).getFontData());
        ViewerToolTip toolTip = new ViewerToolTip(this.teamChat.getTableViewer().getControl());
        toolTip.setHideOnMouseDown(false);
        toolTip.setPopupDelay(200);
    }

    public ViewPart getView() {
        return this.view;
    }

    public Control getTextControl() {
        return this.teamChat.getTextControl();
    }

    public Control getTreeControl() {
        return this.teamChat.getTreeControl();
    }

    public boolean addUser(IUser ud) {
        if (ud == null) {
            return false;
        }
        ID userID = ud.getID();
        String username = ud.getNickname();
        if (this.myNames.containsKey(userID)) {
            String existingName = (String)this.myNames.get(userID);
            if (!existingName.equals(username)) {
                this.myNames.put(userID, username);
                this.showLine(new ChatLine(NLS.bind((String)Messages.LineChatClientView_CHANGED_NAME_TO, (Object)existingName, (Object)username)));
            }
            return false;
        }
        this.myNames.put(userID, username);
        this.addUserToTree(ud);
        this.showLine(new ChatLine(String.valueOf(username) + " " + ENTER_STRING));
        return true;
    }

    protected void addUserToTree(final IUser user) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                LineChatClientView.this.users.add(user);
                if (!LineChatClientView.this.teamChat.isDisposed()) {
                    LineChatClientView.this.teamChat.getTableViewer().add((Object)user);
                }
            }
        });
    }

    protected void appendAndScrollToBottom(final ChatLine str) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (!LineChatClientView.this.teamChat.isDisposed()) {
                    LineChatClientView.this.teamChat.appendText(str);
                }
            }
        });
    }

    public boolean changeUser(IUser user) {
        return this.changeUserInTree(user);
    }

    protected boolean changeUserInTree(final IUser userdata) {
        int i = 0;
        while (i < this.users.size()) {
            final IUser user = (IUser)this.users.get(i);
            if (user.getID().equals((Object)userdata.getID())) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (!LineChatClientView.this.teamChat.isDisposed()) {
                            TableViewer view = LineChatClientView.this.teamChat.getTableViewer();
                            view.remove((Object)user);
                            LineChatClientView.this.users.remove(user);
                            view.add((Object)userdata);
                            LineChatClientView.this.users.add(userdata);
                        }
                    }
                });
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void closeClient() {
        if (this.lch != null) {
            this.lch.chatGUIDestroy();
        }
    }

    protected String getCurrentDateTime() {
        StringBuffer sb = new StringBuffer("[");
        sb.append(this.df.format(new Date())).append(']');
        return sb.toString();
    }

    public void disposeClient() {
        this.myNames.clear();
        this.users.clear();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (!LineChatClientView.this.teamChat.isDisposed() && ((LineChatClientView)LineChatClientView.this).teamChat.chatWindow != null) {
                    ((LineChatClientView)LineChatClientView.this).teamChat.chatWindow.close();
                }
            }
        });
        this.view.disposeClient(this);
    }

    protected TeamChat getTeamChat() {
        return this.teamChat;
    }

    protected String getUserData(ID id) {
        return (String)this.myNames.get(id);
    }

    public IUser getUser(ID id) {
        if (id == null) {
            return null;
        }
        int i = 0;
        while (i < this.users.size()) {
            IUser user = (IUser)this.users.get(i);
            if (id.equals((Object)user.getID())) {
                return user;
            }
            ++i;
        }
        return null;
    }

    protected void handleTextInput(String text) {
        ChatLine line = new ChatLine(text, this.getCurrentDateTime());
        if (this.lch != null) {
            line.setOriginator(this.userdata);
        }
        this.appendAndScrollToBottom(line);
        this.teamChat.clearInput();
        if (this.lch != null) {
            this.lch.inputText(text);
        }
    }

    protected void createObject(ID target, String className, String[] args) {
        this.createObject(target, className, null, args);
    }

    protected void createObject(ID target, final String className, String[] argTypes, Object[] args) {
        if (this.lch != null) {
            HashMap<String, Object[]> map = new HashMap<String, Object[]>();
            map.put("args", args);
            map.put("types", argTypes);
            try {
                this.lch.createObject(target, className, map);
            }
            catch (Exception e) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openInformation(null, (String)Messages.LineChatClientView_EXCEPTION_MSGBOX_TITLE, (String)NLS.bind((String)Messages.LineChatClientView_EXCEPTION_MSGBOX_TEXT, (Object)className, (Object)e.getLocalizedMessage()));
                    }
                });
                e.printStackTrace();
                this.lch.chatException(e, "createObject(" + className + ")");
            }
        }
    }

    protected void refreshTreeView() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (!LineChatClientView.this.teamChat.isDisposed()) {
                    LineChatClientView.this.teamChat.getTableViewer().refresh();
                }
            }
        });
    }

    public void removeUser(ID id) {
        String name = this.getUserData(id);
        if (name != null) {
            this.showLine(new ChatLine(String.valueOf(name) + " " + LEFT_STRING));
        }
        this.myNames.remove(id);
        this.removeUserFromTree(id);
    }

    protected void removeUserFromTree(ID id) {
        if (id == null) {
            return;
        }
        int i = 0;
        while (i < this.users.size()) {
            final IUser user = (IUser)this.users.get(i);
            if (user.getID().equals((Object)id)) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (!LineChatClientView.this.teamChat.isDisposed()) {
                            LineChatClientView.this.teamChat.getTableViewer().remove((Object)user);
                        }
                    }
                });
                this.users.remove(i);
                break;
            }
            ++i;
        }
    }

    protected void runProgram(ID receiver, String program, String[] env) {
        String[] cmds = new String[]{program};
        Object[] args = new Object[]{receiver, cmds, env, receiver == null, Boolean.FALSE};
        this.createObject(null, EXECPROGCLASSNAME, EXECPROGARGTYPES, args);
    }

    public void sendData(File aFile, long dataLength) {
    }

    public void sendDone(File aFile, Exception e) {
        if (e != null) {
            this.showLine(new ChatLine(NLS.bind((String)Messages.LineChatClientView_EXCEPTION_SENDING_FILE, (Object)e.getLocalizedMessage(), (Object)aFile.getName())));
        } else {
            this.showLine(new ChatLine(NLS.bind((String)Messages.LineChatClientView_SEND_COMPLETED, (Object)aFile.getName())));
            if (this.lch != null) {
                this.lch.refreshProject();
            }
        }
    }

    public void sendStart(File aFile, long length, float rate) {
        this.showLine(new ChatLine(NLS.bind((String)Messages.LineChatClientView_SENDING_FILE, (Object)aFile.getName())));
    }

    public void setTitle(String title) {
    }

    public void showLine(ChatLine line) {
        if (this.showTimestamp) {
            line.setDate(this.getCurrentDateTime());
        }
        this.appendAndScrollToBottom(line);
    }

    public void startedTyping(final IUser user) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (!LineChatClientView.this.teamChat.isDisposed()) {
                    LineChatClientView.this.teamChat.setStatus(NLS.bind((String)Messages.LineChatClientView_TYPING, (Object)user.getNickname()));
                }
            }
        });
    }

    public void toFront() {
        this.view.setActiveTab(this.name);
    }

    private class ViewerToolTip
    extends ToolTip {
        public static final String HEADER_BG_COLOR = "org.eclipse.ecf.example.collab.TOOLTIP_HEAD_BG_COLOR";
        public static final String HEADER_FONT = "org.eclipse.ecf.example.collab.TOOLTIP_HEAD_FONT";

        public ViewerToolTip(Control control) {
            super(control);
        }

        protected Composite createToolTipContentArea(Event event, Composite parent) {
            TableItem item = LineChatClientView.this.teamChat.getTableViewer().getTable().getItem(new Point(event.x, event.y));
            IUser user = (IUser)item.getData();
            GridLayout gl = new GridLayout();
            gl.marginBottom = 0;
            gl.marginTop = 0;
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            gl.marginLeft = 0;
            gl.marginRight = 0;
            gl.verticalSpacing = 1;
            parent.setLayout((Layout)gl);
            Composite topArea = new Composite(parent, 0);
            GridData data = new GridData(4, 1, true, false);
            data.widthHint = 200;
            topArea.setLayoutData((Object)data);
            topArea.setBackground(JFaceResources.getColorRegistry().get(HEADER_BG_COLOR));
            gl = new GridLayout();
            gl.marginBottom = 2;
            gl.marginTop = 2;
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            gl.marginLeft = 5;
            gl.marginRight = 2;
            topArea.setLayout((Layout)gl);
            Label l = new Label(topArea, 0);
            l.setText(user.getNickname());
            l.setBackground(JFaceResources.getColorRegistry().get(HEADER_BG_COLOR));
            l.setFont(JFaceResources.getFontRegistry().get(HEADER_FONT));
            l.setLayoutData((Object)data);
            this.createContentArea(parent, user.getProperties()).setLayoutData((Object)new GridData(4, 4, true, true));
            return parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Control createContentArea(Composite parent, Map properties) {
            StringBuffer buffer;
            Text label = new Text(parent, 10);
            label.setBackground(parent.getDisplay().getSystemColor(29));
            StringBuffer stringBuffer = buffer = new StringBuffer();
            synchronized (stringBuffer) {
                Iterator it = properties.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    buffer.append(entry.getKey()).append(": ").append(entry.getValue());
                    buffer.append(Text.DELIMITER);
                }
            }
            label.setText(buffer.toString().trim());
            label.setLayoutData((Object)new GridData(4, 1, true, false));
            return label;
        }

        protected boolean shouldCreateToolTip(Event e) {
            if (super.shouldCreateToolTip(e)) {
                TableItem item = LineChatClientView.this.teamChat.getTableViewer().getTable().getItem(new Point(e.x, e.y));
                if (item != null) {
                    IUser user = (IUser)item.getData();
                    Map properties = user.getProperties();
                    return properties != null && !properties.isEmpty();
                }
                return false;
            }
            return false;
        }
    }
}

