/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.irc.container;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.ecf.core.AbstractContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.provider.irc.Activator;
import org.eclipse.ecf.presence.IIMMessageEvent;
import org.eclipse.ecf.presence.IIMMessageListener;
import org.eclipse.ecf.presence.chatroom.ChatRoomMessage;
import org.eclipse.ecf.presence.chatroom.ChatRoomMessageEvent;
import org.eclipse.ecf.presence.chatroom.IChatRoomAdminListener;
import org.eclipse.ecf.presence.chatroom.IChatRoomMessage;
import org.eclipse.ecf.presence.im.ChatMessage;
import org.eclipse.ecf.presence.im.ChatMessageEvent;
import org.eclipse.ecf.presence.im.IChatMessage;

public abstract class IRCAbstractContainer
extends AbstractContainer {
    protected static final String ROOT_ROOMNAME = "/";
    protected static final String COMMAND_PREFIX = "/";
    protected static final String COMMAND_DELIM = " ";
    protected static final String JOIN_COMMAND = "JOIN";
    protected static final String LIST_COMMAND = "LIST";
    protected static final String PART_COMMAND = "PART";
    protected static final String NICK_COMMAND = "NICK";
    protected static final String MSG_COMMAND = "MSG";
    protected static final String NOTICE_COMMAND = "NOTICE";
    protected static final String WHOIS_COMMAND = "WHOIS";
    protected static final String QUIT_COMMAND = "QUIT";
    protected static final String AWAY_COMMAND = "AWAY";
    protected static final String TOPIC_COMMAND = "TOPIC";
    protected static final String INVITE_COMMAND = "INVITE";
    protected static final String OPERATOR_PREFIX = "@";
    protected ID localID = null;
    protected ID targetID = null;
    protected List msgListeners = new ArrayList();
    protected ID unknownID = null;
    private ArrayList subjectListeners = new ArrayList();

    protected void trace(String msg) {
        Trace.trace((String)"org.eclipse.ecf.provider.irc", (String)msg);
    }

    protected void traceStack(Throwable t, String msg) {
        Trace.catching((String)"org.eclipse.ecf.provider.irc", (String)"org.eclipse.ecf.provider.irc/debug/exceptions/catching", ((Object)((Object)this)).getClass(), (String)msg, (Throwable)t);
    }

    public void fireChatMessageEvent(ID sender, String msg) {
        Iterator i = this.msgListeners.iterator();
        while (i.hasNext()) {
            IIMMessageListener l = (IIMMessageListener)i.next();
            l.handleMessageEvent((IIMMessageEvent)new ChatMessageEvent(sender, (IChatMessage)new ChatMessage(sender, msg)));
        }
    }

    public void fireChatRoomMessageEvent(ID sender, String msg) {
        Iterator i = this.msgListeners.iterator();
        while (i.hasNext()) {
            IIMMessageListener l = (IIMMessageListener)i.next();
            l.handleMessageEvent((IIMMessageEvent)new ChatRoomMessageEvent(sender, (IChatRoomMessage)new ChatRoomMessage(sender, this.targetID, msg)));
        }
    }

    public ID getID() {
        return this.localID;
    }

    public ID getConnectedID() {
        return this.targetID;
    }

    protected String[] parseUsers(String usergroup) {
        if (usergroup == null) {
            return null;
        }
        StringTokenizer t = new StringTokenizer(usergroup, COMMAND_DELIM);
        int tok = t.countTokens();
        String[] res = new String[tok];
        int i = 0;
        while (i < tok) {
            res[i] = t.nextToken();
            ++i;
        }
        return res;
    }

    protected String[] parseUserNames(String list) {
        StringTokenizer st = new StringTokenizer(list, COMMAND_DELIM);
        int tokens = st.countTokens();
        String[] res = new String[tokens];
        int i = 0;
        while (i < tokens) {
            res[i] = st.nextToken();
            ++i;
        }
        return res;
    }

    protected String concat(String[] args, int start, String suffix) {
        StringBuffer result = new StringBuffer();
        int i = start;
        while (i < args.length) {
            result.append(args[i]).append(' ');
            ++i;
        }
        result.append(suffix);
        return result.toString();
    }

    protected ID createIDFromString(String str) {
        if (str == null) {
            return this.unknownID;
        }
        try {
            return IDFactory.getDefault().createStringID(str);
        }
        catch (IDCreateException e) {
            Activator.log("ID creation exception in IRCContainer.getIDForString()", e);
            return this.unknownID;
        }
    }

    protected String trimOperator(String user) {
        if (user != null && user.startsWith(OPERATOR_PREFIX)) {
            return user.substring(OPERATOR_PREFIX.length());
        }
        return user;
    }

    public abstract void disconnect();

    protected String[] parseCommandTokens(String message) {
        StringTokenizer st = new StringTokenizer(message, COMMAND_DELIM);
        int countTokens = st.countTokens();
        String[] toks = new String[countTokens];
        int i = 0;
        while (i < countTokens) {
            toks[i] = st.nextToken();
            ++i;
        }
        return toks;
    }

    protected boolean isCommand(String message) {
        return message != null && message.startsWith("/");
    }

    public void addMessageListener(IIMMessageListener l) {
        this.msgListeners.add(l);
    }

    public void removeMessageListener(IIMMessageListener l) {
        this.msgListeners.remove(l);
    }

    public void addChatRoomAdminListener(IChatRoomAdminListener subjectListener) {
        this.subjectListeners.add(subjectListener);
    }

    public void removeChatRoomAdminListener(IChatRoomAdminListener subjectListener) {
        this.subjectListeners.remove(subjectListener);
    }

    public void fireSubjectListeners(ID fromID, String newSubject) {
        Iterator i = this.subjectListeners.iterator();
        while (i.hasNext()) {
            IChatRoomAdminListener l = (IChatRoomAdminListener)i.next();
            l.handleSubjectChange(fromID, newSubject);
        }
    }
}

