/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.r_osgi.impl;

import ch.ethz.iks.r_osgi.Remoting;
import ch.ethz.iks.r_osgi.URI;
import ch.ethz.iks.r_osgi.channels.ChannelEndpoint;
import ch.ethz.iks.r_osgi.channels.NetworkChannel;
import ch.ethz.iks.r_osgi.channels.NetworkChannelFactory;
import ch.ethz.iks.r_osgi.impl.RemoteOSGiActivator;
import ch.ethz.iks.r_osgi.impl.RemoteOSGiServiceImpl;
import ch.ethz.iks.r_osgi.messages.RemoteOSGiMessage;
import ch.ethz.iks.util.SmartObjectInputStream;
import ch.ethz.iks.util.SmartObjectOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.ecf.core.util.OSGIObjectInputStream;
import org.eclipse.ecf.core.util.OSGIObjectOutputStream;

final class TCPChannelFactory
implements NetworkChannelFactory {
    static final String PROTOCOL = "r-osgi";
    Remoting remoting;
    private TCPAcceptorThread thread;
    protected int listeningPort;
    private static final String OSGI_SERIALIZATION = "osgi.basic";
    private static final String SERIALIZATION_DEFAULT = System.getProperty("ch.ethz.iks.r_osgi.remote.serialization", "osgi.basic");

    TCPChannelFactory() {
    }

    @Override
    public NetworkChannel getConnection(ChannelEndpoint endpoint, URI endpointURI) throws IOException {
        return new TCPChannel(endpoint, endpointURI);
    }

    @Override
    public void activate(Remoting r) throws IOException {
        this.remoting = r;
        this.thread = new TCPAcceptorThread();
        this.thread.start();
    }

    @Override
    public void deactivate(Remoting r) throws IOException {
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.remoting = null;
    }

    @Override
    public int getListeningPort(String protocol) {
        return this.listeningPort;
    }

    protected final class TCPAcceptorThread
    extends Thread {
        private ServerSocket socket;

        TCPAcceptorThread() throws IOException {
            this.setName("TCPChannel:TCPAcceptorThread");
            this.setDaemon(true);
            int e = 0;
            while (true) {
                try {
                    TCPChannelFactory.this.listeningPort = RemoteOSGiServiceImpl.R_OSGI_PORT + e;
                    this.socket = new ServerSocket(TCPChannelFactory.this.listeningPort);
                    if (e != 0) {
                        System.err.println("WARNING: Port " + RemoteOSGiServiceImpl.R_OSGI_PORT + " already in use. This instance of R-OSGi is running on port " + TCPChannelFactory.this.listeningPort);
                    }
                    RemoteOSGiServiceImpl.R_OSGI_PORT = TCPChannelFactory.this.listeningPort;
                    return;
                }
                catch (BindException b) {
                    ++e;
                    continue;
                }
                break;
            }
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    TCPChannelFactory.this.remoting.createEndpoint(new TCPChannel(this.socket.accept()));
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    private static final class TCPChannel
    implements NetworkChannel {
        Socket socket;
        private final URI remoteEndpointAddress;
        private URI localEndpointAddress;
        protected ObjectInputStream input;
        protected ObjectOutputStream output;
        ChannelEndpoint endpoint;
        boolean connected = true;

        TCPChannel(ChannelEndpoint endpoint, URI endpointAddress) throws IOException {
            int port = endpointAddress.getPort();
            if (port == -1) {
                port = 9278;
            }
            this.endpoint = endpoint;
            this.remoteEndpointAddress = endpointAddress;
            this.open(new Socket(endpointAddress.getHost(), port));
            new ReceiverThread().start();
        }

        public TCPChannel(Socket socket) throws IOException {
            this.remoteEndpointAddress = URI.create(this.getProtocol() + "://" + socket.getInetAddress().getHostName() + ":" + socket.getPort());
            this.open(socket);
        }

        @Override
        public void bind(ChannelEndpoint e) {
            this.endpoint = e;
            new ReceiverThread().start();
        }

        private void open(Socket s) throws IOException {
            this.socket = s;
            this.localEndpointAddress = URI.create(this.getProtocol() + "://" + this.socket.getLocalAddress().getHostName() + ":" + this.socket.getLocalPort());
            try {
                this.socket.setKeepAlive(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.socket.setTcpNoDelay(true);
            BufferedOutputStream bos = new BufferedOutputStream(this.socket.getOutputStream());
            this.output = SERIALIZATION_DEFAULT.equals(TCPChannelFactory.OSGI_SERIALIZATION) ? new OSGIObjectOutputStream((OutputStream)bos, true) : new SmartObjectOutputStream(bos);
            this.output.flush();
            BufferedInputStream bins = new BufferedInputStream(this.socket.getInputStream());
            this.input = SERIALIZATION_DEFAULT.equals(TCPChannelFactory.OSGI_SERIALIZATION) ? new OSGIObjectInputStream(RemoteOSGiActivator.getActivator().getContext().getBundle(), (InputStream)bins) : new SmartObjectInputStream(bins);
        }

        public String toString() {
            return "TCPChannel (" + String.valueOf(this.getRemoteAddress()) + ")";
        }

        @Override
        public void close() throws IOException {
            this.socket.close();
            this.connected = false;
        }

        @Override
        public String getProtocol() {
            return TCPChannelFactory.PROTOCOL;
        }

        @Override
        public URI getRemoteAddress() {
            return this.remoteEndpointAddress;
        }

        @Override
        public URI getLocalAddress() {
            return this.localEndpointAddress;
        }

        @Override
        public void sendMessage(RemoteOSGiMessage message) throws IOException {
            if (RemoteOSGiServiceImpl.MSG_DEBUG) {
                RemoteOSGiServiceImpl.log.log(4, "{TCP Channel} sending " + String.valueOf(message));
            }
            message.send(this.output);
        }

        class ReceiverThread
        extends Thread {
            ReceiverThread() {
                this.setName("TCPChannel:ReceiverThread:" + String.valueOf(TCPChannel.this.getRemoteAddress()));
                this.setDaemon(true);
            }

            @Override
            public void run() {
                while (TCPChannel.this.connected) {
                    try {
                        RemoteOSGiMessage msg = RemoteOSGiMessage.parse(TCPChannel.this.input);
                        if (RemoteOSGiServiceImpl.MSG_DEBUG) {
                            RemoteOSGiServiceImpl.log.log(4, "{TCP Channel} received " + String.valueOf(msg));
                        }
                        TCPChannel.this.endpoint.receivedMessage(msg);
                    }
                    catch (IOException ioe) {
                        TCPChannel.this.connected = false;
                        try {
                            TCPChannel.this.socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        TCPChannel.this.endpoint.receivedMessage(null);
                        return;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }
    }
}

