/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;

public class Presence
extends Packet {
    private Type type = Type.available;
    private String status = null;
    private int priority = Integer.MIN_VALUE;
    private Mode mode = null;
    private String language;

    public Presence(Type type) {
        this.setType(type);
    }

    public Presence(Type type, String status, int priority, Mode mode) {
        this.setType(type);
        this.setStatus(status);
        this.setPriority(priority);
        this.setMode(mode);
    }

    public boolean isAvailable() {
        return this.type == Type.available;
    }

    public boolean isAway() {
        return this.type == Type.available && (this.mode == Mode.away || this.mode == Mode.xa || this.mode == Mode.dnd);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        if (type == null) {
            throw new NullPointerException("Type cannot be null");
        }
        this.type = type;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        if (priority < -128 || priority > 128) {
            throw new IllegalArgumentException("Priority value " + priority + " is not valid. Valid range is -128 through 128.");
        }
        this.priority = priority;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String toXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<presence");
        if (this.getXmlns() != null) {
            buf.append(" xmlns=\"").append(this.getXmlns()).append("\"");
        }
        if (this.language != null) {
            buf.append(" xml:lang=\"").append(this.getLanguage()).append("\"");
        }
        if (this.getPacketID() != null) {
            buf.append(" id=\"").append(this.getPacketID()).append("\"");
        }
        if (this.getTo() != null) {
            buf.append(" to=\"").append(StringUtils.escapeForXML(this.getTo())).append("\"");
        }
        if (this.getFrom() != null) {
            buf.append(" from=\"").append(StringUtils.escapeForXML(this.getFrom())).append("\"");
        }
        if (this.type != Type.available) {
            buf.append(" type=\"").append((Object)this.type).append("\"");
        }
        buf.append(">");
        if (this.status != null) {
            buf.append("<status>").append(StringUtils.escapeForXML(this.status)).append("</status>");
        }
        if (this.priority != Integer.MIN_VALUE) {
            buf.append("<priority>").append(this.priority).append("</priority>");
        }
        if (this.mode != null && this.mode != Mode.available) {
            buf.append("<show>").append((Object)this.mode).append("</show>");
        }
        buf.append(this.getExtensionsXML());
        XMPPError error = this.getError();
        if (error != null) {
            buf.append(error.toXML());
        }
        buf.append("</presence>");
        return buf.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append((Object)this.type);
        if (this.mode != null) {
            buf.append(": ").append((Object)this.mode);
        }
        if (this.getStatus() != null) {
            buf.append(" (").append(this.getStatus()).append(")");
        }
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        chat,
        available,
        away,
        xa,
        dnd;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        available,
        unavailable,
        subscribe,
        subscribed,
        unsubscribe,
        unsubscribed,
        error;

    }
}

