/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.r_osgi.identity;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.provider.r_osgi.identity.R_OSGiNamespace;
import org.eclipse.ecf.provider.r_osgi.identity.R_OSGiWSID;

public class R_OSGiWSSNamespace
extends R_OSGiNamespace {
    private static final long serialVersionUID = 8705667690964282332L;
    public static final String NAME_WSS = "ecf.namespace.r_osgi.wss";
    private static final String NAMESPACE_SCHEME_WSS = "r-osgi.wss";
    private static Namespace instance;

    public static Namespace getDefault() {
        if (instance == null) {
            new R_OSGiWSSNamespace();
        }
        return instance;
    }

    public R_OSGiWSSNamespace() {
        super(NAME_WSS, "R-OSGi Secure Websockets Namespace");
        instance = this;
    }

    @Override
    public ID createInstance(Object[] parameters) throws IDCreateException {
        try {
            String uriString = (String)parameters[0];
            if (uriString == null) {
                throw new NullPointerException("URI parameter is null");
            }
            if (!uriString.startsWith(NAMESPACE_SCHEME_WSS) && !uriString.startsWith("https")) {
                throw new URISyntaxException(uriString, "URI must have r-osgi.wss as protocol");
            }
            URI uri = new URI(uriString);
            return new R_OSGiWSID(true, uri.getHost(), uri.getPort());
        }
        catch (Exception e) {
            throw new IDCreateException(String.valueOf(this.getName()) + " createInstance()", (Throwable)e);
        }
    }

    @Override
    public String getScheme() {
        return NAMESPACE_SCHEME_WSS;
    }

    @Override
    public String[] getSupportedSchemes() {
        return new String[]{NAMESPACE_SCHEME_WSS};
    }
}

