/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.r_osgi.messages;

import ch.ethz.iks.r_osgi.messages.RemoteOSGiMessage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class StreamRequestMessage
extends RemoteOSGiMessage {
    public static final byte READ = 0;
    public static final byte READ_ARRAY = 1;
    public static final byte WRITE = 2;
    public static final byte WRITE_ARRAY = 3;
    private short streamID;
    private byte op;
    private int lenOrVal;
    private byte[] b;

    public StreamRequestMessage() {
        super((short)10);
    }

    StreamRequestMessage(ObjectInputStream input) throws IOException {
        super((short)10);
        this.streamID = input.readShort();
        this.op = input.readByte();
        switch (this.op) {
            case 0: {
                this.lenOrVal = 1;
                this.b = null;
                break;
            }
            case 1: 
            case 2: {
                this.lenOrVal = input.readInt();
                this.b = null;
                break;
            }
            case 3: {
                int read;
                this.lenOrVal = input.readInt();
                this.b = new byte[this.lenOrVal];
                int rem = this.lenOrVal;
                while (rem > 0 && (read = input.read(this.b, this.lenOrVal - rem, rem)) > 0) {
                    rem -= read;
                }
                if (rem <= 0) break;
                throw new IOException("Premature end of input stream.");
            }
            default: {
                throw new IllegalArgumentException("op code not within valid range: " + this.op);
            }
        }
    }

    @Override
    public void writeBody(ObjectOutputStream out) throws IOException {
        out.writeShort(this.streamID);
        out.writeByte(this.op);
        if (this.op != 0) {
            out.writeInt(this.lenOrVal);
            if (this.op == 3) {
                out.write(this.b);
            }
        }
    }

    public short getStreamID() {
        return this.streamID;
    }

    public void setStreamID(short streamID) {
        this.streamID = streamID;
    }

    public byte getOp() {
        return this.op;
    }

    public void setOp(byte op) {
        this.op = op;
    }

    public int getLenOrVal() {
        return this.lenOrVal;
    }

    public void setLenOrVal(int lenOrVal) {
        this.lenOrVal = lenOrVal;
    }

    public byte[] getData() {
        return this.b;
    }

    public void setData(byte[] b) {
        this.b = b;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[STREAM_REQUEST] - XID: ");
        buffer.append(this.xid);
        buffer.append(", streamID: ");
        buffer.append(this.streamID);
        buffer.append(", op: ");
        buffer.append(this.op);
        buffer.append(", len: ");
        buffer.append(this.lenOrVal);
        return buffer.toString();
    }
}

