/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.employee.domain;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.Time;
import java.util.Calendar;
import java.util.Vector;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.EmploymentPeriod;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.models.employee.interfaces.Project;

public class Employee
implements org.eclipse.persistence.testing.models.employee.interfaces.Employee,
Serializable,
ChangeTracker {
    public BigDecimal id;
    public String firstName = "";
    public String lastName = "";
    public String gender;
    public BigDecimal addressId;
    public EmploymentPeriod period;
    public ValueHolderInterface address = new ValueHolder();
    public ValueHolderInterface manager = new ValueHolder();
    public ValueHolderInterface managedEmployees = new ValueHolder(new Vector());
    public ValueHolderInterface phoneNumbers;
    public ValueHolderInterface projects = new ValueHolder(new Vector());
    public ValueHolderInterface responsibilitiesList = new ValueHolder(new Vector());
    public Time[] normalHours;
    public int salary;
    public Vector children;
    public static int getIdCallCount = 0;
    public PropertyChangeListener listener;

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this.listener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener listener) {
        this.listener = listener;
    }

    public void propertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.listener != null && oldValue != newValue) {
            this.listener.propertyChange(new PropertyChangeEvent(this, propertyName, oldValue, newValue));
        }
    }

    public void collectionChange(String propertyName, Object oldValue, Object newValue, int changeType, boolean isChangeApplied) {
        if (this.listener != null) {
            this.listener.propertyChange((PropertyChangeEvent)new CollectionChangeEvent((Object)this, propertyName, oldValue, newValue, changeType, isChangeApplied));
        }
    }

    public Employee() {
        this.phoneNumbers = new ValueHolder(new Vector());
        this.normalHours = new Time[2];
        Calendar startTime = Calendar.getInstance();
        startTime.set(14, 0);
        startTime.set(1970, 0, 1, 9, 0, 0);
        this.normalHours[0] = new Time(startTime.getTime().getTime());
        Calendar endTime = Calendar.getInstance();
        endTime.set(14, 0);
        endTime.set(1970, 0, 1, 17, 0, 0);
        this.normalHours[1] = new Time(endTime.getTime().getTime());
        this.children = new Vector();
    }

    @Override
    public void addManagedEmployee(org.eclipse.persistence.testing.models.employee.interfaces.Employee employee) {
        if (this.getManagedEmployees().add(employee)) {
            this.collectionChange("managedEmployees", this.managedEmployees, employee, 0, true);
            employee.setManager(this);
        }
    }

    @Override
    public void addPhoneNumber(PhoneNumber phoneNumber) {
        if (this.getPhoneNumbers().add(phoneNumber)) {
            this.collectionChange("phoneNumbers", this.phoneNumbers, phoneNumber, 0, true);
            phoneNumber.setOwner(this);
        }
    }

    @Override
    public void addProject(Project project) {
        if (this.getProjects().add(project)) {
            this.collectionChange("projects", this.projects, project, 0, true);
        }
    }

    @Override
    public void addResponsibility(String responsibility) {
        if (this.getResponsibilitiesList().add(responsibility)) {
            this.collectionChange("responsibilitiesList", this.responsibilitiesList, responsibility, 0, true);
        }
    }

    public Time[] buildNormalHours(Record row, Session session) {
        Time[] hours = new Time[2];
        try {
            hours[0] = (Time)session.getDatasourcePlatform().convertObject(row.get((Object)"START_TIME"), Time.class);
            hours[1] = (Time)session.getDatasourcePlatform().convertObject(row.get((Object)"END_TIME"), Time.class);
        }
        catch (Throwable in904) {
            hours[0] = (Time)ConversionManager.getDefaultManager().convertObject(row.get((Object)"START_TIME"), Time.class);
            hours[1] = (Time)ConversionManager.getDefaultManager().convertObject(row.get((Object)"END_TIME"), Time.class);
        }
        return hours;
    }

    @Override
    public Address getAddress() {
        return (Address)this.address.getValue();
    }

    @Override
    public Time getEndTime() {
        return this.getNormalHours()[1];
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getGender() {
        return this.gender;
    }

    public static int getGetIdCallCount() {
        return getIdCallCount;
    }

    @Override
    public BigDecimal getId() {
        ++getIdCallCount;
        return this.id;
    }

    public BigDecimal getAddressId() {
        if (this.addressId == null && this.getAddress() != null) {
            this.addressId = this.getAddress().getId();
        }
        return this.addressId;
    }

    public Vector getChildren() {
        return this.children;
    }

    public void setAddressId(BigDecimal newAddressId) {
        this.addressId = newAddressId;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public Vector getManagedEmployees() {
        return (Vector)this.managedEmployees.getValue();
    }

    @Override
    public org.eclipse.persistence.testing.models.employee.interfaces.Employee getManager() {
        return (Employee)this.manager.getValue();
    }

    @Override
    public Time[] getNormalHours() {
        return this.normalHours;
    }

    @Override
    public EmploymentPeriod getPeriod() {
        return this.period;
    }

    @Override
    public Vector getPhoneNumbers() {
        return (Vector)this.phoneNumbers.getValue();
    }

    @Override
    public Vector getProjects() {
        return (Vector)this.projects.getValue();
    }

    @Override
    public Vector getResponsibilitiesList() {
        return (Vector)this.responsibilitiesList.getValue();
    }

    @Override
    public int getSalary() {
        return this.salary;
    }

    @Override
    public Time getStartTime() {
        return this.getNormalHours()[0];
    }

    @Override
    public void removeManagedEmployee(org.eclipse.persistence.testing.models.employee.interfaces.Employee employee) {
        if (this.getManagedEmployees().removeElement(employee)) {
            this.collectionChange("managedEmployees", this.managedEmployees, employee, 1, true);
            employee.setManager(null);
        }
    }

    @Override
    public void removePhoneNumber(PhoneNumber phoneNumber) {
        if (this.getPhoneNumbers().removeElement(phoneNumber)) {
            this.collectionChange("phoneNumbers", this.phoneNumbers, phoneNumber, 1, true);
        }
    }

    @Override
    public void removeProject(Project project) {
        if (this.getProjects().removeElement(project)) {
            this.collectionChange("projects", this.projects, project, 1, true);
        }
    }

    @Override
    public void removeResponsibility(String responsibility) {
        if (this.getResponsibilitiesList().removeElement(responsibility)) {
            this.collectionChange("responsibilitiesList", this.responsibilitiesList, responsibility, 1, true);
        }
    }

    @Override
    public void setAddress(Address address) {
        this.propertyChange("address", this.address.getValue(), address);
        this.address.setValue((Object)address);
        if (address == null) {
            this.setAddressId(null);
        } else {
            this.setAddressId(address.getId());
        }
    }

    public void setChildren(Vector children) {
        this.children = children;
    }

    @Override
    public void setEndTime(Time endTime) {
        Time[] oldHours = new Time[]{this.getNormalHours()[0], this.getNormalHours()[1]};
        this.getNormalHours()[1] = endTime;
        this.propertyChange("normalHours", oldHours, this.normalHours);
    }

    @Override
    public void setFemale() {
        this.propertyChange("gender", this.gender, "Female");
        this.setGender("Female");
    }

    @Override
    public void setFirstName(String firstName) {
        this.propertyChange("firstName", this.getFirstName(), firstName);
        this.firstName = firstName;
    }

    @Override
    public void setGender(String gender) {
        this.propertyChange("gender", this.gender, gender);
        this.gender = gender;
    }

    public static void setGetIdCallCount(int value) {
        getIdCallCount = value;
    }

    public void setId(BigDecimal id) {
        this.propertyChange("id", this.id, id);
        this.id = id;
    }

    @Override
    public void setLastName(String lastName) {
        this.propertyChange("lastName", this.lastName, lastName);
        this.lastName = lastName;
    }

    @Override
    public void setMale() {
        this.propertyChange("gender", this.gender, "Male");
        this.setGender("Male");
    }

    @Override
    public void setManagedEmployees(Vector managedEmployees) {
        this.propertyChange("managedEmployees", this.managedEmployees.getValue(), managedEmployees);
        this.managedEmployees.setValue((Object)managedEmployees);
    }

    @Override
    public void setManager(org.eclipse.persistence.testing.models.employee.interfaces.Employee manager) {
        this.propertyChange("manager", this.manager.getValue(), manager);
        this.manager.setValue((Object)manager);
    }

    @Override
    public void setNormalHours(Time[] normalHours) {
        Time[] oldHours = this.normalHours;
        this.normalHours = normalHours;
        this.propertyChange("normalHours", oldHours, normalHours);
    }

    @Override
    public void setPeriod(EmploymentPeriod period) {
        this.propertyChange("period", this.period, period);
        this.period = period;
    }

    @Override
    public void setPhoneNumbers(Vector phoneNumbers) {
        this.propertyChange("phoneNumbers", this.phoneNumbers.getValue(), phoneNumbers);
        this.phoneNumbers.setValue((Object)phoneNumbers);
    }

    @Override
    public void setProjects(Vector projects) {
        this.propertyChange("projects", this.projects.getValue(), projects);
        this.projects.setValue((Object)projects);
    }

    @Override
    public void setResponsibilitiesList(Vector responsibilitiesList) {
        this.propertyChange("responsibilitiesList", this.responsibilitiesList.getValue(), responsibilitiesList);
        this.responsibilitiesList.setValue((Object)responsibilitiesList);
    }

    @Override
    public void setSalary(int salary) {
        this.propertyChange("salary", this.salary, salary);
        this.salary = salary;
    }

    @Override
    public void setStartTime(Time startTime) {
        Time[] oldHours = new Time[]{this.getNormalHours()[0], this.getNormalHours()[1]};
        this.getNormalHours()[0] = startTime;
        this.propertyChange("normalHours", oldHours, this.normalHours);
    }

    @Override
    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write("Employee: ");
        writer.write(this.getFirstName());
        writer.write(" ");
        writer.write(this.getLastName());
        return writer.toString();
    }
}

