/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.collections.map;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.indirection.IndirectMap;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.collections.map.DEOTMMapValue;
import org.eclipse.persistence.testing.models.collections.map.DirectEntity1MMapHolder;

public class TestReadDirectEntity1MMapMapping
extends TestCase {
    protected DirectEntity1MMapHolder initialHolder = null;
    protected List holders = null;
    protected int fetchJoinRelationship = 0;
    protected int oldFetchJoinValue = 0;
    protected OneToManyMapping mapping = null;
    protected Expression holderExp;

    public TestReadDirectEntity1MMapMapping() {
    }

    public TestReadDirectEntity1MMapMapping(int fetchJoin) {
        this();
        this.fetchJoinRelationship = fetchJoin;
        this.setName("TestReadDirectEntity1MMapMapping fetchJoin = " + fetchJoin);
    }

    public void setup() {
        this.mapping = (OneToManyMapping)this.getSession().getProject().getDescriptor(DirectEntity1MMapHolder.class).getMappingForAttributeName("directToEntityMap");
        this.oldFetchJoinValue = this.mapping.getJoinFetch();
        this.mapping.setJoinFetch(this.fetchJoinRelationship);
        this.getSession().getProject().getDescriptor(DirectEntity1MMapHolder.class).reInitializeJoinedAttributes();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.initialHolder = new DirectEntity1MMapHolder();
        DEOTMMapValue value = new DEOTMMapValue();
        value.setId(1);
        value.getHolder().setValue((Object)this.initialHolder);
        this.initialHolder.addDirectToEntityMapItem(11, value);
        DEOTMMapValue value2 = new DEOTMMapValue();
        value2.setId(2);
        value2.getHolder().setValue((Object)this.initialHolder);
        this.initialHolder.addDirectToEntityMapItem(22, value2);
        uow.registerObject((Object)this.initialHolder);
        uow.registerObject((Object)value);
        uow.registerObject((Object)value2);
        uow.commit();
        this.holderExp = new ExpressionBuilder().get("id").equal(this.initialHolder.getId());
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        this.holders = this.getSession().readAllObjects(DirectEntity1MMapHolder.class, this.holderExp);
    }

    public void verify() {
        if (this.holders == null || this.holders.size() != 1) {
            throw new TestErrorException("Incorrect number of MapHolders was read.");
        }
        DirectEntity1MMapHolder holder = (DirectEntity1MMapHolder)this.holders.get(0);
        if (!((IndirectMap)holder.getDirectToEntityMap()).getValueHolder().isInstantiated() && this.fetchJoinRelationship > 0) {
            throw new TestErrorException("Relationship was not properly joined.");
        }
        if (holder.getDirectToEntityMap().size() != 2) {
            throw new TestErrorException("Incorrect Number of MapEntityValues was read.");
        }
        DEOTMMapValue value = (DEOTMMapValue)holder.getDirectToEntityMap().get(11);
        if (value.getId() != 1) {
            throw new TestErrorException("Incorrect MapEntityValues was read.");
        }
    }

    public void reset() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        for (DirectEntity1MMapHolder holder : this.holders) {
            Iterator j = holder.getDirectToEntityMap().keySet().iterator();
            while (j.hasNext()) {
                uow.deleteObject(holder.getDirectToEntityMap().get(j.next()));
            }
        }
        uow.deleteAllObjects((Collection)this.holders);
        uow.commit();
        if (!this.verifyDelete(this.holders.get(0))) {
            throw new TestErrorException("Delete was unsuccessful.");
        }
        this.mapping.setJoinFetch(this.oldFetchJoinValue);
    }
}

