/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.simultaneous;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sequencing.DefaultSequence;
import org.eclipse.persistence.sequencing.NativeSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;
import org.eclipse.persistence.testing.models.interfaces.InterfaceHashtableProject;
import org.eclipse.persistence.testing.tests.simultaneous.MultithreadTestCase;

public class AddDescriptorsMultithreadedTest
extends MultithreadTestCase {
    protected static boolean allTestsShouldStop;

    protected AddDescriptorsMultithreadedTest() {
        this.setDescription("Runs provided tests concurently with adding descriptors.");
    }

    @Override
    protected void setup() {
        super.setup();
        allTestsShouldStop = false;
    }

    protected static AddDescriptorsMultithreadedTest createMultithreadedTest(int nAddDescriptorsTests, long timeToSleepBetweenAddingDescriptors, String testName, int nTests, long timeToStopTests) {
        int i;
        AddDescriptorsMultithreadedTest test = new AddDescriptorsMultithreadedTest();
        Vector<TestCase> tests = new Vector<TestCase>(nAddDescriptorsTests + nTests);
        InterfaceHashtableProject project = new InterfaceHashtableProject();
        for (i = 0; i < nAddDescriptorsTests; ++i) {
            tests.add(new AddDescriptorsTest(i, nAddDescriptorsTests, timeToSleepBetweenAddingDescriptors, project));
        }
        for (i = 0; i < nTests; ++i) {
            if (testName.equals("SequencePreallocationTest")) {
                tests.add(new SequencePreallocationTest(i));
                continue;
            }
            if (testName.equals("InsertTest")) {
                tests.add(new InsertTest(i, nTests));
                continue;
            }
            throw new TestProblemException("Unknown test name: " + testName);
        }
        if (nAddDescriptorsTests == 0 && timeToStopTests > 0L) {
            tests.add(new Timer(timeToStopTests));
        }
        test.setTests(tests);
        test.generateTestName();
        return test;
    }

    void generateTestName() {
        ArrayList<String> testNames = new ArrayList<String>();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < this.test.length; ++i) {
            String testName = this.test[i].getName();
            if (testNames.contains(testName)) {
                int count = (Integer)map.get(testName);
                map.put(testName, count + 1);
                continue;
            }
            testNames.add(testName);
            map.put(testName, 1);
        }
        Object name = "";
        for (int k = 0; k < testNames.size(); ++k) {
            String testName = (String)testNames.get(k);
            if (k > 0) {
                name = (String)name + ";_";
            }
            name = (String)name + testName;
            int count = (Integer)map.get(testName);
            if (count <= 1) continue;
            name = (String)name + "_" + map.get(testName) + "threads";
        }
        this.setName((String)name);
    }

    public static class InsertTest
    extends TestCase {
        int testNumber;
        int numberOfTests;
        static int numberOfCompletedTests = 0;
        static Object lock = true;

        public InsertTest(int testNumber, int numberOfTests) {
            this.testNumber = testNumber;
            this.numberOfTests = numberOfTests;
            this.setName("InsertTest");
        }

        public void test() {
            if (this.getAbstractSession().getParent().getPlatform().isSQLServer()) {
                throw new TestWarningException("Not supported on MS SQL Server");
            }
            int index3 = this.testNumber % 3;
            String strTestNumber = Integer.toString(this.testNumber);
            while (!allTestsShouldStop) {
                ChangeTracker obj;
                UnitOfWork uow = this.getSession().acquireUnitOfWork();
                if (index3 == 0) {
                    Address address = new Address();
                    address.setCity(strTestNumber);
                    address.setCountry("InsertTest");
                    obj = address;
                    index3 = 1;
                } else if (index3 == 1) {
                    Employee emp = new Employee();
                    emp.setFirstName(strTestNumber);
                    emp.setLastName("InsertTest");
                    obj = emp;
                    index3 = 2;
                } else {
                    SmallProject project = new SmallProject();
                    project.setName(strTestNumber);
                    project.setDescription("InsertTest");
                    obj = project;
                    index3 = 0;
                }
                uow.registerObject((Object)obj);
                uow.commit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            Object object = lock;
            synchronized (object) {
                if (++numberOfCompletedTests == this.numberOfTests) {
                    Session session = this.getSession();
                    if (session.getPlatform().isSymfoware()) {
                        session.executeNonSelectingCall((Call)new SQLCall("DELETE FROM ADDRESS WHERE (COUNTRY = 'InsertTest')"));
                        session.executeNonSelectingCall((Call)new SQLCall("DELETE FROM SALARY WHERE EXISTS(SELECT t0.EMP_ID FROM EMPLOYEE t0 WHERE (t0.L_NAME = 'InsertTest') AND (t0.EMP_ID = SALARY.EMP_ID))"));
                        session.executeNonSelectingCall((Call)new SQLCall("DELETE FROM PROJ_EMP WHERE EXISTS(SELECT t0.EMP_ID FROM EMPLOYEE t0 WHERE (t0.L_NAME = 'InsertTest') AND (t0.EMP_ID = PROJ_EMP.EMP_ID))"));
                        session.executeNonSelectingCall((Call)new SQLCall("DELETE FROM RESPONS WHERE EXISTS(SELECT t0.EMP_ID FROM EMPLOYEE t0 WHERE (t0.L_NAME = 'InsertTest') AND (t0.EMP_ID = RESPONS.EMP_ID))"));
                        session.executeNonSelectingCall((Call)new SQLCall("DELETE FROM PHONE WHERE EXISTS(SELECT t0.EMP_ID FROM EMPLOYEE t0 WHERE (t0.L_NAME = 'InsertTest') AND (t0.EMP_ID = PHONE.EMP_ID))"));
                        session.executeNonSelectingCall((Call)new SQLCall("DELETE FROM CHILD WHERE EXISTS(SELECT t0.EMP_ID FROM EMPLOYEE t0 WHERE (t0.L_NAME = 'InsertTest') AND (t0.EMP_ID = CHILD.PARENT_EMP_ID))"));
                        session.executeNonSelectingCall((Call)new SQLCall("DELETE FROM EMPLOYEE WHERE (L_NAME = 'InsertTest')"));
                        session.executeNonSelectingCall((Call)new SQLCall("DELETE FROM PROJECT WHERE (DESCRIP = 'InsertTest')"));
                    } else {
                        UnitOfWork uow = session.acquireUnitOfWork();
                        DeleteAllQuery deleteAddresses = new DeleteAllQuery(Address.class);
                        deleteAddresses.setSelectionCriteria(deleteAddresses.getExpressionBuilder().get("country").equal((Object)"InsertTest"));
                        uow.executeQuery((DatabaseQuery)deleteAddresses);
                        DeleteAllQuery deleteEmployees = new DeleteAllQuery(Employee.class);
                        deleteEmployees.setSelectionCriteria(deleteEmployees.getExpressionBuilder().get("lastName").equal((Object)"InsertTest"));
                        uow.executeQuery((DatabaseQuery)deleteEmployees);
                        DeleteAllQuery deleteProjects = new DeleteAllQuery(SmallProject.class);
                        deleteProjects.setSelectionCriteria(deleteProjects.getExpressionBuilder().get("description").equal((Object)"InsertTest"));
                        uow.executeQuery((DatabaseQuery)deleteProjects);
                        uow.commit();
                    }
                    numberOfCompletedTests = 0;
                }
            }
        }

        public static AddDescriptorsMultithreadedTest createMultithreadedTestWithAddDescriptors(int nAddDescriptorsTests, long timeToSleepBetweenAddingDescriptors, int nTests) {
            return AddDescriptorsMultithreadedTest.createMultithreadedTest(nAddDescriptorsTests, timeToSleepBetweenAddingDescriptors, "InsertTest", nTests, 0L);
        }

        public static AddDescriptorsMultithreadedTest createMultithreadedTest(int nTests, long timeToStopTests) {
            return AddDescriptorsMultithreadedTest.createMultithreadedTest(0, 0L, "InsertTest", nTests, timeToStopTests);
        }
    }

    public static class SequencePreallocationTest
    extends TestCase {
        int testNumber;

        public SequencePreallocationTest(int testNumber) {
            this.testNumber = testNumber;
            this.setName("SequencePreallocationTest");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void test() {
            if (this.getAbstractSession().getParent().getPlatform().isSQLServer()) {
                throw new TestWarningException("Not supported on MS SQL Server");
            }
            int index = 0;
            while (!allTestsShouldStop) {
                this.getAbstractSession().beginTransaction();
                try {
                    ChangeTracker obj;
                    UnitOfWork uow = this.getSession().acquireUnitOfWork();
                    if (index == 0) {
                        obj = new Address();
                        ++index;
                    } else if (index == 1) {
                        obj = new Employee();
                        ++index;
                    } else {
                        obj = new SmallProject();
                        index = 0;
                    }
                    uow.assignSequenceNumber((Object)obj);
                }
                finally {
                    this.getAbstractSession().rollbackTransaction();
                }
            }
        }

        public static AddDescriptorsMultithreadedTest createMultithreadedTestWithAddDescriptors(int nAddDescriptorsTests, long timeToSleepBetweenAddingDescriptors, int nTests) {
            return AddDescriptorsMultithreadedTest.createMultithreadedTest(nAddDescriptorsTests, timeToSleepBetweenAddingDescriptors, "SequencePreallocationTest", nTests, 0L);
        }

        public static AddDescriptorsMultithreadedTest createMultithreadedTest(int nTests, long timeToStopTests) {
            return AddDescriptorsMultithreadedTest.createMultithreadedTest(0, 0L, "SequencePreallocationTest", nTests, timeToStopTests);
        }
    }

    public static class AddDescriptorsTest
    extends TestCase {
        int testNumber;
        int numberOfTests;
        long timeToSleepBetweenAddingDescriptors;
        InterfaceHashtableProject project;
        static int numberOfCompletedTests = 0;
        static Object lock = true;

        public AddDescriptorsTest(int testNumber, int numberOfTests, long timeToSleepBetweenAddingDescriptors, InterfaceHashtableProject project) {
            this.testNumber = testNumber;
            this.numberOfTests = numberOfTests;
            this.timeToSleepBetweenAddingDescriptors = timeToSleepBetweenAddingDescriptors;
            this.project = project;
            Object name = "AddDescriptorsTest";
            if (timeToSleepBetweenAddingDescriptors > 0L) {
                name = (String)name + "(" + timeToSleepBetweenAddingDescriptors + ")";
            }
            this.setName((String)name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void test() {
            DatabaseSession dbSession = this.getSession().isDatabaseSession() ? (DatabaseSession)this.getSession() : (DatabaseSession)this.getAbstractSession().getParent();
            int nSize = this.project.getOrderedDescriptors().size();
            for (int k = this.testNumber; k < nSize; k += this.numberOfTests) {
                ClassDescriptor descriptor = (ClassDescriptor)this.project.getOrderedDescriptors().get(k);
                this.getAbstractSession().log(1, "misc", "AddDescriptorsTest adding descriptor for class = " + Helper.getShortClassName((Class)descriptor.getJavaClass()), new Object[0], null, false);
                DatabaseField sequenceNumberField = descriptor.getMappingForAttributeName("id").getField();
                descriptor.setSequenceNumberField(sequenceNumberField);
                String seqName = "SEQ_" + sequenceNumberField.getTableName();
                descriptor.setSequenceNumberName(seqName);
                int k3 = k % 3;
                if (k3 == 0) {
                    dbSession.addSequence((Sequence)new NativeSequence(seqName));
                } else if (k == 1) {
                    dbSession.addSequence((Sequence)new TableSequence(seqName));
                }
                if (k % 2 == 0) {
                    dbSession.addDescriptor(descriptor);
                } else {
                    ArrayList<ClassDescriptor> descriptors = new ArrayList<ClassDescriptor>();
                    descriptors.add(descriptor);
                    dbSession.addDescriptors(descriptors);
                }
                if (this.timeToSleepBetweenAddingDescriptors <= 0L) continue;
                try {
                    Thread.sleep(this.timeToSleepBetweenAddingDescriptors);
                    continue;
                }
                catch (InterruptedException ex) {
                    throw new TestProblemException("Thread.sleep(timeToSleepBetweenAddingDescriptors) failed ", (Throwable)ex);
                }
            }
            Object object = lock;
            synchronized (object) {
                if (++numberOfCompletedTests == this.numberOfTests) {
                    allTestsShouldStop = true;
                    numberOfCompletedTests = 0;
                }
            }
        }

        protected void verify() {
            DatabaseSession dbSession = this.getSession().isDatabaseSession() ? (DatabaseSession)this.getSession() : (DatabaseSession)this.getAbstractSession().getParent();
            int nSize = this.project.getOrderedDescriptors().size();
            for (int k = this.testNumber; k < nSize; k += this.numberOfTests) {
                ClassDescriptor descriptor = (ClassDescriptor)this.project.getOrderedDescriptors().get(k);
                if ((descriptor = dbSession.getDescriptor(descriptor.getJavaClass())) == null) {
                    throw new TestErrorException(descriptor + " is not found in the session");
                }
                DatabaseField sequenceNumberField = descriptor.getMappingForAttributeName("id").getField();
                String seqName = "SEQ_" + sequenceNumberField.getTableName();
                Sequence sequence = dbSession.getPlatform().getSequence(seqName);
                if (sequence == null) {
                    throw new TestErrorException("Not found sequence " + seqName + " defined for class " + descriptor.getAlias());
                }
                int k3 = k % 3;
                if (k3 == 0) {
                    if (sequence.isNative()) continue;
                    throw new TestErrorException(sequence + " defined for class " + descriptor.getAlias() + " is wrong. NativeSequence was expected");
                }
                if (k == 1) {
                    if (sequence.isTable()) continue;
                    throw new TestErrorException(sequence + " defined for class " + descriptor.getAlias() + " is wrong. TableSequence was expected");
                }
                if (sequence instanceof DefaultSequence) continue;
                throw new TestErrorException(sequence + " defined for class " + descriptor.getAlias() + " is wrong. DefaultSequence was expected");
            }
        }

        public static AddDescriptorsMultithreadedTest createMultithreadedTest(int nAddDescriptorsTests, long timeToSleepBetweenAddingDescriptors) {
            return AddDescriptorsMultithreadedTest.createMultithreadedTest(nAddDescriptorsTests, timeToSleepBetweenAddingDescriptors, "", 0, 0L);
        }
    }

    public static class Timer
    extends TestCase {
        long timeToStopTests;

        Timer(long timeToStopTests) {
            this.timeToStopTests = timeToStopTests;
            this.setName("Timer(" + timeToStopTests + ")");
        }

        public void test() {
            try {
                Thread.sleep(this.timeToStopTests);
            }
            catch (InterruptedException ex) {
                throw new TestProblemException("Thread.sleep(timeToStopTests) failed ", (Throwable)ex);
            }
            allTestsShouldStop = true;
        }
    }
}

