/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.batchfetch;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.batchfetch.BatchFetchTableCreator;
import org.eclipse.persistence.testing.models.jpa.batchfetch.Company;
import org.eclipse.persistence.testing.models.jpa.batchfetch.Count;
import org.eclipse.persistence.testing.models.jpa.batchfetch.Employee;
import org.eclipse.persistence.testing.models.jpa.batchfetch.Record;

public class BatchFetchJUnitTest
extends JUnitTestCase {
    public BatchFetchJUnitTest() {
    }

    public BatchFetchJUnitTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("BatchFetchJunitTest");
        suite.addTest((Test)new BatchFetchJUnitTest("testSetup"));
        suite.addTest((Test)new BatchFetchJUnitTest("testSelectRoot"));
        suite.addTest((Test)new BatchFetchJUnitTest("testSelectNonRoot"));
        suite.addTest((Test)new BatchFetchJUnitTest("testSelectNonRootWithOffsetAndLimit"));
        return suite;
    }

    public void testSetup() {
        new BatchFetchTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession((String)"batchfetch"));
        EntityManager em = this.createEntityManager();
        this.createRecords(em);
    }

    public void createRecords(EntityManager em) {
        try {
            this.beginTransaction(em);
            Company c1 = new Company(1L);
            Company c2 = new Company(2L);
            em.persist((Object)c1);
            em.persist((Object)c2);
            Employee u1 = new Employee(1L, c1);
            Employee u2 = new Employee(2L, c1);
            Employee u3 = new Employee(3L, c2);
            em.persist((Object)u1);
            em.persist((Object)u2);
            em.persist((Object)u3);
            Record r1 = new Record(1L, u1);
            Record r2 = new Record(2L, u2);
            Record r3 = new Record(3L, u3);
            em.persist((Object)r1);
            em.persist((Object)r2);
            em.persist((Object)r3);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testSelectRoot() {
        EntityManager em = this.createEntityManager();
        em.getEntityManagerFactory().getCache().evictAll();
        try {
            TypedQuery q = em.createQuery("SELECT r FROM Record r", Record.class);
            List result = q.getResultList();
            BatchFetchJUnitTest.assertEquals((String)"Not all rows are selected", (int)3, (int)result.size());
            List employees = result.stream().map(Record::getEmployee).filter(Objects::nonNull).collect(Collectors.toList());
            BatchFetchJUnitTest.assertEquals((String)"Not all rows have employees", (int)3, (int)employees.size());
            List companies = employees.stream().map(Employee::getCompany).filter(Objects::nonNull).collect(Collectors.toList());
            BatchFetchJUnitTest.assertEquals((String)"Not all employees have companies", (int)3, (int)companies.size());
        }
        catch (RuntimeException e) {
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testSelectNonRoot() {
        EntityManager em = this.createEntityManager();
        em.getEntityManagerFactory().getCache().evictAll();
        try {
            TypedQuery q = em.createQuery("SELECT r.employee FROM Record r", Employee.class);
            List result = q.getResultList();
            BatchFetchJUnitTest.assertEquals((String)"Not all rows are selected", (int)3, (int)result.size());
            List companies = result.stream().map(Employee::getCompany).filter(Objects::nonNull).collect(Collectors.toList());
            BatchFetchJUnitTest.assertEquals((String)"Not all employees have companies", (int)3, (int)companies.size());
        }
        catch (RuntimeException e) {
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testSelectNonRootWithOffsetAndLimit() {
        EntityManager em = this.createEntityManager();
        em.getEntityManagerFactory().getCache().evictAll();
        try {
            TypedQuery q = em.createQuery("SELECT new org.eclipse.persistence.testing.models.jpa.batchfetch.Count(count(r.employee), r.employee) FROM Record r group by r.employee", Count.class);
            q.setHint("eclipselink.batch.size", (Object)1);
            List result = q.getResultList();
            BatchFetchJUnitTest.assertEquals((String)"Not all rows are selected", (int)3, (int)result.size());
            List employees = result.stream().map(Count::getEmp).filter(Objects::nonNull).collect(Collectors.toList());
            BatchFetchJUnitTest.assertEquals((String)"Not all counts have employees", (int)3, (int)result.size());
            List companies = employees.stream().map(Employee::getCompany).filter(Objects::nonNull).collect(Collectors.toList());
            BatchFetchJUnitTest.assertEquals((String)"Not all employees have companies", (int)3, (int)companies.size());
        }
        catch (RuntimeException e) {
            this.closeEntityManager(em);
            throw e;
        }
    }

    public String getPersistenceUnitName() {
        return "batchfetch";
    }
}

