/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport.connection;

import com.sun.corba.ee.impl.transport.connection.OutboundCacheEntry;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.concurrent.ConcurrentQueue;
import com.sun.corba.ee.spi.transport.connection.Connection;
import com.sun.corba.ee.spi.transport.connection.ContactInfo;
import java.io.IOException;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedData;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;

@Transport
@ManagedData
public class OutboundConnectionState<C extends Connection> {
    private ConnectionStateValue csv = ConnectionStateValue.NEW;
    final ContactInfo<C> cinfo;
    final C connection;
    final OutboundCacheEntry<C> entry;
    private int busyCount;
    int expectedResponseCount;
    ConcurrentQueue.Handle<C> reclaimableHandle;

    public String toString() {
        return "OutboundConnectionState[csv=" + (Object)((Object)this.csv) + ",cinfo=" + this.cinfo + ",connection=" + this.connection + ",busyCount=" + this.busyCount + ",expectedResponceCount=" + this.expectedResponseCount + "]";
    }

    @ManagedAttribute
    @Description(value="The current state of this connection")
    private synchronized ConnectionStateValue state() {
        return this.csv;
    }

    @ManagedAttribute
    @Description(value="The contactInfo used to create this connection")
    private synchronized ContactInfo<C> contactInfo() {
        return this.cinfo;
    }

    @ManagedAttribute
    @Description(value="The underlying connection for this ConnectionState")
    private synchronized C connection() {
        return this.connection;
    }

    @ManagedAttribute
    private synchronized OutboundCacheEntry<C> cacheEntry() {
        return this.entry;
    }

    @ManagedAttribute
    private synchronized int busyCount() {
        return this.busyCount;
    }

    @ManagedAttribute
    private synchronized int expectedResponseCount() {
        return this.expectedResponseCount;
    }

    @ManagedAttribute
    public synchronized boolean isReclaimable() {
        return this.reclaimableHandle != null;
    }

    public OutboundConnectionState(ContactInfo<C> cinfo, OutboundCacheEntry<C> entry, C conn) {
        this.cinfo = cinfo;
        this.connection = conn;
        this.entry = entry;
        this.busyCount = 0;
        this.expectedResponseCount = 0;
        this.reclaimableHandle = null;
    }

    public synchronized boolean isBusy() {
        return this.csv == ConnectionStateValue.BUSY;
    }

    public synchronized boolean isIdle() {
        return this.csv == ConnectionStateValue.IDLE;
    }

    @Transport
    public synchronized void acquire() {
        if (this.busyCount == 0) {
            this.entry.idleConnections.remove(this.connection);
            this.removeFromReclaim();
            this.csv = ConnectionStateValue.BUSY;
        } else {
            this.entry.busyConnections.remove(this.connection);
        }
        ++this.busyCount;
        this.entry.busyConnections.offer(this.connection);
    }

    public synchronized void setReclaimableHandle(ConcurrentQueue.Handle<C> handle) {
        this.reclaimableHandle = handle;
    }

    @InfoMethod
    private void msg(String m) {
    }

    @InfoMethod
    private void display(String m, Object value) {
    }

    @Transport
    public synchronized int release(int numResponsesExpected) {
        this.expectedResponseCount += numResponsesExpected;
        --this.busyCount;
        if (this.busyCount < 0) {
            this.msg("ERROR: numBusy is <0!");
        }
        if (this.busyCount == 0) {
            this.csv = ConnectionStateValue.IDLE;
            boolean wasOnBusy = this.entry.busyConnections.remove(this.connection);
            if (!wasOnBusy) {
                this.msg("connection not on busy queue, should have been");
            }
            this.entry.idleConnections.offer(this.connection);
        }
        this.display("expectedResponseCount", this.expectedResponseCount);
        this.display("busyCount", this.busyCount);
        return this.expectedResponseCount;
    }

    @Transport
    public synchronized boolean responseReceived() {
        boolean result = false;
        --this.expectedResponseCount;
        this.display("expectedResponseCount", this.expectedResponseCount);
        if (this.expectedResponseCount < 0) {
            this.msg("ERROR: expectedResponseCount<0!");
            this.expectedResponseCount = 0;
        }
        result = this.expectedResponseCount == 0 && this.busyCount == 0;
        return result;
    }

    @Transport
    public synchronized void close() throws IOException {
        this.removeFromReclaim();
        if (this.csv == ConnectionStateValue.IDLE) {
            this.entry.idleConnections.remove(this.connection);
        } else if (this.csv == ConnectionStateValue.BUSY) {
            this.entry.busyConnections.remove(this.connection);
        }
        this.csv = ConnectionStateValue.NEW;
        this.busyCount = 0;
        this.expectedResponseCount = 0;
        this.connection.close();
    }

    @Transport
    private void removeFromReclaim() {
        if (this.reclaimableHandle != null) {
            if (!this.reclaimableHandle.remove()) {
                this.display("result was not on reclaimable Q", this.cinfo);
            }
            this.reclaimableHandle = null;
        }
    }

    private static enum ConnectionStateValue {
        NEW,
        BUSY,
        IDLE;

    }
}

