/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public class ListenerPortRange {
    private static final InetAddress ANY_LOCAL = new InetSocketAddress(0).getAddress();
    private final InetAddress address;
    private final int portStart;
    private final int portEnd;

    public ListenerPortRange(String hostname, int portStart, int portEnd) throws UnknownHostException {
        this(hostname == null ? ANY_LOCAL : InetAddress.getByName(hostname), portStart, portEnd);
    }

    public ListenerPortRange(int portStart, int portEnd) {
        this(ANY_LOCAL, portStart, portEnd);
    }

    public ListenerPortRange(String hostname) throws UnknownHostException {
        this(InetAddress.getByName(hostname));
    }

    public ListenerPortRange() {
        this(ANY_LOCAL);
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPortStart() {
        return this.portStart;
    }

    public int getPortEnd() {
        return this.portEnd;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ListenerPortRange)) {
            return false;
        }
        ListenerPortRange that = (ListenerPortRange)obj;
        return this.address.equals(that.address) && this.portStart == that.portStart && this.portEnd == that.portEnd;
    }

    public int hashCode() {
        int hash = this.address.hashCode() * 31 + this.portStart;
        hash = hash * 31 + this.portEnd;
        return hash;
    }

    public String toString() {
        return String.format("%s:%s-%s", this.address, this.portStart, this.portEnd);
    }

    private ListenerPortRange(InetAddress address, int portStart, int portEnd) {
        if (portStart <= 0) {
            throw new IllegalArgumentException("Starting port should be greater than 0");
        }
        if (portEnd < portStart) {
            throw new IllegalArgumentException("Starting port is larger than ending port");
        }
        if (portEnd >= 65536) {
            throw new IllegalArgumentException("Port cannot be larger than 16 bits");
        }
        this.address = address;
        this.portStart = portStart;
        this.portEnd = portEnd;
    }

    private ListenerPortRange(InetAddress address) {
        this.address = address;
        this.portStart = 0;
        this.portEnd = 0;
    }
}

