/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.dialog.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.nio.AbstractNioChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import oracle.kv.impl.async.AsyncOption;
import oracle.kv.impl.async.EndpointConfig;
import oracle.kv.impl.async.ListenerConfig;
import oracle.kv.impl.async.ListenerPortRange;
import oracle.kv.impl.async.NetworkAddress;
import oracle.kv.impl.async.dialog.netty.VerifyingSSLHandler;
import oracle.kv.impl.security.ssl.SSLControl;
import oracle.kv.impl.util.ObjectUtil;

class NettyUtil {
    public static Map<AsyncOption<?>, ChannelOption<?>> optionMapping;
    public static AsyncOption<?>[] clientSupportedOptions;
    public static AsyncOption<?>[] serverSupportedOptions;

    NettyUtil() {
    }

    public static void connect(final Bootstrap bootstrap, final EndpointConfig endpointConfig, NetworkAddress address) {
        for (AsyncOption<?> clientOption : clientSupportedOptions) {
            new OptionSetter(){

                @Override
                public <T> void set(AsyncOption<T> ao) {
                    ChannelOption<?> co = optionMapping.get(ao);
                    T val = endpointConfig.getOption(ao);
                    if (val != null) {
                        bootstrap.option(co, val);
                    }
                }
            }.set(clientOption);
        }
        bootstrap.connect(address.getHostName(), address.getPort());
    }

    public static Channel listen(final ServerBootstrap serverBootstrap, final ListenerConfig listenerConfig) throws IOException {
        for (AsyncOption<?> serverOption : serverSupportedOptions) {
            new OptionSetter(){

                @Override
                public <T> void set(AsyncOption<T> ao) {
                    ChannelOption<?> co = optionMapping.get(ao);
                    Object val = listenerConfig.getOption(ao);
                    if (val != null) {
                        serverBootstrap.option(co, val);
                    }
                }
            }.set(serverOption);
        }
        ListenerPortRange portRange = listenerConfig.getPortRange();
        InetAddress addr = portRange.getAddress();
        int portStart = portRange.getPortStart();
        int portEnd = portRange.getPortEnd();
        for (int port = portStart; port <= portEnd; ++port) {
            ChannelFuture future = serverBootstrap.bind((SocketAddress)new InetSocketAddress(addr, port));
            try {
                future.sync();
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted during binding");
            }
            if (!future.isSuccess()) continue;
            return future.channel();
        }
        throw new IOException(String.format("No free local address to bind for range %s", portRange));
    }

    public static NetworkAddress getLocalAddress(Channel channel) {
        InetSocketAddress socketAddress = (InetSocketAddress)channel.localAddress();
        return new NetworkAddress(socketAddress.getHostName(), socketAddress.getPort());
    }

    public static SocketChannel getSocketChannel(Channel channel) {
        AbstractNioChannel nioChannel = (AbstractNioChannel)channel;
        AbstractNioChannel.NioUnsafe nioUnsafe = nioChannel.unsafe();
        return (SocketChannel)nioUnsafe.ch();
    }

    public static VerifyingSSLHandler newSSLHandler(String endpointId, SSLControl sslControl, NetworkAddress remoteAddress, boolean isClient, Logger logger) {
        ObjectUtil.checkNull("sslControl", sslControl);
        String hostname = remoteAddress.getHostName();
        int port = remoteAddress.getPort();
        SSLEngine engine = sslControl.sslContext().createSSLEngine(hostname, port);
        engine.setSSLParameters(sslControl.sslParameters());
        engine.setUseClientMode(isClient);
        if (!isClient && sslControl.peerAuthenticator() != null) {
            engine.setWantClientAuth(true);
        }
        String targetHost = isClient ? hostname : null;
        return new VerifyingSSLHandler(logger, endpointId, engine, targetHost, sslControl.hostVerifier(), sslControl.peerAuthenticator());
    }

    static {
        HashMap<AsyncOption<Comparable<Boolean>>, ChannelOption> mapping = new HashMap<AsyncOption<Comparable<Boolean>>, ChannelOption>();
        mapping.put(AsyncOption.SO_KEEPALIVE, ChannelOption.SO_KEEPALIVE);
        mapping.put(AsyncOption.SO_LINGER, ChannelOption.SO_LINGER);
        mapping.put(AsyncOption.SO_RCVBUF, ChannelOption.SO_RCVBUF);
        mapping.put(AsyncOption.SO_REUSEADDR, ChannelOption.SO_REUSEADDR);
        mapping.put(AsyncOption.SO_SNDBUF, ChannelOption.SO_SNDBUF);
        mapping.put(AsyncOption.TCP_NODELAY, ChannelOption.TCP_NODELAY);
        mapping.put(AsyncOption.SSO_BACKLOG, ChannelOption.SO_BACKLOG);
        optionMapping = Collections.unmodifiableMap(mapping);
        clientSupportedOptions = new AsyncOption[]{AsyncOption.SO_KEEPALIVE, AsyncOption.SO_LINGER, AsyncOption.SO_RCVBUF, AsyncOption.SO_REUSEADDR, AsyncOption.SO_SNDBUF, AsyncOption.TCP_NODELAY};
        serverSupportedOptions = new AsyncOption[]{AsyncOption.SO_RCVBUF, AsyncOption.SO_REUSEADDR, AsyncOption.SSO_BACKLOG};
    }

    private static interface OptionSetter {
        public <T> void set(AsyncOption<T> var1);
    }
}

