/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.dialog.nio;

import com.sleepycat.je.rep.net.DataChannel;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.logging.Logger;
import oracle.kv.impl.async.AbstractCreatorEndpoint;
import oracle.kv.impl.async.EndpointConfig;
import oracle.kv.impl.async.EndpointHandler;
import oracle.kv.impl.async.NetworkAddress;
import oracle.kv.impl.async.dialog.nio.NioChannelExecutor;
import oracle.kv.impl.async.dialog.nio.NioChannelThreadPool;
import oracle.kv.impl.async.dialog.nio.NioEndpointGroup;
import oracle.kv.impl.async.dialog.nio.NioUtil;
import oracle.kv.impl.async.dialog.nio.PreWriteWrappedEndpointHandler;

class NioCreatorEndpoint
extends AbstractCreatorEndpoint {
    private final NioEndpointGroup endpointGroup;
    private final NioChannelThreadPool channelThreadPool;

    NioCreatorEndpoint(NioEndpointGroup endpointGroup, NioChannelThreadPool channelThreadPool, NetworkAddress remoteAddress, EndpointConfig endpointConfig) {
        super(endpointGroup, remoteAddress, endpointConfig);
        this.endpointGroup = endpointGroup;
        this.channelThreadPool = channelThreadPool;
    }

    @Override
    protected EndpointHandler newEndpointHandler() throws IOException {
        EndpointConfig config = this.getEndpointConfig();
        NioChannelExecutor executor = this.channelThreadPool.next();
        DataChannel dataChannel = NioUtil.getDataChannel(this.remoteAddress, config, this.getLogger());
        PreWriteWrappedEndpointHandler handler = new PreWriteWrappedEndpointHandler(this, this.endpointConfig, this.remoteAddress, executor, this.getDialogHandlerFactories(), dataChannel);
        SocketChannel socketChannel = dataChannel.getSocketChannel();
        if (socketChannel.isConnected()) {
            handler.onConnected();
        } else {
            executor.registerConnect(socketChannel, handler);
        }
        return handler;
    }

    Logger getLogger() {
        return this.endpointGroup.getLogger();
    }

    public String toString() {
        return String.format("NioCreatorEndpoint[%s]", this.remoteAddress);
    }
}

