/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.kv.Direction;
import oracle.kv.impl.api.table.FieldDefFactory;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.StringValueImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.CompilerAPI;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprArrayConstr;
import oracle.kv.impl.query.compiler.ExprBaseTable;
import oracle.kv.impl.query.compiler.ExprCast;
import oracle.kv.impl.query.compiler.ExprConst;
import oracle.kv.impl.query.compiler.ExprFieldStep;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.ExprPromote;
import oracle.kv.impl.query.compiler.ExprUtils;
import oracle.kv.impl.query.compiler.ExprVar;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.IndexExpr;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.SortSpec;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;
import oracle.kv.table.Index;

class ExprSFW
extends Expr {
    private int theNumChildren;
    private ArrayList<FromClause> theFromClauses = new ArrayList(8);
    private Expr theWhereExpr;
    private ArrayList<String> theFieldNames;
    private ArrayList<Expr> theFieldExprs;
    private boolean theConstructsRecord = true;
    private boolean theDoNullOnEmpty = true;
    private int theNumGroupByExprs = -1;
    private boolean theNeedOuterSFWForGroupBy;
    private ArrayList<Expr> theSortExprs;
    private ArrayList<SortSpec> theSortSpecs;
    private boolean theUsePrimaryIndexForSort = false;
    private ArrayList<IndexImpl> theSortingIndexes = null;
    private ExprFuncCall theNearPred;
    private boolean theHasNearPred;
    private Expr theOffsetExpr;
    private Expr theLimitExpr;
    private boolean theGroupByExprCompleteShardKey = false;

    ExprSFW(QueryControlBlock qcb, StaticContext sctx, QueryException.Location location) {
        super(qcb, sctx, Expr.ExprKind.SFW, location);
    }

    ExprVar createFromVar(Expr domainExpr, String varName) {
        return this.createFrom(domainExpr, varName, null);
    }

    ExprVar createTableVar(Expr domExpr, TableImpl table, String varName) {
        assert (table != null && (domExpr.getKind() == Expr.ExprKind.BASE_TABLE || domExpr.getKind() == Expr.ExprKind.UPDATE_ROW || domExpr.getKind() == Expr.ExprKind.INSERT_ROW || domExpr.getKind() == Expr.ExprKind.DELETE_ROW));
        for (FromClause fc : this.theFromClauses) {
            if (fc.getDomainExpr() != domExpr) continue;
            return fc.addVar(varName, table);
        }
        return this.createFrom(domExpr, varName, table);
    }

    private ExprVar createFrom(Expr domainExpr, String varName, TableImpl table) {
        FromClause fc = new FromClause(domainExpr, varName, table);
        this.theFromClauses.add(fc);
        ++this.theNumChildren;
        return fc.getVar(0);
    }

    void removeFromClause(int i, boolean destroy) {
        FromClause fc = this.theFromClauses.get(i);
        for (ExprVar var : fc.getVars()) {
            assert (!var.hasParents());
        }
        this.theFromClauses.remove(i);
        --this.theNumChildren;
        fc.getDomainExpr().removeParent(this, destroy);
    }

    FromClause getFromClause(int i) {
        return this.theFromClauses.get(i);
    }

    FromClause getFirstFrom() {
        return this.getFromClause(0);
    }

    int getNumFroms() {
        return this.theFromClauses.size();
    }

    Expr getDomainExpr(int i) {
        return this.theFromClauses.get(i).getDomainExpr();
    }

    void setDomainExpr(int i, Expr newExpr, boolean destroy) {
        FromClause fc = this.theFromClauses.get(i);
        fc.theDomainExpr.removeParent(this, destroy);
        fc.theDomainExpr = newExpr;
        newExpr.addParent(this);
    }

    ArrayList<ExprVar> findVarsForExpr(Expr expr) {
        for (int i = 0; i < this.theFromClauses.size(); ++i) {
            FromClause fc = this.theFromClauses.get(i);
            if (fc.getDomainExpr() != expr) continue;
            return fc.getVars();
        }
        return null;
    }

    void removeUnusedVars() {
        for (int i = this.theFromClauses.size() - 1; i >= 0; --i) {
            FromClause fc = this.theFromClauses.get(i);
            if (!fc.getDomainExpr().isScalar() || fc.getVar(0).getNumParents() != 0) continue;
            assert (fc.getNumVars() == 1);
            this.removeFromClause(i, true);
        }
    }

    ExprVar addIndexVar(TableImpl table, IndexImpl index) {
        for (FromClause fc : this.theFromClauses) {
            ArrayList<TableImpl> tables = fc.getTables();
            if (tables == null) continue;
            int tablePos = -1;
            for (int i = 0; i < tables.size(); ++i) {
                if (tables.get(i).getId() != table.getId()) continue;
                tablePos = i;
                break;
            }
            if (tablePos < 0) continue;
            ExprVar var = fc.getVar(tablePos);
            String idxVarName = var.createIndexVarName();
            ExprVar idxVar = new ExprVar(this.theQCB, this.theSctx, var.theLocation, idxVarName, table, fc);
            RecordDefImpl indexEntryDef = index != null ? index.getIndexEntryDef() : table.getRowDef();
            ExprType idxVarType = TypeManager.createType(indexEntryDef, ExprType.Quantifier.ONE);
            idxVar.setIndex(index, idxVarType);
            fc.setIndexVar(tablePos, idxVar);
            return idxVar;
        }
        return null;
    }

    void addWhereClause(Expr condExpr) {
        assert (this.theWhereExpr == null);
        this.theWhereExpr = ExprPromote.create(null, condExpr, TypeManager.BOOLEAN_QSTN());
        this.theWhereExpr.addParent(this);
        ++this.theNumChildren;
    }

    Expr getWhereExpr() {
        return this.theWhereExpr;
    }

    void setWhereExpr(Expr newExpr, boolean destroy) {
        this.theWhereExpr.removeParent(this, destroy);
        this.theWhereExpr = null;
        this.addWhereClause(newExpr);
    }

    void removeWhereExpr(boolean destroy) {
        this.theWhereExpr.removeParent(this, destroy);
        this.theWhereExpr = null;
        --this.theNumChildren;
    }

    void addSelectClause(ArrayList<String> fieldNames, ArrayList<Expr> fieldExprs) {
        assert (fieldNames.size() == fieldExprs.size());
        this.theFieldNames = fieldNames;
        this.theFieldExprs = fieldExprs;
        for (int i = 0; i < fieldExprs.size(); ++i) {
            Expr expr = fieldExprs.get(i);
            if (expr.isMultiValued()) {
                ArrayList<Expr> args = new ArrayList<Expr>(1);
                args.add(expr);
                expr = new ExprArrayConstr(this.theQCB, this.theSctx, expr.getLocation(), args, true);
            }
            expr.addParent(this);
            this.theFieldExprs.set(i, expr);
        }
        this.theNumChildren += fieldExprs.size();
    }

    boolean getConstructsRecord() {
        return this.theConstructsRecord;
    }

    void setConstructsRecord(boolean v) {
        if (v != this.theConstructsRecord) {
            this.theConstructsRecord = v;
            this.theType = this.computeType();
        }
    }

    Expr getFieldExpr(int i) {
        return this.theFieldExprs.get(i);
    }

    void setFieldExpr(int i, Expr newExpr, boolean destroy) {
        this.theFieldExprs.get(i).removeParent(this, destroy);
        if (newExpr.isMultiValued()) {
            ArrayList<Expr> args = new ArrayList<Expr>(1);
            args.add(newExpr);
            newExpr = new ExprArrayConstr(this.theQCB, this.theSctx, newExpr.theLocation, args, true);
        }
        this.theFieldExprs.set(i, newExpr);
        newExpr.addParent(this);
    }

    void removeField(int i, boolean destroy) {
        this.theFieldExprs.get(i).removeParent(this, destroy);
        this.theFieldExprs.remove(i);
        this.theFieldNames.remove(i);
        this.theType = this.computeType();
        --this.theNumChildren;
    }

    void addField(String name, Expr expr) {
        if (this.theFieldExprs == null) {
            this.theFieldExprs = new ArrayList();
            this.theFieldNames = new ArrayList();
        }
        expr = ExprPromote.create(null, expr, TypeManager.ANY_QSTN());
        this.theFieldExprs.add(expr);
        this.theFieldNames.add(name);
        expr.addParent(this);
        if (this.theFieldExprs.size() > 1) {
            this.theConstructsRecord = true;
        }
        this.theType = this.computeType();
        ++this.theNumChildren;
    }

    String getFieldName(int i) {
        return this.theFieldNames.get(i);
    }

    int getNumFields() {
        return this.theFieldExprs == null ? 0 : this.theFieldExprs.size();
    }

    ArrayList<String> getFieldNames() {
        return this.theFieldNames;
    }

    void setFieldNames(ArrayList<String> fieldNames) {
        this.theFieldNames = fieldNames;
        this.theType = this.computeType();
    }

    String[] getFieldNamesArray() {
        String[] arr = new String[this.theFieldNames.size()];
        return this.theFieldNames.toArray(arr);
    }

    boolean doNullOnEmpty() {
        return this.theDoNullOnEmpty;
    }

    void setDoNullOnEmpty(boolean v) {
        this.theDoNullOnEmpty = v;
    }

    int getNumGroupByExprs() {
        return this.theNumGroupByExprs;
    }

    void setNumGroupByExprs(int v) {
        if (this.theNumGroupByExprs < v) {
            this.theNumGroupByExprs = v;
        }
    }

    boolean hasGroupBy() {
        return this.theNumGroupByExprs >= 0;
    }

    boolean needOuterSFWForGroupBy() {
        return this.theNeedOuterSFWForGroupBy;
    }

    boolean isGroupingField(int i) {
        return this.theNumGroupByExprs > 0 && i < this.theNumGroupByExprs;
    }

    void addGroupByClause(ArrayList<Expr> gbExprs) {
        this.theFieldNames = new ArrayList(gbExprs.size());
        for (int i = 0; i < gbExprs.size(); ++i) {
            Expr expr = gbExprs.get(i);
            expr = ExprPromote.create(null, expr, TypeManager.ANY_ATOMIC_QSTN());
            expr.addParent(this);
            gbExprs.set(i, expr);
            this.theFieldNames.add("gb-" + i);
        }
        this.theFieldExprs = gbExprs;
        this.theNumGroupByExprs = gbExprs.size();
        this.theNumChildren += this.theNumGroupByExprs;
    }

    Expr rewriteSelectExprForGroupBy(int fieldPos, Expr fieldExpr, String fieldName, Expr fieldSubExpr, ExprSFW outerSFW, ExprVar outerFromVar) {
        if (fieldSubExpr.isStepExpr()) {
            for (int i = 0; i < this.theNumGroupByExprs; ++i) {
                if (!ExprUtils.matchExprs(fieldSubExpr, this.getFieldExpr(i))) continue;
                String gbName = "gb-" + i;
                ExprFieldStep fieldRef = new ExprFieldStep(this.theQCB, this.theSctx, this.theLocation, (Expr)outerFromVar, gbName);
                if (i != fieldPos || fieldSubExpr != fieldExpr) {
                    outerSFW.theNeedOuterSFWForGroupBy = true;
                }
                if (fieldSubExpr == fieldExpr) {
                    return fieldRef;
                }
                fieldSubExpr.replace(fieldRef, false);
                return fieldExpr;
            }
        } else {
            if (fieldSubExpr.getFunction(null) != null && fieldSubExpr.getFunction(null).isAggregate()) {
                Expr fieldRef;
                int i;
                int numFields = this.getNumFields();
                for (i = this.theNumGroupByExprs; i < numFields && !ExprUtils.matchExprs(fieldSubExpr, this.getFieldExpr(i)); ++i) {
                }
                QueryException.Location loc = fieldSubExpr.getLocation();
                String aggrName = "aggr-" + i;
                if (fieldSubExpr.getFunction(FunctionLib.FuncCode.FN_AVG) != null) {
                    assert (i == numFields);
                    outerSFW.theNeedOuterSFWForGroupBy = true;
                    Expr inExpr = fieldSubExpr.getInput();
                    Expr sumExpr = ExprFuncCall.create(this.theQCB, this.theSctx, loc, FunctionLib.FuncCode.FN_SUM, inExpr);
                    Expr cntExpr = ExprFuncCall.create(this.theQCB, this.theSctx, loc, FunctionLib.FuncCode.FN_COUNT_NUMBERS, inExpr);
                    this.addField(aggrName, sumExpr);
                    String aggrName2 = "aggr-" + (i + 1);
                    this.addField(aggrName2, cntExpr);
                    numFields = this.getNumFields();
                    outerFromVar.computeType(false);
                    ExprFieldStep sumRef = new ExprFieldStep(this.theQCB, this.theSctx, loc, (Expr)outerFromVar, aggrName);
                    Expr cntRef = new ExprFieldStep(this.theQCB, this.theSctx, loc, (Expr)outerFromVar, aggrName2);
                    cntRef = ExprCast.create(this.theQCB, this.theSctx, loc, cntRef, FieldDefImpl.doubleDef, ExprType.Quantifier.ONE);
                    ArrayList<Expr> args = new ArrayList<Expr>(3);
                    args.add(sumRef);
                    args.add(cntRef);
                    StringValueImpl ops = FieldDefImpl.stringDef.createString("*/");
                    args.add(new ExprConst(this.theQCB, this.theSctx, loc, ops));
                    fieldRef = ExprFuncCall.create(this.theQCB, this.theSctx, loc, FunctionLib.FuncCode.OP_MULT_DIV, args);
                } else {
                    if (i == numFields) {
                        this.addField(aggrName, fieldSubExpr);
                        outerFromVar.computeType(false);
                    }
                    fieldRef = new ExprFieldStep(this.theQCB, this.theSctx, loc, (Expr)outerFromVar, aggrName);
                }
                if (i != fieldPos || fieldSubExpr != fieldExpr) {
                    outerSFW.theNeedOuterSFWForGroupBy = true;
                }
                if (fieldSubExpr == fieldExpr) {
                    return fieldRef;
                }
                fieldSubExpr.replace(fieldRef, false);
                this.setFieldExpr(i, fieldSubExpr, false);
                return fieldExpr;
            }
            if (fieldSubExpr.getKind() == Expr.ExprKind.VAR) {
                ExprVar var = (ExprVar)fieldSubExpr;
                if (var.getVarKind() != ExprVar.VarKind.EXTERNAL) {
                    throw new QueryException("Invalid expression in the SELECT clause. When a select-from-where expression includes grouping, its SELECT expressions must reference grouping columns and aggregate functions", fieldSubExpr.getLocation());
                }
                return fieldExpr;
            }
        }
        outerSFW.theNeedOuterSFWForGroupBy = true;
        Expr.ExprIter children = fieldSubExpr.getChildren();
        while (children.hasNext()) {
            Expr child = children.next();
            this.rewriteSelectExprForGroupBy(fieldPos, fieldExpr, fieldName, child, outerSFW, outerFromVar);
        }
        children.reset();
        return fieldExpr;
    }

    void addSortClause(ArrayList<Expr> sortExprs, ArrayList<SortSpec> sortSpecs) {
        if (this.theNumGroupByExprs > 0) {
            throw new QueryException("select-from-where expression cannot have both order by and group by clauses");
        }
        for (int i = 0; i < sortExprs.size(); ++i) {
            Expr expr = sortExprs.get(i);
            expr = ExprPromote.create(null, expr, TypeManager.ANY_ATOMIC_QSTN());
            expr.addParent(this);
            sortExprs.set(i, expr);
        }
        this.theSortExprs = sortExprs;
        this.theSortSpecs = sortSpecs;
        this.theNumChildren += this.theSortExprs.size();
    }

    void removeSort() {
        if (!this.hasSort()) {
            return;
        }
        while (!this.theSortExprs.isEmpty()) {
            this.removeSortExpr(0, true);
        }
        this.theSortExprs = null;
        this.theSortSpecs = null;
        this.theSortingIndexes = null;
        this.theUsePrimaryIndexForSort = false;
    }

    boolean hasSort() {
        return this.theSortExprs != null && !this.theSortExprs.isEmpty();
    }

    boolean hasPrimaryIndexBasedSort() {
        return this.theUsePrimaryIndexForSort;
    }

    boolean hasSecondaryIndexBasedSort() {
        return this.theSortingIndexes != null && !this.theSortingIndexes.isEmpty();
    }

    boolean getGroupByExprCompleteShardKey() {
        return this.theGroupByExprCompleteShardKey;
    }

    ArrayList<IndexImpl> getSortingIndexes() {
        return this.theSortingIndexes;
    }

    int getNumSortExprs() {
        return this.theSortExprs == null ? 0 : this.theSortExprs.size();
    }

    Expr getSortExpr(int i) {
        return this.theSortExprs.get(i);
    }

    void setSortExpr(int i, Expr newExpr, boolean destroy) {
        this.theSortExprs.get(i).removeParent(this, destroy);
        this.theSortExprs.set(i, newExpr);
        newExpr.addParent(this);
    }

    void removeSortExpr(int i, boolean destroy) {
        Expr sortExpr = this.theSortExprs.remove(i);
        sortExpr.removeParent(this, destroy);
        this.theSortSpecs.remove(i);
        --this.theNumChildren;
    }

    SortSpec[] getSortSpecs() {
        SortSpec[] arr = new SortSpec[this.theSortSpecs.size()];
        return this.theSortSpecs.toArray(arr);
    }

    void analyseOrderOrGroupBy(boolean orderby) {
        String opKind = orderby ? "order-by " : "group-by ";
        FromClause fc = this.getFirstFrom();
        TableImpl table = fc.getTargetTable();
        if (table == null) {
            throw new QueryException(opKind + "cannot be performed because the " + opKind + "expressions are not consecutive columns of any index", this.getLocation());
        }
        ExprBaseTable tableExpr = fc.getTableExpr();
        IndexImpl.IndexField ipath = null;
        int i = 0;
        boolean desc = false;
        boolean nullsLast = false;
        if (orderby) {
            SortSpec spec = this.theSortSpecs.get(0);
            desc = spec.theIsDesc;
            nullsLast = !spec.theNullsFirst;
            Direction direction = desc ? Direction.REVERSE : Direction.FORWARD;
            for (i = 1; i < this.theSortSpecs.size(); ++i) {
                spec = this.theSortSpecs.get(i);
                if (desc == spec.theIsDesc && nullsLast == !spec.theNullsFirst) continue;
                throw new QueryException("In the current implementation, all order-by specs must have the same ordering direction and the same relative order for NULLs", this.getSortExpr(i).getLocation());
            }
            if (desc && nullsLast || !desc && !nullsLast) {
                throw new QueryException("NULLs ordering is not compatible with the way NULLs are ordered in indexes.");
            }
            tableExpr.setDirection(direction);
        }
        int numPkCols = table.getPrimaryKeySize();
        int numExprs = orderby ? this.theSortExprs.size() : this.theNumGroupByExprs;
        int numShardKeys = table.getShardKeySize();
        for (i = 0; i < numPkCols && i < numExprs; ++i) {
            Expr expr;
            Expr expr2 = expr = orderby ? this.getSortExpr(i) : this.getFieldExpr(i);
            if (!ExprUtils.isPrimKeyColumnRef(table, i, expr)) break;
            if (orderby || i != numShardKeys - 1) continue;
            this.theGroupByExprCompleteShardKey = true;
        }
        if (i == numExprs) {
            this.theUsePrimaryIndexForSort = true;
            if (orderby) {
                if (i > numShardKeys) {
                    while (numExprs > numShardKeys) {
                        this.removeSortExpr(numExprs - 1, true);
                        --numExprs;
                    }
                }
                if (desc && tableExpr.getNumDescendants() > 0) {
                    throw new QueryException("In the current implementation, it is not possible to order by primary key columns in descending order when the NESTED TABLES clause contains descendants");
                }
            }
            return;
        }
        this.theSortingIndexes = new ArrayList();
        Map<String, Index> indexes = table.getIndexes();
        for (Map.Entry<String, Index> entry : indexes.entrySet()) {
            IndexImpl index = (IndexImpl)entry.getValue();
            List<IndexImpl.IndexField> indexPaths = index.getIndexFields();
            if (this.hasGroupBy() && index.isMultiKey()) continue;
            for (i = 0; i < indexPaths.size() && i < numExprs; ++i) {
                IndexExpr iexpr;
                Expr expr;
                ipath = indexPaths.get(i);
                Expr expr3 = expr = orderby ? this.getSortExpr(i) : this.getFieldExpr(i);
                if (ipath.isMultiKey() || ipath.isGeometry() || (iexpr = expr.getIndexExpr()) == null || !iexpr.matchesIndex(index, ipath.getPosition())) break;
            }
            if (i == numExprs) {
                this.theSortingIndexes.add(index);
                continue;
            }
            if (i != indexPaths.size()) continue;
            for (int j = 0; j < numPkCols && i < numExprs; ++i, ++j) {
                Expr expr;
                Expr expr4 = expr = orderby ? this.getSortExpr(i) : this.getFieldExpr(i);
                if (!ExprUtils.isPrimKeyColumnRef(table, j, expr)) break;
            }
            if (i != numExprs) continue;
            this.theSortingIndexes.add(index);
        }
        if (this.theSortingIndexes.isEmpty()) {
            throw new QueryException(opKind + "cannot be performed because there is no index that orders the table rows in the desired order (in the current implementation sorting and grouping are possible only if the ORDER/GROUP BY clause contains N expressions that match the first N fields on an index, and these fields are not multi-key", this.getLocation());
        }
    }

    int[] addSortExprsToSelect() {
        int numFieldExprs = this.theFieldExprs.size();
        int numSortExprs = this.theSortExprs.size();
        int[] sortPositions = new int[numSortExprs];
        for (int i = 0; i < numSortExprs; ++i) {
            Expr fieldExpr;
            int j;
            Expr sortExpr = this.theSortExprs.get(i);
            for (j = 0; j < numFieldExprs && !ExprUtils.matchExprs(sortExpr, fieldExpr = this.theFieldExprs.get(j)); ++j) {
            }
            if (j == numFieldExprs) {
                this.theFieldExprs.add(sortExpr);
                this.theFieldNames.add(this.theQCB.generateFieldName("sort"));
                sortExpr.addParent(this);
                this.theConstructsRecord = true;
                sortPositions[i] = this.theFieldExprs.size() - 1;
                ++this.theNumChildren;
                continue;
            }
            sortPositions[i] = j;
            sortExpr.removeParent(this, true);
        }
        this.theNumChildren -= this.theSortExprs.size();
        this.theSortExprs = null;
        this.theType = this.computeType();
        return sortPositions;
    }

    boolean hasNearPred() {
        return this.theHasNearPred;
    }

    void setNearPred(ExprFuncCall e) {
        this.theNearPred = e;
        this.theHasNearPred = true;
    }

    void rewriteNearPred() {
        if (this.theNearPred == null) {
            return;
        }
        FunctionLib fnlib = CompilerAPI.getFuncLib();
        this.theNearPred.setFunction(fnlib.getFunc(FunctionLib.FuncCode.FN_GEO_WITHIN_DISTANCE));
        if (this.hasSort() || this.hasGroupBy()) {
            return;
        }
        Expr geopath = this.theNearPred.getArg(0);
        Expr geopoint = this.theNearPred.getArg(1);
        Expr distanceExpr = ExprFuncCall.create(this.theQCB, this.theSctx, geopath.getLocation(), FunctionLib.FuncCode.FN_GEO_DISTANCE, geopath, geopoint);
        ArrayList<Expr> sortExprs = new ArrayList<Expr>(1);
        ArrayList<SortSpec> sortSpecs = new ArrayList<SortSpec>(1);
        sortExprs.add(distanceExpr);
        sortSpecs.add(new SortSpec(false, false));
        this.addSortClause(sortExprs, sortSpecs);
    }

    void addOffsetLimit(Expr offset, Expr limit) {
        if (offset != null) {
            this.addOffset(offset);
        }
        if (limit != null) {
            this.addLimit(limit);
        }
    }

    Expr getOffset() {
        return this.theOffsetExpr;
    }

    void addOffset(Expr expr) {
        FieldValueImpl val;
        assert (this.theOffsetExpr == null);
        if (!Expr.ConstKind.isConst(expr)) {
            throw new QueryException("Offset expression is not constant");
        }
        if (expr.getKind() == Expr.ExprKind.CONST && (val = ((ExprConst)expr).getValue()).getLong() == 0L) {
            return;
        }
        this.theOffsetExpr = ExprPromote.create(null, expr, TypeManager.LONG_ONE());
        this.theOffsetExpr.addParent(this);
        ++this.theNumChildren;
    }

    void removeOffset(boolean destroy) {
        this.theOffsetExpr.removeParent(this, destroy);
        this.theOffsetExpr = null;
        --this.theNumChildren;
    }

    void setOffset(Expr newExpr, boolean destroy) {
        this.theOffsetExpr.removeParent(this, destroy);
        this.theOffsetExpr = null;
        --this.theNumChildren;
        this.addOffset(newExpr);
    }

    Expr getLimit() {
        return this.theLimitExpr;
    }

    void addLimit(Expr expr) {
        assert (this.theLimitExpr == null);
        if (!Expr.ConstKind.isConst(expr)) {
            throw new QueryException("Limit expression is not constant");
        }
        this.theLimitExpr = ExprPromote.create(null, expr, TypeManager.LONG_ONE());
        this.theLimitExpr.addParent(this);
        ++this.theNumChildren;
    }

    void removeLimit(boolean destroy) {
        this.theLimitExpr.removeParent(this, destroy);
        this.theLimitExpr = null;
        --this.theNumChildren;
    }

    void setLimit(Expr newExpr, boolean destroy) {
        this.theLimitExpr.removeParent(this, destroy);
        this.theLimitExpr = null;
        --this.theNumChildren;
        this.addLimit(newExpr);
    }

    @Override
    int getNumChildren() {
        return this.theNumChildren;
    }

    int computeNumChildren() {
        return this.theFromClauses.size() + (this.theWhereExpr != null ? 1 : 0) + this.theFieldExprs.size() + (this.theSortExprs != null ? this.theSortExprs.size() : 0) + (this.theOffsetExpr != null ? 1 : 0) + (this.theLimitExpr != null ? 1 : 0);
    }

    int[] addPrimKeyToSelect() {
        FromClause fc = this.theFromClauses.get(0);
        TableImpl table = fc.getTargetTable();
        int numPrimKeyCols = table.getPrimaryKeySize();
        if (this.theFieldExprs == null) {
            this.theFieldExprs = new ArrayList(numPrimKeyCols);
            this.theFieldNames = new ArrayList(numPrimKeyCols);
        }
        int numFieldExprs = this.theFieldExprs.size();
        int[] pkPositionsInSelect = new int[numPrimKeyCols];
        for (int i = 0; i < numPrimKeyCols; ++i) {
            int j;
            Expr fieldExpr = null;
            for (j = 0; j < numFieldExprs && !ExprUtils.isPrimKeyColumnRef(table, i, fieldExpr = this.theFieldExprs.get(j)); ++j) {
            }
            if (j == numFieldExprs) {
                int pkColPos;
                ExprVar rowVar;
                String pkColName = table.getPrimaryKeyColumnName(i);
                ExprVar idxVar = fc.getTargetTableIndexVar();
                if (idxVar != null) {
                    rowVar = idxVar;
                    pkColPos = idxVar.getIndex().numFields() + i;
                } else {
                    rowVar = fc.getTargetTableVar();
                    pkColPos = table.getPrimKeyPos(i);
                }
                ExprFieldStep primKeyExpr = new ExprFieldStep(this.getQCB(), this.getSctx(), this.getLocation(), (Expr)rowVar, pkColPos);
                this.theFieldExprs.add(primKeyExpr);
                primKeyExpr.addParent(this);
                this.theFieldNames.add(this.theQCB.generateFieldName(pkColName));
                pkPositionsInSelect[i] = this.theFieldExprs.size() - 1;
                this.theConstructsRecord = true;
                ++this.theNumChildren;
                continue;
            }
            pkPositionsInSelect[i] = j;
        }
        this.theType = this.computeType();
        return pkPositionsInSelect;
    }

    @Override
    ExprType computeType() {
        ExprType.Quantifier q1;
        if (this.theFieldExprs == null) {
            return null;
        }
        ExprType.Quantifier q = this.getDomainExpr(0).getType().getQuantifier();
        for (int i = 1; i < this.theFromClauses.size() && (q = TypeManager.getUnionQuant(q, q1 = this.getDomainExpr(i).getType().getQuantifier())) != ExprType.Quantifier.STAR; ++i) {
        }
        if (this.theWhereExpr != null) {
            q = TypeManager.getUnionQuant(q, ExprType.Quantifier.QSTN);
        }
        if (!this.getConstructsRecord()) {
            ExprType type = TypeManager.createType(this.getFieldExpr(0).getType(), q);
            if (type.isAnyJson()) {
                this.theQCB.theHaveJsonConstructors = true;
            }
            return type;
        }
        FieldMap fieldMap = new FieldMap();
        for (int i = 0; i < this.theFieldNames.size(); ++i) {
            FieldDefImpl fieldDef = this.theFieldExprs.get(i).getType().getDef();
            if (fieldDef.isJson()) {
                this.theQCB.theHaveJsonConstructors = true;
            }
            fieldMap.put(this.theFieldNames.get(i), fieldDef, true, null);
        }
        RecordDefImpl recDef = FieldDefFactory.createRecordDef(fieldMap, null);
        return TypeManager.createType(recDef, q);
    }

    @Override
    public boolean mayReturnNULL() {
        if (this.getConstructsRecord()) {
            return false;
        }
        return this.theFieldExprs.get(0).mayReturnNULL();
    }

    @Override
    void displayContent(StringBuilder sb, QueryFormatter formatter) {
        int i;
        formatter.indent(sb);
        for (i = 0; i < this.theFromClauses.size(); ++i) {
            FromClause fc = this.theFromClauses.get(i);
            sb.append("FROM-" + i + " :\n");
            fc.getDomainExpr().display(sb, formatter);
            sb.append(" as ");
            ArrayList<ExprVar> vars = fc.getVars();
            for (ExprVar var : vars) {
                sb.append(var.getName() + "  ");
            }
            sb.append("\n\n");
        }
        if (this.theWhereExpr != null) {
            formatter.indent(sb);
            sb.append("WHERE:\n");
            this.theWhereExpr.display(sb, formatter);
            sb.append("\n\n");
        }
        formatter.indent(sb);
        sb.append("GROUP BY:").append(this.theNumGroupByExprs);
        sb.append("\n\n");
        formatter.indent(sb);
        sb.append("SELECT:\n");
        for (i = 0; i < this.theFieldExprs.size(); ++i) {
            formatter.indent(sb);
            sb.append(this.theFieldNames.get(i)).append(": \n");
            this.theFieldExprs.get(i).display(sb, formatter);
            if (i >= this.theFieldExprs.size() - 1) continue;
            sb.append(",\n");
        }
    }

    class FromClause {
        private Expr theDomainExpr;
        private final ArrayList<ExprVar> theVars = new ArrayList();
        private final ArrayList<ExprVar> theIndexVars = new ArrayList();

        FromClause(Expr domExpr, String varName, TableImpl table) {
            this.theDomainExpr = domExpr;
            this.theDomainExpr.addParent(ExprSFW.this);
            this.theVars.add(new ExprVar(ExprSFW.this.theQCB, ExprSFW.this.theSctx, domExpr.getLocation(), varName, table, this));
            this.theIndexVars.add(null);
        }

        ExprVar addVar(String varName, TableImpl table) {
            assert (table != null);
            ExprVar var = new ExprVar(ExprSFW.this.theQCB, ExprSFW.this.theSctx, this.theDomainExpr.getLocation(), varName, table, this);
            this.theVars.add(var);
            this.theIndexVars.add(null);
            return var;
        }

        Expr getDomainExpr() {
            return this.theDomainExpr;
        }

        int getNumVars() {
            return this.theVars.size();
        }

        ArrayList<ExprVar> getVars() {
            return this.theVars;
        }

        ExprVar getVar(int i) {
            return this.theVars.get(i);
        }

        void setIndexVar(int i, ExprVar var) {
            this.theIndexVars.set(i, var);
        }

        ExprVar getIndexVar(int i) {
            return this.theIndexVars.get(i);
        }

        ExprVar getVar() {
            if (this.theVars.size() > 1) {
                throw new QueryStateException("Method called on FromClause with more than one variables. domain expression:\n" + this.theDomainExpr.display());
            }
            return this.theVars.get(0);
        }

        ArrayList<TableImpl> getTables() {
            if (this.theDomainExpr.getKind() == Expr.ExprKind.BASE_TABLE) {
                return ((ExprBaseTable)this.theDomainExpr).getTables();
            }
            return null;
        }

        ExprBaseTable getTableExpr() {
            if (this.theDomainExpr.getKind() == Expr.ExprKind.BASE_TABLE) {
                return (ExprBaseTable)this.theDomainExpr;
            }
            return null;
        }

        TableImpl getTargetTable() {
            if (this.theDomainExpr.getKind() == Expr.ExprKind.BASE_TABLE) {
                return ((ExprBaseTable)this.theDomainExpr).getTargetTable();
            }
            return null;
        }

        ExprVar getTargetTableVar() {
            if (this.theDomainExpr.getKind() == Expr.ExprKind.BASE_TABLE) {
                ExprBaseTable te = (ExprBaseTable)this.theDomainExpr;
                return this.theVars.get(te.getNumAncestors());
            }
            if (this.theDomainExpr.getKind() == Expr.ExprKind.UPDATE_ROW || this.theDomainExpr.getKind() == Expr.ExprKind.INSERT_ROW || this.theDomainExpr.getKind() == Expr.ExprKind.DELETE_ROW) {
                return this.theVars.get(0);
            }
            return null;
        }

        ExprVar getTargetTableIndexVar() {
            if (this.theDomainExpr.getKind() == Expr.ExprKind.BASE_TABLE) {
                ExprBaseTable te = (ExprBaseTable)this.theDomainExpr;
                return this.theIndexVars.get(te.getNumAncestors());
            }
            return null;
        }
    }
}

