/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.systables;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.api.table.TableBuilder;
import oracle.kv.impl.api.table.TableEvolver;
import oracle.kv.impl.api.table.TableImpl;

public abstract class SysTableDescriptor {
    protected static String makeSystemTableName(String name) {
        return "SYS$" + name;
    }

    public abstract String getTableName();

    protected abstract int getCurrentSchemaVersion();

    public final TableImpl buildTable() {
        TableBuilder builder = TableBuilder.createSystemTableBuilder(this.getTableName());
        builder.setDescription(this.getSchemaVersionString(this.getCurrentSchemaVersion()));
        this.buildTable(builder);
        return builder.buildTable();
    }

    protected abstract void buildTable(TableBuilder var1);

    public final TableImpl evolveTable(TableImpl table, Logger logger) {
        assert (table.isSystemTable());
        int schemaVersion = this.getTableSchemaVersion(table);
        if (schemaVersion >= this.getCurrentSchemaVersion()) {
            return null;
        }
        try {
            TableEvolver ev = TableEvolver.createTableEvolver(table);
            int newVersion = this.evolveTable(ev, schemaVersion);
            assert (newVersion == this.getCurrentSchemaVersion());
            ev.setDescription(this.getSchemaVersionString(newVersion));
            return ev.evolveTable();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Unexpected exception upgrading system table {0} from version {1} to {2} : {3}", new Object[]{table.getFullName(), schemaVersion, this.getCurrentSchemaVersion(), ex.getMessage()});
            return null;
        }
    }

    protected int evolveTable(TableEvolver ev, int schemaVersion) {
        throw new IllegalStateException("Attempt to evolve system table described by " + this + " at version " + schemaVersion + " to " + this.getCurrentSchemaVersion());
    }

    private String getSchemaVersionString(int schemaVersion) {
        return Integer.toString(schemaVersion);
    }

    protected int getTableSchemaVersion(TableImpl table) {
        String description = table.getDescription();
        return description == null ? 1 : Integer.parseInt(description);
    }

    public String toString() {
        return "SysTableDescriptor[" + this.getTableName() + ", " + this.getCurrentSchemaVersion() + "]";
    }
}

