/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo.change;

import com.sleepycat.persist.model.Persistent;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.topo.change.Add;
import oracle.kv.impl.topo.change.Remove;
import oracle.kv.impl.topo.change.Update;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.impl.util.SerializationUtil;

@Persistent
public abstract class TopologyChange
implements FastExternalizable,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    int sequenceNumber;

    TopologyChange(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    TopologyChange(DataInput in, short serialVersion) throws IOException {
        this.sequenceNumber = SerializationUtil.readPackedInt(in);
    }

    public static TopologyChange readFastExternal(DataInput in, short serialVersion) throws IOException {
        Type type = Type.readFastExternal(in, serialVersion);
        switch (type) {
            case ADD: {
                return new Add(in, serialVersion);
            }
            case UPDATE: {
                return new Update(in, serialVersion);
            }
            case REMOVE: {
                return new Remove(in, serialVersion);
            }
        }
        throw new AssertionError();
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        this.getType().writeFastExternal(out, serialVersion);
        SerializationUtil.writePackedInt(out, this.sequenceNumber);
    }

    protected TopologyChange() {
    }

    public abstract Type getType();

    public abstract ResourceId getResourceId();

    public abstract Topology.Component<?> getComponent();

    public abstract TopologyChange clone();

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public String toString() {
        return "seq=" + this.sequenceNumber + "/" + this.getType() + " " + this.getResourceId() + "/" + this.getComponent();
    }

    public static enum Type implements FastExternalizable
    {
        ADD(0),
        UPDATE(1),
        REMOVE(2);

        private static final Type[] VALUES;

        private Type(int ordinal) {
            if (ordinal != this.ordinal()) {
                throw new IllegalArgumentException("Wrong ordinal");
            }
        }

        public static Type readFastExternal(DataInput in, short serialVersion) throws IOException {
            byte ordinal = in.readByte();
            try {
                return VALUES[ordinal];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("Wrong ordinal for Type: " + ordinal, e);
            }
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            out.writeByte(this.ordinal());
        }

        static {
            VALUES = Type.values();
        }
    }
}

