/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util.registry;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.rmi.server.RMIServerSocketFactory;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.async.AsyncOption;
import oracle.kv.impl.async.EndpointGroup;
import oracle.kv.impl.async.ListenerConfig;
import oracle.kv.impl.async.ListenerConfigBuilder;
import oracle.kv.impl.async.ListenerPortRange;
import oracle.kv.impl.async.NetworkAddress;
import oracle.kv.impl.async.SocketPrepared;
import oracle.kv.impl.util.registry.AsyncRegistryUtils;
import oracle.kv.impl.util.registry.NullServerSocket;
import oracle.kv.impl.util.registry.NullSocket;

public abstract class ServerSocketFactory
implements RMIServerSocketFactory {
    static boolean DEBUG_ASYNC_ONLY = false;
    private static final Socket CLOSED_MARKER_SOCKET = new NullSocket();
    private final AtomicInteger socketCount = new AtomicInteger(0);
    protected final int backlog;
    protected final int startPort;
    protected final int endPort;
    private int currentPort;
    private final int rangeSize;
    protected Logger connectionLogger;

    protected ServerSocketFactory(int backlog, int startPort, int endPort) {
        if (endPort < startPort) {
            throw new IllegalArgumentException("End port " + endPort + " must be >= startPort " + startPort);
        }
        this.backlog = backlog;
        this.startPort = startPort;
        this.endPort = endPort;
        this.currentPort = startPort;
        this.rangeSize = this.isUnconstrained() ? Integer.MAX_VALUE : endPort - startPort + 1;
    }

    @Override
    public final ServerSocket createServerSocket(int port) throws IOException {
        if (DEBUG_ASYNC_ONLY && !AsyncRegistryUtils.serverUseAsync) {
            throw new IllegalStateException("Async not enabled");
        }
        ServerSocket ss = !AsyncRegistryUtils.serverUseAsync ? this.createStandardServerSocket(port) : this.createAsyncServerSocket(port);
        this.socketCount.incrementAndGet();
        return ss;
    }

    public int getSocketCount() {
        return this.socketCount.get();
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setConnectionLogger(Logger logger) {
        this.connectionLogger = logger;
    }

    public Logger getConnectionLogger() {
        return this.connectionLogger;
    }

    public ListenerConfig getListenerConfig() {
        return this.getListenerConfigBuilder(0).build();
    }

    public abstract ServerSocketFactory newInstance(int var1);

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.backlog;
        result = 31 * result + this.endPort;
        result = 31 * result + this.startPort;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerSocketFactory)) {
            return false;
        }
        ServerSocketFactory other = (ServerSocketFactory)obj;
        if (this.backlog != other.backlog) {
            return false;
        }
        if (this.startPort != other.startPort) {
            return false;
        }
        return this.endPort == other.endPort;
    }

    protected abstract ServerSocket instantiateServerSocket(int var1) throws IOException;

    public abstract ServerSocket preallocateServerSocket() throws IOException;

    public abstract void discardServerSocket(ServerSocket var1);

    protected abstract ServerSocket createAsyncServerSocket(int var1) throws IOException;

    protected boolean isUnconstrained() {
        return this.startPort == 0 && this.endPort == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServerSocket createStandardServerSocket(int port) throws IOException {
        if (port != 0 || this.isUnconstrained()) {
            return this.instantiateServerSocket(port);
        }
        for (int portCount = this.rangeSize; portCount > 0; --portCount) {
            try {
                ServerSocket serverSocket = this.instantiateServerSocket(this.currentPort);
                return serverSocket;
            }
            catch (IOException iOException) {
                continue;
            }
            finally {
                this.currentPort = this.currentPort == this.endPort ? this.startPort : ++this.currentPort;
            }
        }
        throw new IOException("No free ports in the range: " + this.startPort + "," + this.endPort);
    }

    protected ListenerConfigBuilder getListenerConfigBuilder(int port) {
        return new ListenerConfigBuilder().portRange(this.getPortRange(port)).option(AsyncOption.SSO_BACKLOG, (Object)this.backlog);
    }

    protected void forceCloseSocket(Socket socket) {
        block2: {
            try {
                socket.close();
            }
            catch (IOException ioe) {
                if (this.connectionLogger == null) break block2;
                this.connectionLogger.info("Exception closing socket: " + ioe);
            }
        }
    }

    private ListenerPortRange getPortRange(int port) {
        if (port != 0) {
            return new ListenerPortRange(port, port);
        }
        if (this.startPort == 0 && this.endPort == 0) {
            return new ListenerPortRange();
        }
        return new ListenerPortRange(this.startPort, this.endPort);
    }

    private ListenerPortRange uniqueAnonymousPortRange() {
        if (this.startPort == 0 && this.endPort == 0) {
            return new UniqueAnonymousPortRange();
        }
        return new UniqueAnonymousPortRange(this.startPort, this.endPort);
    }

    private static class UniqueAnonymousPortRange
    extends ListenerPortRange {
        UniqueAnonymousPortRange() {
        }

        UniqueAnonymousPortRange(int startPort, int endPort) {
            super(startPort, endPort);
        }

        @Override
        public boolean equals(Object o) {
            return o == this;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public String toString() {
            return super.toString() + ";unique=" + this.hashCode();
        }
    }

    protected abstract class AsyncServerSocket
    extends NullServerSocket
    implements SocketPrepared {
        private final EndpointGroup.ListenHandle listenHandle;
        private final NetworkAddress localAddress;
        protected final AcceptQueue acceptQueue;
        protected final Object closeLock;
        protected boolean closed;

        protected AsyncServerSocket(int port) throws IOException {
            EndpointGroup.ListenHandle lh;
            this.acceptQueue = new AcceptQueue();
            this.closeLock = new Object();
            EndpointGroup endpointGroup = AsyncRegistryUtils.getEndpointGroup();
            ListenerConfigBuilder configBuilder = ServerSocketFactory.this.getListenerConfigBuilder(port);
            try {
                lh = endpointGroup.listen(configBuilder.build(), this);
            }
            catch (IllegalStateException e) {
                if (port != 0) {
                    throw e;
                }
                configBuilder.portRange(ServerSocketFactory.this.uniqueAnonymousPortRange());
                lh = endpointGroup.listen(configBuilder.build(), this);
            }
            this.listenHandle = lh;
            this.localAddress = this.listenHandle.getLocalAddress();
        }

        @Override
        public Socket accept() throws IOException {
            return this.acceptQueue.accept();
        }

        @Override
        public int getLocalPort() {
            return this.localAddress.getPort();
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.localAddress + "]";
        }

        @Override
        public void close() throws IOException {
            this.close(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close(Throwable exception) throws IOException {
            Object object = this.closeLock;
            synchronized (object) {
                if (!this.closed) {
                    this.listenHandle.shutdown(true);
                    this.acceptQueue.close(exception);
                }
                this.closed = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isClosed() {
            Object object = this.closeLock;
            synchronized (object) {
                return this.closed;
            }
        }

        @Override
        public void onChannelError(ListenerConfig config, Throwable exception, boolean channelClosed) {
            if (channelClosed) {
                try {
                    this.close(exception);
                }
                catch (IOException iOException) {}
            } else {
                this.acceptQueue.noteException(exception);
            }
        }
    }

    protected class AcceptQueue {
        private final BlockingQueue<Object> queue;
        private volatile boolean closed;
        private volatile IOException closedCause;

        public AcceptQueue() {
            this.queue = new ArrayBlockingQueue<Object>(ServerSocketFactory.this.backlog > 0 ? ServerSocketFactory.this.backlog : 50);
        }

        public boolean offer(Socket socket) {
            return this.queue.offer(socket);
        }

        public void noteException(Throwable exception) {
            if (!this.queue.offer(exception) && ServerSocketFactory.this.connectionLogger != null) {
                ServerSocketFactory.this.connectionLogger.log(Level.FINE, "Ignored accept exception because accept queue is full: {0}", exception);
            }
        }

        public Socket accept() throws IOException {
            try {
                Object item = null;
                if (!this.closed) {
                    item = this.queue.take();
                }
                if (this.closed) {
                    this.queue.offer(CLOSED_MARKER_SOCKET);
                    IOException ioe = this.closedCause;
                    if (ioe != null) {
                        throw ioe;
                    }
                    throw new SocketException("Server socket is closed");
                }
                if (item instanceof Socket) {
                    return (Socket)item;
                }
                if (item instanceof IOException) {
                    throw (IOException)item;
                }
                if (item instanceof RuntimeException) {
                    throw (RuntimeException)item;
                }
                if (item instanceof Error) {
                    throw (Error)item;
                }
                if (item instanceof Throwable) {
                    throw new IllegalStateException("Unexpected exception: " + item, (Throwable)item);
                }
                throw new IllegalStateException("Unexpected item in accept queue: " + item);
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException("Accept was interrupted");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close(Throwable cause) throws IOException {
            Object item;
            AcceptQueue acceptQueue = this;
            synchronized (acceptQueue) {
                if (this.closed) {
                    if (this.closedCause != null) {
                        throw this.closedCause;
                    }
                    return;
                }
                this.closed = true;
                this.closedCause = cause == null ? null : (cause instanceof IOException ? (IOException)cause : new IOException("Server socket closed: " + cause, cause));
            }
            while ((item = this.queue.poll()) != null) {
                if (item != CLOSED_MARKER_SOCKET) continue;
                this.queue.add(item);
                break;
            }
        }
    }
}

