/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import java.util.Map;
import org.eclipse.persistence.internal.sessions.factories.XMLSessionConfigProject_11_1_1;
import org.eclipse.persistence.internal.sessions.factories.model.SessionConfigs;
import org.eclipse.persistence.internal.xr.XRSessionsFactory;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;
import org.w3c.dom.Document;

public class XRSessionConfigLoader
extends XMLSessionConfigLoader {
    public XRSessionConfigLoader(String resourceName) {
        super(resourceName);
    }

    @Override
    public boolean load(SessionManager sessionManager, ClassLoader loader) {
        Document document = this.loadDocument(loader);
        if (this.getExceptionStore().isEmpty() && document.getDocumentElement().getTagName().equals("sessions")) {
            XMLContext context = new XMLContext(new XMLSessionConfigProject_11_1_1());
            XMLUnmarshaller unmarshaller = context.createUnmarshaller();
            SessionConfigs configs = (SessionConfigs)unmarshaller.unmarshal(document);
            XRSessionsFactory factory = new XRSessionsFactory();
            Map<String, Session> sessions = factory.buildSessionConfigs(configs, loader);
            for (Map.Entry<String, Session> entry : sessions.entrySet()) {
                if (sessionManager.getSessions().containsKey(entry.getKey())) continue;
                sessionManager.addSession(entry.getKey(), entry.getValue());
            }
            return true;
        }
        return false;
    }
}

