/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sequencing.DefaultSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.tools.schemaframework.IndexDefinition;
import org.eclipse.persistence.tools.schemaframework.SequenceDefinition;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class TableSequenceDefinition
extends SequenceDefinition {
    protected TableDefinition tableDefinition;
    protected boolean deleteSchema;
    private String sequenceCounterFieldName;
    private String sequenceNameFieldName;
    private List<IndexDefinition> sequenceTableIndexes;
    private String sequenceTableName;
    private String sequenceTableQualifier;

    @Deprecated(forRemoval=true, since="4.0.9")
    public TableSequenceDefinition(Sequence sequence, boolean deleteSchema) {
        super(sequence);
        this.deleteSchema = deleteSchema;
    }

    public TableSequenceDefinition(String name, boolean deleteSchema) {
        super(name);
        this.deleteSchema = deleteSchema;
    }

    @Override
    @Deprecated(forRemoval=true, since="4.0.9")
    public Writer buildCreationWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            writer.write("INSERT INTO ");
            writer.write(this.getSequenceTableQualifiedName());
            writer.write("(" + this.getSequenceNameFieldName());
            writer.write(", " + this.getSequenceCounterFieldName());
            writer.write(") values (");
            writer.write("'" + this.getName() + "', " + (this.getInitialValue() - 1) + ")");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    @Override
    @Deprecated(forRemoval=true, since="4.0.9")
    public Writer buildDeletionWriter(AbstractSession session, Writer writer) throws ValidationException {
        if (this.shouldDropTableDefinition()) {
            return this.tableDefinition.buildDeletionWriter(session, writer);
        }
        try {
            writer.write("DELETE FROM ");
            writer.write(this.getSequenceTableQualifiedName());
            writer.write(" WHERE " + this.getSequenceNameFieldName());
            writer.write(" = '" + this.getName() + "'");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    @Override
    @Deprecated(forRemoval=true, since="4.0.9")
    public boolean checkIfExist(AbstractSession session) throws DatabaseException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SELECT * FROM ");
        buffer.append(this.getSequenceTableQualifiedName());
        buffer.append(" WHERE ");
        buffer.append(this.getSequenceNameFieldName());
        buffer.append(" = '");
        buffer.append(this.getName());
        buffer.append("'");
        Vector results = session.priviledgedExecuteSelectingCall(new SQLCall(buffer.toString()));
        return !results.isEmpty();
    }

    @Override
    @Deprecated(forRemoval=true, since="4.0.9")
    public void dropDatabaseSchema(AbstractSession session, Writer writer) throws EclipseLinkException {
        this.tableDefinition.dropDatabaseSchema(session, writer);
    }

    @Override
    @Deprecated(forRemoval=true, since="4.0.9")
    public void dropDatabaseSchemaOnDatabase(AbstractSession session) throws EclipseLinkException {
        this.tableDefinition.dropDatabaseSchemaOnDatabase(session);
    }

    @Override
    public String getDatabaseSchema() {
        return this.sequenceTableQualifier;
    }

    public String getSequenceCounterFieldName() {
        return this.sequenceCounterFieldName;
    }

    public String getSequenceNameFieldName() {
        return this.sequenceNameFieldName;
    }

    @Deprecated(forRemoval=true, since="4.0.9")
    public DatabaseTable getSequenceTable() {
        return this.getTableSequence().getTable();
    }

    public List<IndexDefinition> getSequenceTableIndexes() {
        if (this.sequenceTableIndexes == null) {
            this.sequenceTableIndexes = new ArrayList<IndexDefinition>();
        }
        return this.sequenceTableIndexes;
    }

    public String getSequenceTableName() {
        return this.sequenceTableName;
    }

    public String getSequenceTableQualifier() {
        return this.sequenceTableQualifier;
    }

    public String getSequenceTableQualifiedName() {
        return this.getSequenceTableQualifier().isBlank() ? this.getSequenceTableName() : this.getSequenceTableQualifier() + "." + this.getSequenceTableName();
    }

    @Override
    public TableDefinition buildTableDefinition() {
        if (this.tableDefinition == null) {
            this.tableDefinition = new TableDefinition(){

                @Override
                public String getDatabaseSchema() {
                    return this.getQualifier();
                }
            };
            this.tableDefinition.setName(this.getSequenceTableName());
            this.tableDefinition.setQualifier(this.getSequenceTableQualifier());
            this.tableDefinition.addPrimaryKeyField(this.getSequenceNameFieldName(), String.class, 50);
            this.tableDefinition.addField(this.getSequenceCounterFieldName(), BigDecimal.class);
            this.tableDefinition.setIndexes(this.getSequenceTableIndexes());
        }
        return this.tableDefinition;
    }

    @Deprecated(forRemoval=true, since="4.0.9")
    protected TableSequence getTableSequence() {
        if (this.sequence.isTable()) {
            return (TableSequence)this.sequence;
        }
        return (TableSequence)((DefaultSequence)this.sequence).getDefaultSequence();
    }

    @Override
    public boolean isTableSequenceDefinition() {
        return true;
    }

    @Override
    @Deprecated(forRemoval=true, since="4.0.9")
    public void preDropObject(AbstractSession session, Writer dropSchemaWriter, boolean createSQLFiles) {
        if (session.getPlatform().shouldCreateIndicesForPrimaryKeys() || session.getPlatform().shouldCreateIndicesOnUniqueKeys()) {
            return;
        }
        this.buildTableDefinition().preDropObject(session, dropSchemaWriter, createSQLFiles);
    }

    public void setSequenceCounterFieldName(String sequenceCounterFieldName) {
        this.sequenceCounterFieldName = sequenceCounterFieldName;
    }

    public void setSequenceNameFieldName(String sequenceNameFieldName) {
        this.sequenceNameFieldName = sequenceNameFieldName;
    }

    public void setSequenceTableIndexes(List<IndexDefinition> sequenceTableIndexes) {
        this.sequenceTableIndexes = sequenceTableIndexes;
    }

    public void setSequenceTableName(String sequenceTableName) {
        this.sequenceTableName = sequenceTableName;
    }

    public void setSequenceTableQualifier(String sequenceTableQualifier) {
        this.sequenceTableQualifier = sequenceTableQualifier;
    }

    protected boolean shouldDropTableDefinition() {
        return this.deleteSchema && this.hasDatabaseSchema();
    }
}

