/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.buttonkit;

import java.io.IOException;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.internal.widgets.buttonkit.ButtonDelegateLCA;
import org.eclipse.swt.internal.widgets.buttonkit.ButtonLCAUtil;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

final class PushButtonDelegateLCA
extends ButtonDelegateLCA {
    private static final String QX_TYPE = "org.eclipse.rwt.widgets.Button";
    private static final Object[] PARAM_PUSH = new Object[]{"push"};
    private static final Object[] PARAM_TOGGLE = new Object[]{"toggle"};
    static final String PROP_DEFAULT = "defaultButton";

    PushButtonDelegateLCA() {
    }

    void preserveValues(Button button) {
        ButtonLCAUtil.preserveValues(button);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)button);
        adapter.preserve(PROP_DEFAULT, (Object)PushButtonDelegateLCA.isDefaultButton(button));
    }

    void readData(Button button) {
        ControlLCAUtil.processSelection((Widget)button, null, false);
        ButtonLCAUtil.readSelection(button);
        ControlLCAUtil.processMouseEvents((Control)button);
        ControlLCAUtil.processKeyEvents((Control)button);
        ControlLCAUtil.processMenuDetect((Control)button);
        WidgetLCAUtil.processHelp((Widget)button);
    }

    void renderInitialization(Button button) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)button);
        boolean isToggle = (button.getStyle() & 2) != 0;
        Object[] args = isToggle ? PARAM_TOGGLE : PARAM_PUSH;
        writer.newWidget(QX_TYPE, args);
        ControlLCAUtil.writeStyleFlags((Control)button);
        WidgetLCAUtil.writeStyleFlag((Widget)button, 8, "PUSH");
        WidgetLCAUtil.writeStyleFlag((Widget)button, 0x800000, "FLAT");
        WidgetLCAUtil.writeStyleFlag((Widget)button, 2, "TOGGLE");
        ButtonLCAUtil.writeWrap(button);
    }

    void renderChanges(Button button) throws IOException {
        ButtonLCAUtil.writeChanges(button);
        PushButtonDelegateLCA.writeDefault(button);
    }

    static void writeDefault(Button button) throws IOException {
        boolean isDefault = PushButtonDelegateLCA.isDefaultButton(button);
        Boolean defValue = Boolean.FALSE;
        Boolean actValue = isDefault;
        if (WidgetLCAUtil.hasChanged((Widget)button, PROP_DEFAULT, actValue, defValue) && isDefault) {
            JSWriter writer = JSWriter.getWriterFor((Widget)button.getShell());
            writer.set(PROP_DEFAULT, new Object[]{button});
        }
    }

    static boolean isDefaultButton(Button button) {
        return button.getShell().getDefaultButton() == button;
    }
}

