/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.resource;

import java.io.IOException;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.sirius.business.api.migration.ResourceVersionMismatchDiagnostic;
import org.eclipse.sirius.business.api.session.resource.AirdResource;
import org.eclipse.sirius.business.api.session.resource.DResource;
import org.eclipse.sirius.business.internal.migration.RepresentationsFileExtendedMetaData;
import org.eclipse.sirius.business.internal.migration.RepresentationsFileMigrationService;
import org.eclipse.sirius.business.internal.migration.RepresentationsFileResourceHandler;
import org.eclipse.sirius.business.internal.migration.RepresentationsFileVersionSAXParser;
import org.eclipse.sirius.business.internal.migration.resource.MigrationUtil;
import org.eclipse.sirius.business.internal.resource.AirdResourceXMILoad;
import org.eclipse.sirius.business.internal.resource.parser.RepresentationsFileXMIHelper;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.Messages;
import org.eclipse.sirius.tools.api.profiler.SiriusTasksKey;
import org.eclipse.sirius.viewpoint.IdentifiedElement;
import org.osgi.framework.Version;

public class AirDResourceImpl
extends XMIResourceImpl
implements DResource,
AirdResource {
    public static final String OPTION_ABORT_ON_ERROR = "ABORT_ON_ERROR";
    private static ThreadLocal<Integer> nbLoadInProgress = new ThreadLocal<Integer>(){

        @Override
        protected synchronized Integer initialValue() {
            return 0;
        }
    };

    public AirDResourceImpl(URI uri) {
        super(uri);
    }

    protected boolean useUUIDs() {
        return true;
    }

    protected boolean useIDAttributes() {
        return false;
    }

    protected void attachedHelper(EObject eObject) {
        if (eObject instanceof IdentifiedElement) {
            IdentifiedElement idElem = (IdentifiedElement)eObject;
            String uid = idElem.getUid();
            String cachedId = this.getID(eObject);
            if (uid == null) {
                throw new NullPointerException(Messages.AirDResourceImpl_nullUid);
            }
            if (cachedId == null || !this.isLoading && !cachedId.equals(uid)) {
                this.setID(eObject, uid);
            }
        }
        super.attachedHelper(eObject);
    }

    protected static void incrementLoadInProgress() {
        nbLoadInProgress.set(nbLoadInProgress.get() + 1);
    }

    protected static void decrementLoadInProgress() {
        nbLoadInProgress.set(nbLoadInProgress.get() - 1);
    }

    protected static boolean hasLoadInProgress() {
        return nbLoadInProgress.get() != 0;
    }

    public void setTrackingModification(boolean isTrackingModification) {
    }

    public void load(Map<?, ?> options) throws IOException {
        if (!this.isLoaded) {
            DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.LOAD_AIRD_KEY);
            AirDResourceImpl.incrementLoadInProgress();
            try {
                Resource.Diagnostic migrationMismatchDiagnostic = this.handleMigrationOptions();
                super.load(options);
                if (migrationMismatchDiagnostic != null) {
                    this.getErrors().add((Object)migrationMismatchDiagnostic);
                }
            }
            finally {
                AirDResourceImpl.decrementLoadInProgress();
            }
            DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.LOAD_AIRD_KEY);
        }
    }

    private Resource.Diagnostic handleMigrationOptions() {
        ResourceVersionMismatchDiagnostic migrationMismatchDiagnostic = null;
        RepresentationsFileVersionSAXParser parser = new RepresentationsFileVersionSAXParser(this.uri);
        boolean migrationIsNeeded = true;
        String loadedVersion = parser.getVersion((IProgressMonitor)new NullProgressMonitor());
        if (loadedVersion != null) {
            boolean attemptToLoadMoreRecentVSM;
            Version parsedLoadedVersion = Version.parseVersion((String)loadedVersion);
            Version lastMigrationVersion = RepresentationsFileMigrationService.getInstance().getLastMigrationVersion();
            boolean bl = attemptToLoadMoreRecentVSM = lastMigrationVersion.compareTo(parsedLoadedVersion) < 0;
            if (attemptToLoadMoreRecentVSM && !MigrationUtil.ignoreVersionMismatch) {
                migrationMismatchDiagnostic = new ResourceVersionMismatchDiagnostic(this.uri, parsedLoadedVersion, lastMigrationVersion);
            }
            migrationIsNeeded = RepresentationsFileMigrationService.getInstance().isMigrationNeeded(parsedLoadedVersion);
        }
        Object versionOption = this.getDefaultLoadOptions().get("RESOURCE_MIGRATION_LOADEDVERSION");
        if (!migrationIsNeeded && versionOption != null) {
            this.removeMigrationMechanism();
        } else if (migrationIsNeeded && (versionOption == null || !versionOption.equals(loadedVersion))) {
            AirDResourceImpl.addMigrationOptions(loadedVersion, this.getDefaultLoadOptions(), this.getDefaultSaveOptions());
        }
        return migrationMismatchDiagnostic;
    }

    private void removeMigrationMechanism() {
        this.getDefaultLoadOptions().remove("EXTENDED_META_DATA");
        this.getDefaultLoadOptions().remove("RESOURCE_HANDLER");
        this.getDefaultLoadOptions().remove("RESOURCE_MIGRATION_LOADEDVERSION");
        this.getDefaultSaveOptions().remove("EXTENDED_META_DATA");
        this.getDefaultSaveOptions().remove("RESOURCE_HANDLER");
    }

    protected XMLHelper createXMLHelper() {
        return new RepresentationsFileXMIHelper((XMLResource)this);
    }

    protected XMLLoad createXMLLoad(Map<?, ?> options) {
        if (options != null && options.containsKey("RESOURCE_MIGRATION_LOADEDVERSION")) {
            String loadedVersion = null;
            Object mapVersion = options.get("RESOURCE_MIGRATION_LOADEDVERSION");
            if (mapVersion instanceof String) {
                loadedVersion = (String)mapVersion;
            }
            return new AirdResourceXMILoad(loadedVersion, this.createXMLHelper());
        }
        return new AirdResourceXMILoad(this.createXMLHelper());
    }

    public EObject getEObject(String uriFragment) {
        Option<String> optionalRewrittenFragment = RepresentationsFileMigrationService.getInstance().getNewFragment(uriFragment);
        if (optionalRewrittenFragment.some()) {
            return this.getEObject((String)optionalRewrittenFragment.get());
        }
        return super.getEObject(uriFragment);
    }

    public static void addMigrationOptions(String loadedVersion, Map<Object, Object> loadOptions, Map<Object, Object> saveOptions) {
        RepresentationsFileExtendedMetaData extendedMetaData = new RepresentationsFileExtendedMetaData(loadedVersion);
        RepresentationsFileResourceHandler resourceHandler = new RepresentationsFileResourceHandler(loadedVersion);
        loadOptions.put("EXTENDED_META_DATA", (Object)extendedMetaData);
        loadOptions.put("RESOURCE_HANDLER", (Object)resourceHandler);
        loadOptions.put("RESOURCE_MIGRATION_LOADEDVERSION", loadedVersion);
        saveOptions.put("EXTENDED_META_DATA", (Object)extendedMetaData);
        saveOptions.put("RESOURCE_HANDLER", (Object)resourceHandler);
    }
}

