/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.radial.sorting;

import java.util.Comparator;
import java.util.List;
import org.eclipse.elk.alg.radial.RadialUtil;
import org.eclipse.elk.alg.radial.options.RadialOptions;
import org.eclipse.elk.alg.radial.sorting.IDSorter;
import org.eclipse.elk.alg.radial.sorting.IRadialSorter;
import org.eclipse.elk.graph.ElkNode;

public class PolarCoordinateSorter
implements IRadialSorter {
    private static final double DEGREE_45 = 0.7853981633974483;
    private static final double DEGREE_90 = 1.5707963267948966;
    private static final double DEGREE_135 = 2.356194490192345;
    private static final double DEGREE_225 = 3.9269908169872414;
    private static final double DEGREE_270 = 4.71238898038469;
    private static final double DEGREE_315 = 5.497787143782138;
    private Comparator<ElkNode> compRight = RadialUtil.createPolarComparator(0.0, 0.0);
    private Comparator<ElkNode> compLeft = RadialUtil.createPolarComparator(Math.PI, 0.0);
    private Comparator<ElkNode> compTop = RadialUtil.createPolarComparator(4.71238898038469, 0.0);
    private Comparator<ElkNode> compBottom = RadialUtil.createPolarComparator(1.5707963267948966, 0.0);
    private IDSorter idSorter;

    @Override
    public void initialize(ElkNode root) {
        this.idSorter = new IDSorter();
        List<ElkNode> successors = RadialUtil.getSuccessors(root);
        successors.sort(this.compRight);
        this.setIDForNodes(successors, 0);
    }

    private int setIDForNodes(List<ElkNode> nodes, int idOffset) {
        int id = idOffset;
        int nextLayerId = 0;
        for (ElkNode node : nodes) {
            node.setProperty(RadialOptions.ORDER_ID, (Object)id++);
            List<ElkNode> nodeSuccessors = RadialUtil.getSuccessors(node);
            double arc = Math.atan2(node.getY() + node.getHeight() / 2.0, node.getX() + node.getWidth() / 2.0);
            double d = arc < 0.0 ? Math.PI * 2 : 0.0;
            if ((arc += d) < 0.7853981633974483 || arc > 5.497787143782138) {
                nodeSuccessors.sort(this.compLeft);
            } else if (arc <= 5.497787143782138 && arc > 3.9269908169872414) {
                nodeSuccessors.sort(this.compTop);
            } else if (arc <= 3.9269908169872414 && arc > 2.356194490192345) {
                nodeSuccessors.sort(this.compRight);
            } else if (arc <= 2.356194490192345) {
                nodeSuccessors.sort(this.compBottom);
            }
            nextLayerId = this.setIDForNodes(nodeSuccessors, nextLayerId);
        }
        return id;
    }

    @Override
    public void sort(List<ElkNode> nodes) {
        if (!nodes.isEmpty()) {
            if (this.idSorter == null) {
                ElkNode root = RadialUtil.findRootOfNode(nodes.get(0));
                this.initialize(root);
            }
            this.idSorter.sort(nodes);
        }
    }
}

