/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets;

import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.eef.EEFSelectDescription;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EefPackage;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.EEFControllersFactory;
import org.eclipse.eef.core.api.controllers.IEEFSelectController;
import org.eclipse.eef.core.api.controllers.IEEFWidgetController;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.eef.ide.ui.api.widgets.AbstractEEFWidgetLifecycleManager;
import org.eclipse.eef.ide.ui.internal.EEFIdeUiPlugin;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EEFSelectLifecycleManager
extends AbstractEEFWidgetLifecycleManager {
    private static final Object NO_VALUE = new Object(){

        public String toString() {
            return "<null>";
        }
    };
    private EEFSelectDescription description;
    private ComboViewer comboViewer;
    private Combo combo;
    private IEEFSelectController controller;
    private SelectionListener selectionListener;
    private ISelection referenceValue;

    public EEFSelectLifecycleManager(EEFSelectDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter editingContextAdapter) {
        super(variableManager, interpreter, editingContextAdapter);
        this.description = description;
    }

    @Override
    protected void createMainControl(Composite parent, IEEFFormContainer formContainer) {
        EEFWidgetFactory widgetFactory = formContainer.getWidgetFactory();
        this.comboViewer = new ComboViewer(parent, 8);
        this.combo = this.comboViewer.getCombo();
        GridData gridData = new GridData();
        gridData.horizontalIndent = 5;
        this.combo.setLayoutData((Object)gridData);
        this.comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new EEFSelectLabelProvider());
        this.comboViewer.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        widgetFactory.paintBordersFor(parent);
        this.controller = new EEFControllersFactory().createSelectController(this.description, this.variableManager, this.interpreter, this.editingContextAdapter);
    }

    @Override
    protected IEEFWidgetController getController() {
        return this.controller;
    }

    @Override
    protected EEFWidgetDescription getWidgetDescription() {
        return this.description;
    }

    @Override
    protected Control getValidationControl() {
        return this.combo;
    }

    @Override
    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!EEFSelectLifecycleManager.this.container.isRenderingInProgress()) {
                    IStatus result;
                    IStructuredSelection selection = EEFSelectLifecycleManager.this.getStructuredSelection((StructuredViewer)EEFSelectLifecycleManager.this.comboViewer);
                    Object newValue = selection.getFirstElement();
                    if (newValue == NO_VALUE) {
                        newValue = null;
                    }
                    if ((result = EEFSelectLifecycleManager.this.controller.updateValue(newValue)) != null && result.getSeverity() == 4) {
                        EEFIdeUiPlugin.INSTANCE.log(result);
                        EEFSelectLifecycleManager.this.comboViewer.setSelection(EEFSelectLifecycleManager.this.referenceValue);
                    } else {
                        EEFSelectLifecycleManager.this.refresh();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.combo.addSelectionListener(this.selectionListener);
        this.controller.onNewValue(value -> {
            if (!(this.combo.isDisposed() || this.combo.getText() != null && this.combo.getText().equals(value))) {
                StructuredSelection selection = value != null ? new StructuredSelection(value) : null;
                this.referenceValue = selection;
                this.comboViewer.setSelection(this.referenceValue, true);
                if (!this.combo.isEnabled()) {
                    this.combo.setEnabled(true);
                }
            }
        });
        this.controller.onNewCandidates(value -> {
            if (!this.combo.isDisposed()) {
                if (this.combo.getListVisible() && this.avoidUpdatingOpenedCombo()) {
                    return;
                }
                if (this.forceCloseToUpdateCombo()) {
                    this.combo.setListVisible(false);
                }
                if (value != null) {
                    Object[] candidates = value.toArray();
                    int i = 0;
                    while (i < candidates.length) {
                        if (candidates[i] == null) {
                            candidates[i] = NO_VALUE;
                        }
                        ++i;
                    }
                    this.comboViewer.setInput((Object)candidates);
                } else {
                    this.comboViewer.setInput(null);
                }
                if (!this.combo.isEnabled()) {
                    this.combo.setEnabled(true);
                }
            }
        });
    }

    private boolean avoidUpdatingOpenedCombo() {
        boolean win7 = "Windows7".equals(System.getProperty("org.osgi.framework.os.name"));
        return Boolean.valueOf(System.getProperty("org.eclipse.eef.avoidUpdatingOpenedCombo", Boolean.toString(win7)));
    }

    private boolean forceCloseToUpdateCombo() {
        return Boolean.valueOf(System.getProperty("org.eclipse.eef.forceCloseToUpdateCombo", Boolean.toString(false)));
    }

    @Override
    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        if (!this.combo.isDisposed()) {
            this.combo.removeSelectionListener(this.selectionListener);
        }
        this.controller.removeNewValueConsumer();
        this.controller.removeNewCandidatesConsumer();
    }

    @Override
    protected void setEnabled(boolean isEnabled) {
        if (!this.combo.isDisposed()) {
            this.combo.setEnabled(isEnabled);
        }
    }

    private final class EEFSelectLabelProvider
    extends LabelProvider {
        private EEFSelectLabelProvider() {
        }

        public String getText(Object element) {
            String expression = EEFSelectLifecycleManager.this.description.getCandidateDisplayExpression();
            EAttribute eAttribute = EefPackage.Literals.EEF_SELECT_DESCRIPTION__CANDIDATE_DISPLAY_EXPRESSION;
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put("self", EEFSelectLifecycleManager.this.variableManager.getVariables().get("self"));
            variables.put("input", EEFSelectLifecycleManager.this.variableManager.getVariables().get("input"));
            variables.put("candidate", element);
            return (String)EvalFactory.of((IInterpreter)EEFSelectLifecycleManager.this.interpreter, variables).logIfInvalidType(String.class).logIfBlank(eAttribute).evaluate(expression);
        }
    }
}

