/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.layout.flag;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbsoluteBoundsFilter;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.LostMessageEnd;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.layout.LayoutConstants;

public abstract class AbstractSequenceAbsoluteBoundsFlagger {
    public final void flag() {
        for (ISequenceElement ise : this.getEventsToFlag()) {
            this.flag(ise);
        }
    }

    private void flag(ISequenceElement ise) {
        EObject element = ise.getNotationView().getElement();
        if (element instanceof DDiagramElement) {
            DDiagramElement dde = (DDiagramElement)element;
            Rectangle absBounds = ise.getProperLogicalBounds();
            AbsoluteBoundsFilter flag = this.getOrCreateFlag(dde);
            if (ise instanceof LostMessageEnd && !((LostMessageEnd)ise).getMessage().some()) {
                flag.setX(Integer.valueOf(LayoutConstants.TOOL_CREATION_FLAG_FROM_SEMANTIC.x));
            }
            if (flag != null && absBounds != null) {
                if (ise instanceof Message) {
                    flag.setX((Integer)DiagramPackage.eINSTANCE.getAbsoluteBoundsFilter_X().getDefaultValue());
                    flag.setWidth((Integer)DiagramPackage.eINSTANCE.getAbsoluteBoundsFilter_Width().getDefaultValue());
                } else {
                    flag.setX(Integer.valueOf(absBounds.x));
                    flag.setWidth(Integer.valueOf(absBounds.width));
                }
                flag.setY(Integer.valueOf(absBounds.y));
                flag.setHeight(Integer.valueOf(absBounds.height));
            }
        }
    }

    protected abstract Collection<ISequenceElement> getEventsToFlag();

    private AbsoluteBoundsFilter getOrCreateFlag(DDiagramElement dde) {
        AbsoluteBoundsFilter flag = null;
        ArrayList flags = Lists.newArrayList((Iterable)Iterables.filter((Iterable)dde.getGraphicalFilters(), AbsoluteBoundsFilter.class));
        Iterator iterator = flags.iterator();
        if (iterator.hasNext()) {
            AbsoluteBoundsFilter prevFlag;
            flag = prevFlag = (AbsoluteBoundsFilter)iterator.next();
        }
        if (flag == null) {
            flag = DiagramFactory.eINSTANCE.createAbsoluteBoundsFilter();
            dde.getGraphicalFilters().add((Object)flag);
        }
        return flag;
    }
}

