/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.action;

import com.google.common.base.Preconditions;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.action.AbstractExternalJavaAction;
import org.eclipse.sirius.tools.api.Messages;

public class MoveElementInListAction
extends AbstractExternalJavaAction {
    @Override
    public boolean canExecute(Collection<? extends EObject> selections) {
        return selections.size() == 1;
    }

    @Override
    public void execute(Collection<? extends EObject> selections, Map<String, Object> parameters) {
        EStructuralFeature feature;
        EObject element = this.getParameter(parameters, "element", EObject.class);
        EObject owner = this.getParameter(parameters, "referenceOwner", EObject.class);
        String refName = this.getParameter(parameters, "referenceName", String.class);
        EObject pred = this.getOptionalParameter(parameters, "predecessor", EObject.class);
        if (pred != null) {
            Preconditions.checkArgument((element != pred ? 1 : 0) != 0, (Object)Messages.MoveElementInListAction_elementAndPredecessorShouldBeDiffErrorMsg);
        }
        Preconditions.checkArgument(((feature = owner.eClass().getEStructuralFeature(refName)) != null ? 1 : 0) != 0, (Object)MessageFormat.format(Messages.MoveElementInListAction_featureNotFoundErrorMsg, owner.eClass().getName(), refName));
        String qName = feature.getEContainingClass().getName() + "." + feature.getName();
        Preconditions.checkArgument((boolean)(feature instanceof EReference), (Object)MessageFormat.format(Messages.MoveElementInListAction_notARefErrorMsg, qName));
        Preconditions.checkArgument((boolean)feature.isMany(), (Object)MessageFormat.format(Messages.MoveElementInListAction_notMultiValuedRefErrorMsg, qName));
        Preconditions.checkArgument((boolean)feature.isChangeable(), (Object)MessageFormat.format(Messages.MoveElementInListAction_referenceNotChangeableErrorMsg, qName));
        EList list = (EList)owner.eGet(feature);
        Preconditions.checkArgument((pred == null || list.contains((Object)pred) ? 1 : 0) != 0, (Object)Messages.MoveElementInListAction_predecessorParameterErrorMsg);
        Preconditions.checkArgument((boolean)list.contains((Object)element), (Object)Messages.MoveElementInListAction_notAMemberErrorMsg);
        this.moveElementAfter(element, pred, (EList<EObject>)list);
    }

    public void moveElementAfter(EObject element, EObject pred, EList<EObject> list) {
        if (pred == null) {
            list.move(0, (Object)element);
        } else {
            int predIndex;
            int thisIndex = list.indexOf((Object)element);
            if (thisIndex > (predIndex = list.indexOf((Object)pred))) {
                list.move(predIndex + 1, (Object)element);
            } else {
                list.move(predIndex, (Object)element);
            }
        }
    }
}

