/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.api.helper.graphicalfilters;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.sirius.diagram.AppliedCompositeFilters;
import org.eclipse.sirius.diagram.CollapseFilter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.business.api.diagramtype.ICollapseUpdater;
import org.eclipse.sirius.diagram.business.api.helper.filter.FilterService;
import org.eclipse.sirius.diagram.business.api.query.CompositeFilterDescriptionQuery;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.description.filter.CompositeFilterDescription;
import org.eclipse.sirius.diagram.ui.business.api.helper.graphicalfilters.CollapseUpdater;
import org.eclipse.sirius.ext.base.Option;

public class CompositeFilterApplicationBuilder {
    private DDiagram diagram;

    public CompositeFilterApplicationBuilder(DDiagram diagram) {
        this.diagram = diagram;
    }

    public void computeCompositeFilterApplications() {
        ICollapseUpdater collapseUpdater = CollapseUpdater.getICollapseUpdater(this.diagram);
        for (DDiagramElement element : this.diagram.getDiagramElements()) {
            ArrayList appliedHideFilters = Lists.newArrayList((Iterable)Iterables.filter((Iterable)FilterService.getAppliedFilters((DDiagram)this.diagram, (DDiagramElement)element), CompositeFilterDescription.class));
            this.handleHideCompositeFilters(element, appliedHideFilters);
            boolean isDirectlycollapsed = FilterService.isCollapsed((DDiagram)this.diagram, (DDiagramElement)element);
            this.handleCollapseCompositeFilters(element, isDirectlycollapsed, collapseUpdater);
        }
    }

    private void handleCollapseCompositeFilters(DDiagramElement element, boolean isDirectlycollapsed, ICollapseUpdater collapseUpdater) {
        DDiagramElementQuery elementQuery = new DDiagramElementQuery(element);
        if (elementQuery.isCollapsed()) {
            this.updateCollapseApplication(element, isDirectlycollapsed, collapseUpdater);
        } else if (isDirectlycollapsed) {
            this.createCollapseApplication(element, collapseUpdater);
        }
    }

    private void handleHideCompositeFilters(DDiagramElement element, List<CompositeFilterDescription> appliedFilters) {
        DDiagramElementQuery elementQuery = new DDiagramElementQuery(element);
        Iterable appliedHideFilters = Iterables.filter(appliedFilters, (Predicate)new IsHideFilter());
        Option appliedCompositeFilters = elementQuery.getAppliedCompositeFilters();
        if (appliedCompositeFilters.some()) {
            this.updateFilterApplication(element, (AppliedCompositeFilters)appliedCompositeFilters.get(), Lists.newArrayList((Iterable)appliedHideFilters));
        } else if (!Iterables.isEmpty((Iterable)appliedHideFilters)) {
            this.createFilterApplication(element, Lists.newArrayList((Iterable)appliedHideFilters));
        }
    }

    private void createCollapseApplication(DDiagramElement element, ICollapseUpdater collapseUpdater) {
        if (element != null) {
            collapseUpdater.synchronizeCollapseFiltersAndGMFBounds(element, true, CollapseFilter.class);
        }
    }

    private void updateCollapseApplication(DDiagramElement element, boolean isDirectlycollapsed, ICollapseUpdater collapseUpdater) {
        if (element != null && !isDirectlycollapsed) {
            collapseUpdater.synchronizeCollapseFiltersAndGMFBounds(element, false, CollapseFilter.class);
        }
    }

    private void createFilterApplication(DDiagramElement element, List<CompositeFilterDescription> appliedFilters) {
        if (element != null && appliedFilters != null && !appliedFilters.isEmpty()) {
            AppliedCompositeFilters filterApplication = DiagramFactory.eINSTANCE.createAppliedCompositeFilters();
            filterApplication.getCompositeFilterDescriptions().addAll(appliedFilters);
            element.getGraphicalFilters().add((Object)filterApplication);
        }
    }

    private void updateFilterApplication(DDiagramElement element, AppliedCompositeFilters filterApplication, List<CompositeFilterDescription> appliedFilters) {
        if (element != null && filterApplication != null && appliedFilters != null) {
            if (appliedFilters.isEmpty()) {
                element.getGraphicalFilters().remove((Object)filterApplication);
            } else {
                ArrayList filterToAdd = Lists.newArrayList(appliedFilters);
                Iterables.removeAll((Iterable)filterToAdd, (Collection)filterApplication.getCompositeFilterDescriptions());
                ArrayList filterToRemove = Lists.newArrayList((Iterable)filterApplication.getCompositeFilterDescriptions());
                Iterables.removeAll((Iterable)filterToRemove, appliedFilters);
                filterApplication.getCompositeFilterDescriptions().removeAll((Collection)filterToRemove);
                filterApplication.getCompositeFilterDescriptions().addAll((Collection)filterToAdd);
            }
        }
    }

    private static final class IsHideFilter
    implements Predicate<CompositeFilterDescription> {
        private IsHideFilter() {
        }

        public boolean apply(CompositeFilterDescription input) {
            return new CompositeFilterDescriptionQuery(input).isHideCompositeFilter();
        }
    }
}

