/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.properties;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.AdvancedPropertySection;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.internal.properties.ExtendedPropertySource;
import org.eclipse.sirius.ui.tools.api.properties.SiriusExtensiblePropertySource;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class ExtensionSemanticPropertiesSection
extends AdvancedPropertySection
implements IPropertySourceProvider {
    private List<Object> transformedSelection;
    private IWorkbenchPart part;

    public IPropertySource getPropertySource(Object object) {
        IPropertySource propertySrc = null;
        AdapterFactory adapterFactory = this.getAdapterFactory(object);
        if (object instanceof IPropertySource) {
            propertySrc = (IPropertySource)object;
        } else if (object instanceof DSemanticDecorator) {
            propertySrc = new ExtendedPropertySource((DSemanticDecorator)object, adapterFactory);
        } else {
            IItemPropertySource ips;
            if (adapterFactory != null && (ips = (IItemPropertySource)adapterFactory.adapt(object, IItemPropertySource.class)) != null) {
                propertySrc = new SiriusExtensiblePropertySource(object, ips);
            }
            if (propertySrc == null && object instanceof IAdaptable) {
                propertySrc = (IPropertySource)((IAdaptable)object).getAdapter(IPropertySource.class);
            }
        }
        return propertySrc;
    }

    protected AdapterFactory getAdapterFactory(Object object) {
        AdapterFactory adapterFactory = null;
        if (object != null) {
            adapterFactory = this.part instanceof DDiagramEditor ? ((DDiagramEditor)this.part).getAdapterFactory() : DiagramUIPlugin.getPlugin().getItemProvidersAdapterFactory();
        }
        return adapterFactory;
    }

    protected IPropertySourceProvider getPropertySourceProvider() {
        return this;
    }

    public void setInput(IWorkbenchPart workbenchPart, ISelection selection) {
        this.part = workbenchPart;
        if (selection.isEmpty() || !(selection instanceof StructuredSelection)) {
            super.setInput(workbenchPart, selection);
            return;
        }
        StructuredSelection structuredSelection = (StructuredSelection)selection;
        this.transformedSelection = new ArrayList<Object>(structuredSelection.size());
        Iterator it = structuredSelection.iterator();
        while (it.hasNext()) {
            Object r = this.transformSelection(it.next());
            if (r == null) continue;
            this.transformedSelection.add(r);
        }
        super.setInput(workbenchPart, (ISelection)new StructuredSelection(this.transformedSelection));
    }

    protected Object transformSelection(Object selected) {
        View view;
        Object dElement = selected;
        if (selected instanceof EditPart) {
            EObject element;
            Object model = ((EditPart)selected).getModel();
            if (model instanceof View && (element = ((View)model).getElement()) instanceof DSemanticDecorator) {
                dElement = element;
            }
        } else if (selected instanceof View) {
            if (((View)selected).getElement() instanceof DSemanticDecorator) {
                dElement = ((View)selected).getElement();
            }
        } else if (selected instanceof IAdaptable && (view = (View)((IAdaptable)selected).getAdapter(View.class)) != null && view.getElement() instanceof DSemanticDecorator) {
            dElement = view.getElement();
        }
        return dElement;
    }

    public void refresh() {
        if (this.transformedSelection != null) {
            Iterator<Object> inputs = this.transformedSelection.iterator();
            boolean isValid = true;
            while (inputs.hasNext() && isValid) {
                Resource resource;
                Object input = inputs.next();
                if (!(input instanceof DSemanticDecorator) || (resource = ((DSemanticDecorator)input).eResource()) != null && resource.getResourceSet() != null) continue;
                isValid = false;
            }
            if (!isValid) {
                this.setInput(this.part, (ISelection)StructuredSelection.EMPTY);
            }
        }
        super.refresh();
    }
}

