/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.core.liqp.filters;

import org.eclipse.embedcdt.core.liqp.filters.Filter;

class Truncatewords
extends Filter {
    Truncatewords() {
    }

    @Override
    public Object apply(Object value, Object ... params) {
        if (value == null) {
            return "";
        }
        String text = super.asString(value);
        String[] words = text.split("\\s++");
        int length = 15;
        String truncateString = "...";
        if (params.length >= 1) {
            length = super.asNumber(super.get(0, params)).intValue();
        }
        if (params.length >= 2) {
            truncateString = super.asString(super.get(1, params));
        }
        if (length >= words.length) {
            return text;
        }
        return String.valueOf(this.join(words, length)) + truncateString;
    }

    private String join(String[] words, int length) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < length) {
            builder.append(words[i]).append(" ");
            ++i;
        }
        return builder.toString().trim();
    }
}

