/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.eclipse.swt.internal.DPIZoomChangeHandler;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public class DPIZoomChangeRegistry {
    private static Map<Class<? extends Widget>, DPIZoomChangeHandler> dpiZoomChangeHandlers = new ConcurrentSkipListMap<Class<? extends Widget>, DPIZoomChangeHandler>((o1, o2) -> {
        if (o1.isAssignableFrom((Class<?>)o2)) {
            return -1;
        }
        if (o2.isAssignableFrom((Class<?>)o1)) {
            return 1;
        }
        return o1.getName().compareTo(o2.getName());
    });

    public static void applyChange(Widget widget, int newZoom, float scalingFactor) {
        if (widget == null) {
            return;
        }
        for (Map.Entry<Class<? extends Widget>, DPIZoomChangeHandler> entry : dpiZoomChangeHandlers.entrySet()) {
            Class<? extends Widget> clazz = entry.getKey();
            DPIZoomChangeHandler handler = entry.getValue();
            if (!clazz.isInstance(widget)) continue;
            handler.handleDPIChange(widget, newZoom, scalingFactor);
        }
        Event event = new Event();
        event.type = 55;
        event.widget = widget;
        event.detail = newZoom;
        event.doit = true;
        widget.notifyListeners(55, event);
    }

    public static void registerHandler(DPIZoomChangeHandler zoomChangeVisitor, Class<? extends Widget> clazzToRegisterFor) {
        dpiZoomChangeHandlers.put(clazzToRegisterFor, zoomChangeVisitor);
    }
}

