/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.osview;

import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.service.IGDBHardwareAndOS2;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ResourceClassContributionItem
extends ContributionItem {
    private static final int COMBO_TRIM_WIDTH = 64;
    private Combo fResourceClassCombo;
    private IGDBHardwareAndOS2.IResourceClass[] resourceClasses = new IGDBHardwareAndOS2.IResourceClass[0];
    private String fResourceClassId = null;
    private Listener fListener;
    private boolean blockListener = false;
    private ToolItem toolItem;
    private boolean enabled = true;
    private static IDialogSettings settings;

    private static IDialogSettings getDialogSettings() {
        if (settings != null) {
            return settings;
        }
        IDialogSettings topSettings = GdbUIPlugin.getDefault().getDialogSettings();
        settings = topSettings.getSection(ResourceClassContributionItem.class.getName());
        if (settings == null) {
            settings = topSettings.addNewSection(ResourceClassContributionItem.class.getName());
        }
        return settings;
    }

    public void setListener(Listener listener) {
        this.fListener = listener;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
        if (this.fResourceClassCombo != null) {
            this.fResourceClassCombo.setEnabled(enable);
        }
    }

    public String updateClasses(IGDBHardwareAndOS2.IResourceClass[] resourceClasses) {
        boolean different = false;
        if (this.resourceClasses.length != resourceClasses.length) {
            different = true;
        } else {
            int i = 0;
            while (i < this.resourceClasses.length) {
                if (!this.resourceClasses[i].getId().equals(resourceClasses[i].getId()) || !this.resourceClasses[i].getHumanDescription().equals(resourceClasses[i].getHumanDescription())) {
                    different = true;
                    break;
                }
                ++i;
            }
        }
        if (!different) {
            return this.fResourceClassId;
        }
        this.resourceClasses = resourceClasses;
        this.fResourceClassCombo.removeAll();
        int width = this.populateCombo();
        if (this.toolItem.getParent().isVisible()) {
            this.toolItem.setWidth(width);
        }
        return this.fResourceClassId;
    }

    private int populateCombo() {
        int width = 0;
        String lastResourceClassId = ResourceClassContributionItem.getDialogSettings().get("resourceClass");
        int index = -1;
        int i = 0;
        GC gc = new GC((Drawable)this.fResourceClassCombo);
        i = 0;
        while (i < this.resourceClasses.length) {
            String description = this.resourceClasses[i].getHumanDescription();
            width = Math.max(width, gc.textExtent((String)description).x);
            this.fResourceClassCombo.add(description);
            if (this.resourceClasses[i].getId().equals(lastResourceClassId)) {
                index = i;
            }
            ++i;
        }
        if (index != -1) {
            this.fResourceClassId = lastResourceClassId;
            this.blockListener = true;
            this.fResourceClassCombo.select(index);
            this.blockListener = false;
        }
        if (width == 0) {
            width = gc.textExtent((String)"Shared memory regions").x;
        }
        gc.dispose();
        return width += 64;
    }

    public String getResourceClassId() {
        return this.fResourceClassId;
    }

    public void fill(ToolBar parent, int toolbarItemIndex) {
        this.fResourceClassCombo = new Combo((Composite)parent, 0);
        this.fResourceClassCombo.setEnabled(this.enabled);
        int width = this.populateCombo();
        this.fResourceClassCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String description = ResourceClassContributionItem.this.fResourceClassCombo.getText();
                String id = null;
                int i = 0;
                while (i < ResourceClassContributionItem.this.resourceClasses.length) {
                    if (ResourceClassContributionItem.this.resourceClasses[i].getHumanDescription().equals(description)) {
                        id = ResourceClassContributionItem.this.resourceClasses[i].getId();
                        break;
                    }
                    ++i;
                }
                if (!$assertionsDisabled && id == null) {
                    throw new AssertionError();
                }
                if (id != null && !id.equals(ResourceClassContributionItem.this.fResourceClassId)) {
                    ResourceClassContributionItem.this.fResourceClassId = id;
                    ResourceClassContributionItem.getDialogSettings().put("resourceClass", id);
                    if (ResourceClassContributionItem.this.fListener != null && !ResourceClassContributionItem.this.blockListener) {
                        ResourceClassContributionItem.this.fListener.resourceClassChanged(ResourceClassContributionItem.this.fResourceClassId);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.toolItem = new ToolItem(parent, 2);
        this.toolItem.setControl((Control)this.fResourceClassCombo);
        this.toolItem.setWidth(width);
    }

    public boolean isDynamic() {
        return false;
    }

    static interface Listener {
        public void resourceClassChanged(String var1);
    }
}

